/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources.services;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.platform.web.http.api.resources.utils.SystemUtils;

public class SystemService {
    private static SystemService systemService;

    public static SystemService getSystemService() {
        if (systemService == null && (systemService = (SystemService)PentahoSystem.get(SystemService.class)) == null) {
            systemService = new SystemService();
        }
        return systemService;
    }

    public Document getUsers() throws ServletException, IOException, IllegalAccessException {
        if (!this.canAdminister()) {
            throw new IllegalAccessException();
        }
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("users");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List users = service.getAllUsers();
            Iterator usersIterator = users.iterator();
            while (usersIterator.hasNext()) {
                String username = ((String)usersIterator.next()).toString();
                if (null == username || username.length() <= 0) continue;
                rootElement.addElement("user").setText(username);
            }
        }
        return doc;
    }

    public Document getRoles() throws ServletException, IOException {
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("roles");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List roles = service.getAllRoles();
            Iterator rolesIterator = roles.iterator();
            while (rolesIterator.hasNext()) {
                String roleName = ((String)rolesIterator.next()).toString();
                if (null == roleName || roleName.length() <= 0) continue;
                rootElement.addElement("role").setText(roleName);
            }
        }
        return doc;
    }

    public Document getRolesForUser(String user) throws ServletException, IOException {
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("roles");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List roles = service.getRolesForUser(null, user);
            Iterator rolesIterator = roles.iterator();
            while (rolesIterator.hasNext()) {
                String roleName = ((String)rolesIterator.next()).toString();
                if (null == roleName || roleName.length() <= 0) continue;
                rootElement.addElement("role").setText(roleName);
            }
        }
        return doc;
    }

    public Document getUsersInRole(String role) throws ServletException, IOException {
        IUserRoleListService service = (IUserRoleListService)PentahoSystem.get(IUserRoleListService.class);
        DefaultElement rootElement = new DefaultElement("users");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (service != null) {
            List users = service.getUsersInRole(null, role);
            Iterator usersIterator = users.iterator();
            while (usersIterator.hasNext()) {
                String username = ((String)usersIterator.next()).toString();
                if (null == username || username.length() <= 0) continue;
                rootElement.addElement("user").setText(username);
            }
        }
        return doc;
    }

    public Document getPermissions() throws ServletException, IOException {
        Map validPermissionsNameMap = PentahoAclEntry.getValidPermissionsNameMap((String)"all");
        DefaultElement rootElement = new DefaultElement("acls");
        Document doc = DocumentHelper.createDocument((Element)rootElement);
        if (validPermissionsNameMap != null) {
            Set aclsKeySet = validPermissionsNameMap.keySet();
            Iterator aclsIterator = aclsKeySet.iterator();
            while (aclsIterator.hasNext()) {
                String aclMask;
                String aclName = aclsIterator.next().toString();
                String string = aclMask = null != validPermissionsNameMap.get(aclName) ? validPermissionsNameMap.get(aclName).toString() : null;
                if (null == aclName || aclName.length() <= 0 || null == aclMask || aclMask.length() <= 0) continue;
                Element aclElement = rootElement.addElement("acl");
                aclElement.addElement("name").setText(aclName);
                aclElement.addElement("mask").setText(aclMask);
            }
        }
        return doc;
    }

    public Document getAll() throws ServletException, IOException, IllegalAccessException {
        Document userDoc = this.getUsers();
        Document roleDoc = this.getRoles();
        Document permissionDoc = this.getPermissions();
        return this.mergeAllDocument(new Document[]{userDoc, roleDoc, permissionDoc});
    }

    private Document mergeAllDocument(Document[] documents) {
        Document document = DocumentHelper.createDocument();
        DefaultElement element = new DefaultElement("content");
        document.add((Element)element);
        for (Document contentDocument : documents) {
            if (contentDocument == null || contentDocument.getRootElement() == null) continue;
            element.add(contentDocument.getRootElement());
        }
        return document;
    }

    protected boolean canAdminister() {
        return SystemUtils.canAdminister();
    }
}

