/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.context;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.web.hsqldb.HsqlDatabaseStarterBean;
import org.pentaho.platform.web.hsqldb.messages.Messages;

public class HsqldbStartupListener
implements ServletContextListener {
    private static final Log logger = LogFactory.getLog(HsqldbStartupListener.class);

    public void contextDestroyed(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        Object obj = ctx.getAttribute("hsqldb-starter-bean");
        if (obj != null) {
            logger.debug((Object)"Context listener stopping Embedded HSQLDB");
            HsqlDatabaseStarterBean starterBean = (HsqlDatabaseStarterBean)obj;
            starterBean.stop();
        }
    }

    private Map<String, String> getDatabases(ServletContext ctx) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String dbs = ctx.getInitParameter("hsqldb-databases");
        String[] dbEntries = dbs.split(",");
        for (int i = 0; i < dbEntries.length; ++i) {
            String[] entry = dbEntries[i].split("@");
            if (entry.length != 2 || StringUtils.isEmpty((String)entry[0]) || StringUtils.isEmpty((String)entry[1])) {
                logger.equals(Messages.getErrorString("HsqlDatabaseStartupListener.ERROR_0001_HSQLDB_ENTRY_MALFORMED"));
                continue;
            }
            map.put(entry[0], entry[1]);
        }
        return map;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext ctx = sce.getServletContext();
        logger.debug((Object)"Starting HSQLDB Embedded Listener");
        HsqlDatabaseStarterBean starterBean = new HsqlDatabaseStarterBean();
        String port = ctx.getInitParameter("hsqldb-port");
        int portNum = -1;
        if (port != null) {
            logger.debug((Object)String.format("Port override specified: %s", port));
            try {
                portNum = Integer.parseInt(port);
                starterBean.setPort(portNum);
            }
            catch (NumberFormatException ex) {
                logger.error((Object)Messages.getErrorString("HsqldbStartupListener.ERROR_0004_INVALID_PORT", "9001"));
                port = null;
            }
        }
        starterBean.setDatabases(this.getDatabases(ctx));
        String sampleDataAllowPortFailover = ctx.getInitParameter("hsqldb-allow-port-failover");
        if (sampleDataAllowPortFailover != null && sampleDataAllowPortFailover.equalsIgnoreCase("true")) {
            logger.debug((Object)String.format("Allow Port Failover specified", new Object[0]));
            starterBean.setAllowPortFailover(true);
        }
        if (starterBean.start()) {
            ctx.setAttribute("hsqldb-starter-bean", (Object)starterBean);
        }
    }
}

