/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;

public class ProxyTrustingFilter
implements Filter {
    FilterConfig filterConfig;
    private static final String DefaultParameterName = "_TRUST_USER_";
    String[] trustedIpAddrs = null;
    private boolean checkHeader = true;
    private String requestParameterName;
    private String headerName;
    private Map<String, Pattern> ipPatterns = new HashMap<String, Pattern>();
    private static final Log logger = LogFactory.getLog(ProxyTrustingFilter.class);

    public Log getLogger() {
        return logger;
    }

    public void init(FilterConfig filterConfiguration) throws ServletException {
        String requestParameterSetting;
        String checkHeaderString;
        this.filterConfig = filterConfiguration;
        this.trustedIpAddrs = null;
        String hostStr = this.filterConfig.getInitParameter("TrustedIpAddrs");
        if (hostStr != null) {
            StringTokenizer st = new StringTokenizer(hostStr, ",");
            ArrayList<String> addrs = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.length() <= 0) continue;
                addrs.add(tok);
            }
            if (addrs.size() > 0) {
                this.trustedIpAddrs = addrs.toArray(new String[0]);
            }
        }
        if (!this.isEmpty(checkHeaderString = this.filterConfig.getInitParameter("CheckHeader"))) {
            this.checkHeader = checkHeaderString.equalsIgnoreCase("true");
        }
        this.requestParameterName = !this.isEmpty(requestParameterSetting = this.filterConfig.getInitParameter("RequestParameterName")) ? requestParameterSetting : DefaultParameterName;
        String headerNameSetting = this.filterConfig.getInitParameter("HeaderName");
        this.headerName = !this.isEmpty(headerNameSetting) ? headerNameSetting : DefaultParameterName;
    }

    boolean isTrusted(String addr) {
        if (this.trustedIpAddrs != null) {
            for (String element : this.trustedIpAddrs) {
                Matcher matcher;
                if (element.equals(addr)) {
                    return true;
                }
                Pattern pat = this.ipPatterns.get(element);
                if (pat == null) {
                    try {
                        pat = Pattern.compile(element);
                        this.ipPatterns.put(element, pat);
                    }
                    catch (PatternSyntaxException ignored) {
                        continue;
                    }
                }
                if (!(matcher = pat.matcher(addr)).find()) continue;
                return true;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String name;
        HttpServletRequest req;
        String remoteHost;
        if (this.trustedIpAddrs != null && request instanceof HttpServletRequest && this.isTrusted(remoteHost = (req = (HttpServletRequest)request).getRemoteAddr()) && !this.isEmpty(name = this.getTrustUser(req))) {
            try {
                SecurityHelper.getInstance().runAsUser(name, (Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        HttpSession httpSession = req.getSession();
                        httpSession.setAttribute("pentaho-session-context", (Object)PentahoSessionHolder.getSession());
                        SecurityContext authWrapper = new SecurityContext(){
                            private static final long serialVersionUID = 1L;
                            private Authentication authentication;

                            public Authentication getAuthentication() {
                                return this.authentication;
                            }

                            public void setAuthentication(Authentication authentication) {
                                this.authentication = authentication;
                            }
                        };
                        authWrapper.setAuthentication(SecurityContextHolder.getContext().getAuthentication());
                        httpSession.setAttribute("SPRING_SECURITY_CONTEXT", (Object)authWrapper);
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public static void main(String[] args) {
    }

    protected String getHeaderName() {
        return this.headerName;
    }

    protected String getParameterName() {
        return this.requestParameterName;
    }

    protected boolean checkHeader() {
        return this.checkHeader;
    }

    protected String getTrustUser(HttpServletRequest request) {
        String name = request.getParameter(this.getParameterName());
        if (this.checkHeader() && this.isEmpty(name)) {
            name = request.getHeader(this.normalizeHeaderName(this.getHeaderName()));
        }
        return name;
    }

    public boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    protected String normalizeHeaderName(String in) {
        String lower = in.toLowerCase();
        return Character.toUpperCase(lower.charAt(0)) + lower.substring(1);
    }
}

