/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.esapi.ESAPI;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.MimeHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class GenericServlet
extends ServletBase {
    private static final long serialVersionUID = 6713118348911206464L;
    private static final Log logger = LogFactory.getLog(GenericServlet.class);
    private static final String CACHE_FILE = "file";
    private static ICacheManager cache = PentahoSystem.getCacheManager(null);
    private boolean showDeprecationMessage;

    @Override
    public Log getLogger() {
        return logger;
    }

    public void init() throws ServletException {
        super.init();
        String value = this.getServletConfig().getInitParameter("showDeprecationMessage");
        this.showDeprecationMessage = Boolean.parseBoolean(value);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object[] objectArray;
        InputStream resourceStream;
        if (this.showDeprecationMessage) {
            String deprecationMessage = "GenericServlet is deprecated and should no longer be handling requests. More detail below...\n | You have issued a {0} request to {1} from referer {2} \n | Please consider using one of the following REST services instead:\n | * GET /api/repos/<pluginId>/<path> to read files from a plugin public dir\n | * POST|GET /api/repos/<pathId>/generatedContent to create content resulting from execution of a repo file\n | * POST|GET /api/repos/<pluginId>/<contentGeneratorId> to execute a content generator by name (RPC compatibility service)\n \\ To turn this message off, set init-param 'showDeprecationMessage' to false in the GenericServlet declaration";
            String referer = StringUtils.defaultString((String)request.getHeader("Referer"), (String)"");
            logger.warn((Object)MessageFormat.format(deprecationMessage, request.getMethod(), request.getRequestURL(), referer));
        }
        PentahoSystem.systemEntryPoint();
        IOutputHandler outputHandler = null;
        ClassLoader origContextClassloader = Thread.currentThread().getContextClassLoader();
        try {
            String pluginId;
            String pathInfo;
            block26: {
                SimpleParameterProvider headerParams;
                IPluginManager pluginManager;
                IPentahoSession session;
                SimpleParameterProvider pathParams;
                String urlPath;
                String contentGeneratorId;
                block25: {
                    ServletInputStream in = request.getInputStream();
                    String servletPath = request.getServletPath();
                    pathInfo = request.getPathInfo();
                    contentGeneratorId = "";
                    urlPath = "";
                    pathParams = new SimpleParameterProvider();
                    if (StringUtils.isEmpty((String)pathInfo)) {
                        logger.error((Object)Messages.getInstance().getErrorString("GenericServlet.ERROR_0005_NO_RESOURCE_SPECIFIED"));
                        response.sendError(403);
                        return;
                    }
                    String path = pathInfo.substring(1);
                    int slashPos = path.indexOf(47);
                    if (slashPos != -1) {
                        pathParams.setParameter("path", pathInfo.substring(slashPos + 1));
                        contentGeneratorId = path.substring(0, slashPos);
                    } else {
                        contentGeneratorId = path;
                    }
                    urlPath = "content/" + contentGeneratorId;
                    pathParams.setParameter("query", request.getQueryString());
                    pathParams.setParameter("contentType", request.getContentType());
                    pathParams.setParameter("inputstream", (Object)in);
                    pathParams.setParameter("httpresponse", (Object)response);
                    pathParams.setParameter("httprequest", (Object)request);
                    pathParams.setParameter("remoteaddr", request.getRemoteAddr());
                    this.debug("GenericServlet contentGeneratorId=" + contentGeneratorId);
                    this.debug("GenericServlet urlPath=" + urlPath);
                    session = this.getPentahoSession(request);
                    pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)session);
                    if (pluginManager == null) {
                        ServletOutputStream out = response.getOutputStream();
                        String message = Messages.getInstance().getErrorString("GenericServlet.ERROR_0001_BAD_OBJECT", new Object[]{IPluginManager.class.getSimpleName()});
                        this.error(message);
                        out.write(message.getBytes());
                        return;
                    }
                    headerParams = new SimpleParameterProvider();
                    Enumeration names = request.getHeaderNames();
                    while (names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        String value = request.getHeader(name);
                        headerParams.setParameter(name, value);
                    }
                    pluginId = pluginManager.getServicePlugin(pathInfo);
                    if (pluginId == null || !pluginManager.isStaticResource(pathInfo)) break block25;
                    boolean cacheOn = "true".equals(pluginManager.getPluginSetting(pluginId, "settings/cache", "false"));
                    String maxAge = (String)pluginManager.getPluginSetting(pluginId, "settings/max-age", null);
                    this.allowBrowserCache(maxAge, (IParameterProvider)pathParams);
                    String mimeType = MimeHelper.getMimeTypeFromFileName((String)pathInfo);
                    if (mimeType != null) {
                        response.setContentType(mimeType);
                    }
                    ServletOutputStream out = response.getOutputStream();
                    ByteArrayOutputStream byteStream = null;
                    if (cacheOn) {
                        byteStream = (ByteArrayOutputStream)cache.getFromRegionCache(CACHE_FILE, (Object)pathInfo);
                    }
                    if (byteStream != null) {
                        IOUtils.write((byte[])byteStream.toByteArray(), (OutputStream)out);
                        return;
                    }
                    resourceStream = pluginManager.getStaticResource(pathInfo);
                    if (resourceStream == null) break block26;
                    byteStream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)resourceStream, (OutputStream)byteStream);
                    if (cacheOn) {
                        cache.putInRegionCache(CACHE_FILE, (Object)pathInfo, (Object)byteStream);
                    }
                    IOUtils.write((byte[])byteStream.toByteArray(), (OutputStream)out);
                    return;
                }
                IContentGenerator contentGenerator = (IContentGenerator)pluginManager.getBean(contentGeneratorId);
                if (contentGenerator == null) {
                    ServletOutputStream out = response.getOutputStream();
                    String message = Messages.getInstance().getErrorString("GenericServlet.ERROR_0002_BAD_GENERATOR", new Object[]{ESAPI.encoder().encodeForHTML(contentGeneratorId)});
                    this.error(message);
                    out.write(message.getBytes());
                    return;
                }
                Thread.currentThread().setContextClassLoader(pluginManager.getClassLoader(pluginId));
                HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
                HttpMimeTypeListener listener = new HttpMimeTypeListener(request, response);
                outputHandler = this.getOutputHandler(response, true);
                outputHandler.setMimeTypeListener((IMimeTypeListener)listener);
                HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(session);
                IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
                HashMap<String, SimpleParameterProvider> parameterProviders = new HashMap<String, SimpleParameterProvider>();
                parameterProviders.put("request", requestParameters);
                parameterProviders.put("session", sessionParameters);
                parameterProviders.put("headers", headerParams);
                parameterProviders.put("path", pathParams);
                SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath() + urlPath + "?");
                ArrayList messages = new ArrayList();
                contentGenerator.setOutputHandler(outputHandler);
                contentGenerator.setMessagesList(messages);
                contentGenerator.setParameterProviders(parameterProviders);
                contentGenerator.setSession(session);
                contentGenerator.setUrlFactory((IPentahoUrlFactory)urlFactory);
                contentGenerator.createContent();
                this.debug("Generic Servlet content generate successfully");
                return;
            }
            objectArray = new Object[]{pluginId, pathInfo};
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            this.error(Messages.getInstance().getErrorString("GenericServlet.ERROR_0002_BAD_GENERATOR", new Object[]{request.getQueryString()}), e);
            ArrayList<String> errorList = new ArrayList<String>();
            String msg = e.getMessage();
            errorList.add(msg);
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)PentahoSessionHolder.getSession())).formatFailureMessage("text/html", null, buffer, errorList);
            response.getOutputStream().write(buffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
            return;
        }
        logger.error((Object)Messages.getInstance().getErrorString("GenericServlet.ERROR_0004_RESOURCE_NOT_FOUND", objectArray));
        response.sendError(404);
        return;
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origContextClassloader);
            PentahoSystem.systemExitPoint();
        }
    }

    protected void allowBrowserCache(String maxAge, IParameterProvider pathParams) {
        if (maxAge == null || "0".equals(maxAge)) {
            return;
        }
        HttpServletResponse response = (HttpServletResponse)pathParams.getParameter("httpresponse");
        if (response != null) {
            response.setHeader("Cache-Control", "max-age=" + maxAge);
        }
    }

    protected IOutputHandler getOutputHandler(HttpServletResponse response, boolean allowFeedback) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        HttpOutputHandler handler = new HttpOutputHandler(response, (OutputStream)out, allowFeedback);
        return handler;
    }

    static {
        if (cache != null) {
            cache.addCacheRegion(CACHE_FILE);
        }
    }
}

