/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.File;
import javax.servlet.ServletContext;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.web.servlet.AbstractGwtRpcProxyServlet;
import org.pentaho.platform.web.servlet.GwtRpcProxyException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class GwtRpcProxyServlet
extends AbstractGwtRpcProxyServlet {
    @Override
    protected Object resolveDispatchTarget(String servletContextPath) {
        String beanId;
        ApplicationContext beanFactory = this.getAppContext();
        if (servletContextPath.startsWith("/")) {
            servletContextPath = servletContextPath.substring(1);
        }
        if (!beanFactory.containsBean(beanId = servletContextPath.replaceAll("/", "-"))) {
            throw new GwtRpcProxyException(Messages.getInstance().getErrorString("GwtRpcProxyServlet.ERROR_0001_NO_BEAN_FOUND_FOR_SERVICE", new Object[]{beanId, servletContextPath}));
        }
        Object target = beanFactory.getBean(beanId);
        return target;
    }

    protected ApplicationContext getAppContext() {
        WebApplicationContext parent = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        XmlWebApplicationContext wac = new XmlWebApplicationContext(){

            protected Resource getResourceByPath(String path) {
                return new FileSystemResource(new File(path));
            }
        };
        wac.setParent((ApplicationContext)parent);
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getServletName());
        String springFile = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentahoServices.spring.xml");
        wac.setConfigLocations(new String[]{springFile});
        wac.refresh();
        return wac;
    }
}

