/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import javax.sql.DataSource;
import mondrian.spi.DataSourceResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.messages.Messages;

public class PentahoDataSourceResolver
implements DataSourceResolver {
    private static final Log logger = LogFactory.getLog(PentahoDataSourceResolver.class);

    public DataSource lookup(String dataSourceName) throws Exception {
        try {
            IDBDatasourceService datasourceSvc = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, PentahoSessionHolder.getSession());
            DataSource datasource = datasourceSvc.getDataSource(datasourceSvc.getDSUnboundName(dataSourceName));
            return datasource;
        }
        catch (ObjectFactoryException e) {
            logger.error((Object)Messages.getInstance().getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
            throw e;
        }
        catch (DBDatasourceServiceException e) {
            logger.error((Object)Messages.getInstance().getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
            throw e;
        }
    }
}

