/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enumerator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.janino.util.enumerator.Enumerator;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;
import org.codehaus.janino.util.enumerator.EnumeratorSetTypeException;

public class EnumeratorSet {
    private final Class enumeratorClass;
    private final Set values;
    String optionalName = null;
    private static final Map namedEnumeratorSets = new HashMap();

    private EnumeratorSet(Class enumeratorClass, Set values) {
        this.enumeratorClass = enumeratorClass;
        this.values = values;
    }

    public EnumeratorSet(Class enumeratorClass) {
        this(enumeratorClass, new HashSet());
    }

    public EnumeratorSet(Class enumeratorClass, boolean full) {
        this(enumeratorClass, new HashSet());
        if (full) {
            this.values.addAll(Enumerator.getInstances(enumeratorClass).values());
        }
    }

    public EnumeratorSet(Class enumeratorClass, String s) throws EnumeratorFormatException {
        this(enumeratorClass, s, ",");
    }

    public EnumeratorSet(Class enumeratorClass, String s, String delimiter) throws EnumeratorFormatException {
        Set<Enumerator> vs = new HashSet<Enumerator>();
        Map des = Enumerator.getInstances(enumeratorClass);
        Map dess = EnumeratorSet.getNamedEnumeratorSets(enumeratorClass);
        StringTokenizer st = new StringTokenizer(s, delimiter);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            Enumerator value = (Enumerator)des.get(name);
            if (value != null) {
                vs.add(value);
                continue;
            }
            EnumeratorSet es = (EnumeratorSet)dess.get(name);
            if (es != null) {
                if (vs.isEmpty()) {
                    vs = es.values;
                    this.optionalName = es.optionalName;
                    continue;
                }
                vs.addAll(es.values);
                continue;
            }
            throw new EnumeratorFormatException(name);
        }
        this.enumeratorClass = enumeratorClass;
        this.values = vs;
    }

    public EnumeratorSet(EnumeratorSet that) {
        this(that.enumeratorClass, that.values);
    }

    public EnumeratorSet add(Enumerator value) {
        if (value.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot add value of type \"" + value.getClass() + "\" to set of different type \"" + this.enumeratorClass + "\"");
        }
        HashSet<Enumerator> vs = new HashSet<Enumerator>(this.values);
        vs.add(value);
        return new EnumeratorSet(this.enumeratorClass, vs);
    }

    public EnumeratorSet add(EnumeratorSet that) {
        HashSet vs;
        if (that.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot add set of type \"" + that.enumeratorClass + "\" to set of different type \"" + this.enumeratorClass + "\"");
        }
        if (this.values.isEmpty()) {
            vs = that.values;
        } else if (that.values.isEmpty()) {
            vs = this.values;
        } else {
            vs = new HashSet(this.values);
            vs.addAll(that.values);
        }
        return new EnumeratorSet(this.enumeratorClass, vs);
    }

    public EnumeratorSet remove(Enumerator value) {
        if (value.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot remove value of type \"" + value.getClass() + "\" from set of different type \"" + this.enumeratorClass + "\"");
        }
        if (!this.values.contains(value)) {
            return this;
        }
        HashSet vs = new HashSet(this.values);
        vs.remove(value);
        return new EnumeratorSet(this.enumeratorClass, vs);
    }

    public EnumeratorSet remove(EnumeratorSet that) {
        if (that.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot remove set of type \"" + that.enumeratorClass + "\" from set of different type \"" + this.enumeratorClass + "\"");
        }
        HashSet vs = new HashSet(this.values);
        vs.removeAll(that.values);
        return new EnumeratorSet(this.enumeratorClass, vs);
    }

    public boolean contains(Enumerator value) {
        if (value.getClass() != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot check value of type \"" + value.getClass() + "\" within set of different type \"" + this.enumeratorClass + "\"");
        }
        return this.values.contains(value);
    }

    public boolean containsAnyOf(EnumeratorSet that) {
        if (that.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot compare set of type \"" + that.enumeratorClass + "\" with set of different type \"" + this.enumeratorClass + "\"");
        }
        Iterator it = that.values.iterator();
        while (it.hasNext()) {
            if (!this.values.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAllOf(EnumeratorSet that) {
        if (that.enumeratorClass != this.enumeratorClass) {
            throw new EnumeratorSetTypeException("Cannot compare set of type \"" + that.enumeratorClass + "\" with set of different type \"" + this.enumeratorClass + "\"");
        }
        return this.values.containsAll(that.values);
    }

    public EnumeratorSet setName(String optionalName) {
        if (this.optionalName == optionalName || this.optionalName != null && this.optionalName.equals(optionalName)) {
            return this;
        }
        Map namedEnumeratorSets = EnumeratorSet.getNamedEnumeratorSets(this.enumeratorClass);
        if (this.optionalName != null) {
            namedEnumeratorSets.remove(this.optionalName);
        }
        this.optionalName = optionalName;
        if (this.optionalName != null) {
            namedEnumeratorSets.put(this.optionalName, this);
        }
        return this;
    }

    private static Map getNamedEnumeratorSets(Class enumeratorClass) {
        HashMap m = (HashMap)namedEnumeratorSets.get(enumeratorClass);
        if (m == null) {
            m = new HashMap();
            namedEnumeratorSets.put(enumeratorClass, m);
        }
        return m;
    }

    public boolean equals(Object that) {
        return that instanceof EnumeratorSet && ((Object)this.values).equals(((EnumeratorSet)that).values);
    }

    public int hashCode() {
        return ((Object)this.values).hashCode();
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String delimiter) {
        if (this.optionalName != null) {
            return this.optionalName;
        }
        Iterator it = this.values.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(((Enumerator)it.next()).name);
        while (it.hasNext()) {
            sb.append(delimiter).append(((Enumerator)it.next()).name);
        }
        return sb.toString();
    }
}

