/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;
import org.pentaho.ui.xul.swing.SwingRoot;
import org.pentaho.ui.xul.util.Direction;
import org.pentaho.ui.xul.util.Orient;

public class SwingButton
extends SwingElement
implements XulButton {
    private static final Log logger = LogFactory.getLog(SwingButton.class);
    private String image;
    private Direction dir;
    private String group;
    private XulButton.Type type;
    private ButtonGroup buttonGroup;
    private XulDomContainer domContainer;
    private String onclick;
    private boolean selected;

    public SwingButton(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("button");
        this.setManagedObject(new JButton());
        this.domContainer = domContainer;
    }

    public SwingButton() {
        this(null, null, null, null);
    }

    protected AbstractButton getButton() {
        return (AbstractButton)this.getManagedObject();
    }

    public void onDomReady() {
        if (this.group != null && this.getDocument() != null && this.getDocument().getRootElement() instanceof SwingRoot) {
            this.buttonGroup = ((SwingRoot)this.getDocument().getRootElement()).getButtonGroup(this.group);
            AbstractButton button = (AbstractButton)this.getManagedObject();
            this.buttonGroup.add(button);
            if (this.buttonGroup.getButtonCount() == 1) {
                button.setSelected(true);
            }
        }
    }

    protected void setButton(AbstractButton button) {
        if (button == null) {
            throw new NullPointerException();
        }
        this.setManagedObject(button);
    }

    public void setLabel(String label) {
        this.getButton().setText(label);
    }

    public void setOnclick(String method) {
        this.onclick = method;
        this.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.invokeLater(new OnClickRunnable());
            }
        });
    }

    public String getOnclick() {
        return this.onclick;
    }

    public String getLabel() {
        return this.getButton().getText();
    }

    @Override
    public boolean isDisabled() {
        return !this.getButton().isEnabled();
    }

    @Override
    public void setDisabled(boolean dis) {
        AbstractButton button = this.getButton();
        boolean previous = !button.isEnabled();
        button.setEnabled(!dis);
        this.changeSupport.firePropertyChange("disabled", previous, dis);
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String src) {
        try {
            this.image = src;
            URL rootDir = SwingButton.class.getClassLoader().getResource(this.domContainer.getXulLoader().getRootDir());
            URL iconPath = new URL(rootDir, src);
            ImageIcon ico = new ImageIcon(iconPath);
            if (ico == null) {
                logger.error((Object)("Image could not be found: " + ico));
            } else {
                this.getButton().setIcon(ico);
            }
        }
        catch (MalformedURLException e) {
            logger.error((Object)"Could not find resource");
            logger.error((Object)(this.domContainer.getXulLoader().getRootDir() + src));
        }
    }

    public String getDir() {
        if (this.dir == null) {
            return null;
        }
        return this.dir.toString().toLowerCase();
    }

    public void setDir(String dir) {
        this.dir = Direction.valueOf((String)dir.toUpperCase());
    }

    @Override
    public void layout() {
        if (this.type == XulButton.Type.CHECKBOX || this.type == XulButton.Type.RADIO) {
            AbstractButton oldButton = this.getButton();
            JToggleButton button = new JToggleButton();
            button.setText(oldButton.getText());
            button.setIcon(oldButton.getIcon());
            button.setEnabled(oldButton.isEnabled());
            button.setSelected(this.selected);
            this.setButton(button);
            if (this.getOnclick() != null) {
                this.setOnclick(this.getOnclick());
            }
        }
        AbstractButton button = this.getButton();
        if (this.orientation == Orient.VERTICAL) {
            button.setHorizontalTextPosition(0);
            if (this.dir == Direction.FORWARD) {
                button.setVerticalTextPosition(3);
            } else {
                button.setVerticalTextPosition(1);
            }
        } else {
            button.setVerticalTextPosition(0);
            if (this.dir == Direction.FORWARD) {
                button.setHorizontalTextPosition(4);
            } else {
                button.setHorizontalTextPosition(2);
            }
        }
        Icon icon = button.getIcon();
        if ("".equals(button.getText()) && icon != null && icon.getIconHeight() == icon.getIconWidth()) {
            Dimension dim = button.getPreferredSize();
            button.setMinimumSize(new Dimension(dim.height, dim.height));
            button.setPreferredSize(new Dimension(dim.height, dim.height));
        }
        button.setToolTipText(this.getTooltiptext());
        super.layout();
    }

    public String getGroup() {
        return this.group;
    }

    public String getType() {
        if (this.type == null) {
            return null;
        }
        return this.type.toString();
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setType(String type) {
        this.type = XulButton.Type.valueOf((String)type.toString().toUpperCase());
    }

    public void setSelected(String selected) {
        this.selected = Boolean.parseBoolean(selected);
        this.getButton().setSelected(this.selected);
    }

    public boolean isSelected() {
        return this.getButton().isSelected();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.getButton().setSelected(this.selected);
    }

    public void doClick() {
        this.getButton().doClick();
    }

    private class OnClickRunnable
    implements Runnable {
        @Override
        public void run() {
            String method = SwingButton.this.getOnclick();
            if (method == null) {
                return;
            }
            try {
                Document doc = SwingButton.this.getDocument();
                XulRoot window = (XulRoot)doc.getRootElement();
                XulDomContainer con = window.getXulDomContainer();
                con.invoke(method, new Object[0]);
            }
            catch (XulException e) {
                logger.error((Object)("Error calling oncommand event: " + method), (Throwable)e);
            }
        }
    }
}

