/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulDomException;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.InlineBindingExpression;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.components.XulTreeCol;
import org.pentaho.ui.xul.containers.XulManagedCollection;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeChildren;
import org.pentaho.ui.xul.containers.XulTreeCols;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.SwingBinding;
import org.pentaho.ui.xul.swing.messages.Messages;
import org.pentaho.ui.xul.swing.tags.SwingTreeCell;
import org.pentaho.ui.xul.swing.tags.SwingTreeCol;
import org.pentaho.ui.xul.swing.tags.SwingTreeItem;
import org.pentaho.ui.xul.util.ColumnType;
import org.pentaho.ui.xul.util.TreeCellEditor;
import org.pentaho.ui.xul.util.TreeCellEditorCallback;
import org.pentaho.ui.xul.util.TreeCellRenderer;

public class SwingTree
extends AbstractSwingContainer
implements XulTree {
    private JTable table;
    private JTree tree;
    private ListSelectionListener selectionListener;
    private TreeSelectionListener treeSelectionListener;
    MouseListener popupListener;
    private JScrollPane scrollpane;
    private TableColumnModel columnModel;
    private TableModel tableModel;
    private XulTreeChildren rootChildren;
    private boolean columnDrag = true;
    private boolean disabled = false;
    private boolean editable = false;
    private String onselect;
    private String onedit = null;
    private static final Log logger = LogFactory.getLog(SwingTree.class);
    private Vector<String> columnNames = new Vector();
    private boolean isHierarchical = false;
    private Map<String, TreeCellEditor> customEditors = new HashMap<String, TreeCellEditor>();
    private SELECTION_MODE selType = SELECTION_MODE.SINGLE;
    private XulDomContainer domContainer;
    private String command;
    private String newItemBinding;
    private boolean autoCreateNewRows;
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem addRowMenu = new JMenuItem(Messages.getString("SwingTree.insert"));
    JMenuItem deleteRowMenu = new JMenuItem(Messages.getString("SwingTree.deleteRow"));
    JMenuItem deleteRowsMenu = new JMenuItem(Messages.getString("SwingTree.deleteRows"));
    JMenuItem keepOnlyRowsMenu = new JMenuItem(Messages.getString("SwingTree.keepOnlyRows"));
    private XulTreeCols columns;
    private int rows = -1;
    private int totalFlex = 0;
    int numOfListeners = 0;
    private TreeModel treeModel;
    private boolean suppressEvents = false;
    private Collection elements;
    private boolean expanded;

    public SwingTree(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("tree");
        this.domContainer = domContainer;
        this.registerCellEditor("custom-editor", new CustomTreeCellEditor());
        this.addRowMenu.addActionListener(new InsertRowsActionAdapter(this));
        this.deleteRowMenu.addActionListener(new DeleteRowsActionAdapter(this));
        this.deleteRowsMenu.addActionListener(new DeleteRowsActionAdapter(this));
        this.keepOnlyRowsMenu.addActionListener(new KeepOnlyRowsActionAdapter(this));
        this.popupMenu.add(this.addRowMenu);
        this.popupMenu.add(this.deleteRowMenu);
        this.popupMenu.add(this.deleteRowsMenu);
        this.popupMenu.add(this.keepOnlyRowsMenu);
    }

    public JTable getTable() {
        return this.table;
    }

    public JTree getTree() {
        return this.tree;
    }

    public int[] getActiveCellCoordinates() {
        return new int[]{this.table.getSelectedRow(), this.table.getSelectedColumn()};
    }

    public XulTreeCols getColumns() {
        return this.columns;
    }

    public String getOnselect() {
        return this.onselect;
    }

    public XulTreeChildren getRootChildren() {
        if (this.rootChildren == null) {
            this.rootChildren = (XulTreeChildren)this.getChildNodes().get(1);
        }
        return this.rootChildren;
    }

    public int getRows() {
        return this.getRootChildren().getItemCount();
    }

    public String getSeltype() {
        return this.selType.toString();
    }

    public Object[][] getValues() {
        TableModel model = this.table.getModel();
        Object[][] data = new Object[this.getRootChildren().getChildNodes().size()][model.getColumnCount()];
        int y = 0;
        for (XulComponent item : this.getRootChildren().getChildNodes()) {
            int x = 0;
            for (XulComponent tempCell : ((XulTreeItem)item).getRow().getChildNodes()) {
                SwingTreeCell cell = (SwingTreeCell)tempCell;
                switch (this.columns.getColumn(x).getColumnType()) {
                    case CHECKBOX: {
                        Boolean flag = (Boolean)cell.getValue();
                        if (flag == null) {
                            flag = Boolean.FALSE;
                        }
                        data[y][x] = flag;
                        break;
                    }
                    case COMBOBOX: {
                        Vector values = (Vector)cell.getValue();
                        int idx = cell.getSelectedIndex();
                        data[y][x] = values.get(idx);
                        break;
                    }
                    default: {
                        data[y][x] = cell.getLabel();
                    }
                }
                ++x;
            }
            ++y;
        }
        return data;
    }

    public int getWidth() {
        return this.scrollpane.getWidth();
    }

    public void setWidth(int width) {
        if (this.tree == null || this.table == null) {
            return;
        }
        int height = this.table != null ? this.table.getHeight() : (this.tree != null ? this.tree.getHeight() : this.scrollpane.getHeight());
        Dimension dim = new Dimension(width, height);
        this.scrollpane.setPreferredSize(dim);
        this.scrollpane.setMaximumSize(dim);
        this.scrollpane.setSize(dim);
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnableColumnDrag() {
        return this.columnDrag;
    }

    public boolean isHierarchical() {
        return false;
    }

    public void setActiveCellCoordinates(int row, int column) {
        this.table.changeSelection(row, column, false, false);
    }

    @Override
    public void setDisabled(boolean dis) {
        this.disabled = dis;
        if (this.table != null) {
            this.table.setEnabled(!this.disabled);
        }
    }

    public void setEditable(boolean edit) {
        this.editable = edit;
    }

    public void setEnableColumnDrag(boolean drag) {
        this.columnDrag = drag;
        if (this.table != null) {
            this.table.getTableHeader().setReorderingAllowed(drag);
        }
    }

    public void setOnselect(final String select) {
        this.selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                SwingTree.this.invoke(select, new Object[]{new Integer(SwingTree.this.table.getSelectedRow())});
            }
        };
        if (this.table != null) {
            this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (SwingTree.this.tree != null) {
                    SwingTree.this.invoke(select, new Object[]{SwingTree.this.tree.getSelectionRows()[0]});
                }
            }
        };
        if (this.tree != null) {
            this.tree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public void setColumns(XulTreeCols columns) {
        this.columns = columns;
    }

    public void setRootChildren(XulTreeChildren rootChildren) {
        if (this.rootChildren == null) {
            this.rootChildren = rootChildren;
        }
    }

    public void addTreeRow(XulTreeRow row) {
        this.getRootChildren().addItem((XulTreeItem)new SwingTreeItem(row));
        this.table.updateUI();
    }

    public void removeTreeRows(int[] rows) {
        int i;
        ArrayList<Integer> rowArray = new ArrayList<Integer>();
        for (i = 0; i < rows.length; ++i) {
            rowArray.add(rows[i]);
        }
        Collections.sort(rowArray, Collections.reverseOrder());
        for (i = 0; i < rowArray.size(); ++i) {
            int item = (Integer)rowArray.get(i);
            if (item < 0 || item >= this.getRootChildren().getItemCount()) continue;
            this.getRootChildren().removeItem(item);
        }
        this.table.updateUI();
        this.changeSupport.firePropertyChange("selectedRows", null, this.getSelectedRows());
        this.changeSupport.firePropertyChange("absoluteSelectedRows", null, this.getAbsoluteSelectedRows());
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setSeltype(String type) {
        this.selType = SELECTION_MODE.valueOf(type.toUpperCase());
        if (this.table == null) {
            return;
        }
        switch (this.selType) {
            case CELL: {
                this.table.setCellSelectionEnabled(true);
                break;
            }
            case MULTIPLE: {
                this.table.setSelectionMode(2);
                break;
            }
            case SINGLE: {
                this.table.setSelectionMode(0);
            }
        }
    }

    public void setTableModel(TableModel model) {
        this.tableModel = model;
    }

    @Override
    public void layout() {
        XulComponent primaryColumn = this.getElementByXPath("//treecol[@primary='true']");
        XulComponent isaContainer = this.getElementByXPath("treechildren/treeitem[@container='true']");
        boolean bl = this.isHierarchical = primaryColumn != null || isaContainer != null;
        if (this.isHierarchical) {
            this.tree = new JTree();
            if (this.treeSelectionListener != null) {
                this.tree.getSelectionModel().addTreeSelectionListener(this.treeSelectionListener);
            }
            this.tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    SwingTree.this.changeSupport.firePropertyChange("selectedRows", null, SwingTree.this.getSelectedRows());
                    SwingTree.this.changeSupport.firePropertyChange("absoluteSelectedRows", null, SwingTree.this.getAbsoluteSelectedRows());
                    SwingTree.this.fireSelectedItem();
                }
            });
        } else {
            this.table = new ScrollableJTable();
            if (this.selectionListener != null) {
                this.table.getSelectionModel().addListSelectionListener(this.selectionListener);
            }
            this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (event.getValueIsAdjusting()) {
                        return;
                    }
                    SwingTree.this.changeSupport.firePropertyChange("selectedRows", null, SwingTree.this.getSelectedRows());
                    SwingTree.this.fireSelectedItem();
                }
            });
        }
        JComponent comp = this.table != null ? this.table : this.tree;
        ToolTipManager.sharedInstance().unregisterComponent(comp);
        if (this.table != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
            this.table.setRowHeight(18);
            this.scrollpane = new JScrollPane(this.table);
            this.setupTable();
        } else {
            this.setupTree();
            this.scrollpane = new JScrollPane(this.tree);
        }
        this.setManagedObject(this.scrollpane.getViewport());
    }

    private void updateColumnModel() {
        TableColumnModel columnModel = this.table.getColumnModel();
        this.totalFlex = 0;
        for (int i = 0; i < this.columns.getChildNodes().size() && i < columnModel.getColumnCount(); ++i) {
            SwingTreeCol child = (SwingTreeCol)((Object)this.columns.getChildNodes().get(i));
            TableColumn col = columnModel.getColumn(i);
            this.totalFlex += child.getFlex();
            col.setHeaderValue(child.getLabel());
            col.setCellEditor(this.getCellEditor(child));
            col.setCellRenderer(this.getCellRenderer(child));
        }
    }

    private void setupTable() {
        this.tableModel = new XulTableModel(this);
        this.table.setModel(this.tableModel);
        this.setSeltype(this.getSeltype());
        this.updateColumnModel();
        this.initialized = true;
        this.table.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingTree.this.calcColumnWidths();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (event.getValueIsAdjusting()) {
                    return;
                }
                SwingTree.this.changeSupport.firePropertyChange("selectedRows", null, SwingTree.this.getSelectedRows());
                SwingTree.this.changeSupport.firePropertyChange("absoluteSelectedRows", null, SwingTree.this.getAbsoluteSelectedRows());
            }
        });
        this.table.getTableHeader().setReorderingAllowed(this.isEnableColumnDrag());
        this.setDisabled(this.isDisabled());
    }

    private void calcColumnWidths() {
        Rectangle size = this.table.getBounds();
        int newWidth = size.width;
        if (this.rows > -1) {
            int minHeight = this.table.getRowHeight() * this.rows;
            this.scrollpane.getViewport().setMinimumSize(new Dimension(this.scrollpane.getWidth(), minHeight - 100));
        }
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            int newColWidth = 50;
            if (this.totalFlex > 0) {
                int flex = this.columns.getColumn(this.table.getColumnModel().getColumn(i).getModelIndex()).getFlex();
                if (flex != 0) {
                    newColWidth = (int)((double)newWidth * ((double)flex / (double)this.totalFlex));
                }
            } else {
                newColWidth = (int)((double)newWidth * (1.0 / (double)this.table.getColumnCount()));
            }
            this.table.getColumnModel().getColumn(i).setWidth(newColWidth);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(newColWidth);
        }
    }

    private void setupTree() {
        XulTreeNode topNode = new XulTreeNode("placeholder", null);
        for (XulComponent c : this.getRootChildren().getChildNodes()) {
            XulTreeItem item = (XulTreeItem)c;
            XulTreeNode node = this.createNode(item);
            if (node == null) continue;
            topNode.add(node);
        }
        this.treeModel = new XulTreeModel(topNode);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(false);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setClosedIcon(null);
        renderer.setOpenIcon(null);
        this.tree.setCellRenderer(renderer);
        this.tree.setShowsRootHandles(true);
        this.setExpanded(this.getExpanded());
    }

    private XulTreeNode createNode(XulTreeItem item) {
        if (item.getRow().getCell(0) == null) {
            return null;
        }
        XulTreeNode node = new XulTreeNode(item.getRow().getCell(0).getLabel(), item);
        if (item.getChildNodes().size() > 1) {
            XulTreeChildren children = (XulTreeChildren)item.getChildNodes().get(1);
            for (XulComponent c : children.getChildNodes()) {
                XulTreeNode childNode = this.createNode((XulTreeItem)c);
                if (childNode == null) continue;
                node.add(childNode);
            }
        }
        return node;
    }

    @Override
    public void replaceChild(XulComponent oldElement, XulComponent newElement) throws XulDomException {
        super.replaceChild(oldElement, newElement);
    }

    public Object getManagedObject() {
        return this.scrollpane;
    }

    public int[] getSelectedRows() {
        if (this.table != null) {
            int[] tempSelection = this.table.getSelectedRows();
            ArrayList<Integer> clensedSelection = new ArrayList<Integer>();
            for (int row : tempSelection) {
                if (row >= this.table.getModel().getRowCount()) continue;
                clensedSelection.add(row);
            }
            int[] returnArray = new int[clensedSelection.size()];
            int idx = 0;
            Iterator i$ = clensedSelection.iterator();
            while (i$.hasNext()) {
                int row;
                returnArray[idx] = row = ((Integer)i$.next()).intValue();
                ++idx;
            }
            return returnArray;
        }
        int[] vals = this.tree.getSelectionRows();
        if (vals == null) {
            return new int[0];
        }
        return vals;
    }

    public int[] getAbsoluteSelectedRows() {
        int i;
        if (this.table != null) {
            return this.getSelectedRows();
        }
        ArrayList<Boolean> expandedState = new ArrayList<Boolean>();
        for (i = 0; i < this.tree.getRowCount(); ++i) {
            expandedState.add(this.tree.isExpanded(i));
        }
        for (i = this.tree.getRowCount() - 1; i >= 0; --i) {
            this.tree.expandRow(i);
        }
        int[] vals = this.tree.getSelectionRows();
        for (int i2 = 0; i2 < expandedState.size(); ++i2) {
            if (((Boolean)expandedState.get(i2)).booleanValue()) {
                this.tree.expandRow(i2);
                continue;
            }
            this.tree.collapseRow(i2);
        }
        if (vals == null) {
            return new int[0];
        }
        return vals;
    }

    public void addRow(XulTreeRow row) {
        SwingTreeItem item = new SwingTreeItem(row);
        this.getRootChildren().addItem((XulTreeItem)item);
    }

    public Object getData() {
        return null;
    }

    public void setData(Object data) {
    }

    public void update() {
        if (!this.suppressEvents) {
            if (this.table != null) {
                this.table.setModel(new XulTableModel(this));
                this.updateColumnModel();
                this.calcColumnWidths();
                this.table.updateUI();
            } else {
                this.setupTree();
                this.tree.updateUI();
            }
        }
    }

    private String extractDynamicColType(Object row, int columnPos) {
        try {
            String rawMethod = this.columns.getColumn(columnPos).getColumntypebinding();
            StringBuilder methodName = new StringBuilder();
            methodName.append("get");
            methodName.append(rawMethod.substring(0, 1).toUpperCase());
            methodName.append(rawMethod.substring(1));
            Method method = row.getClass().getMethod(methodName.toString(), new Class[0]);
            return ((String)method.invoke(row, new Object[0])).toUpperCase();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not extract column type from binding");
            return "text";
        }
    }

    private TableCellRenderer getCellRenderer(final SwingTreeCol col) {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ColumnType colType = col.getColumnType();
                if (colType == ColumnType.DYNAMIC) {
                    colType = ColumnType.valueOf((String)SwingTree.this.extractDynamicColType(SwingTree.this.elements.toArray()[row], column));
                }
                XulTreeCell cell = SwingTree.this.getRootChildren().getItem(row).getRow().getCell(column);
                switch (colType) {
                    case CHECKBOX: {
                        JCheckBox checkbox = new JCheckBox();
                        if (value instanceof String) {
                            checkbox.setSelected(((String)value).equalsIgnoreCase("true"));
                        } else if (value instanceof Boolean) {
                            checkbox.setSelected((Boolean)value);
                        } else if (value == null) {
                            checkbox.setSelected(false);
                        }
                        if (isSelected) {
                            checkbox.setBackground(Color.LIGHT_GRAY);
                        }
                        checkbox.setEnabled(!cell.isDisabled());
                        return checkbox;
                    }
                    case COMBOBOX: 
                    case EDITABLECOMBOBOX: {
                        JComboBox comboBox = new JComboBox();
                        if (cell != null) {
                            Vector data;
                            Vector vector = data = cell.getValue() != null ? (Vector)cell.getValue() : new Vector();
                            if (data == null) {
                                logger.debug((Object)("SwingTreeCell combobox data is null, passed in value: " + value));
                                if (value instanceof Vector) {
                                    data = (Vector)value;
                                }
                            }
                            if (data != null) {
                                comboBox.setModel(new DefaultComboBoxModel(data));
                                try {
                                    comboBox.setSelectedIndex(cell.getSelectedIndex());
                                }
                                catch (Exception e) {
                                    logger.error((Object)"error setting selected index on the combobox editor");
                                }
                            }
                        }
                        if (colType == ColumnType.EDITABLECOMBOBOX) {
                            comboBox.setEditable(true);
                            ((JTextComponent)comboBox.getEditor().getEditorComponent()).setText(cell.getLabel());
                        }
                        if (isSelected) {
                            comboBox.setBackground(Color.LIGHT_GRAY);
                        }
                        comboBox.setEnabled(!cell.isDisabled());
                        return comboBox;
                    }
                    case CUSTOM: {
                        return new CustomCellEditorWrapper(cell, (TreeCellEditor)SwingTree.this.customEditors.get(col.getType()));
                    }
                }
                JLabel label = new JLabel((String)value);
                if (isSelected) {
                    label.setOpaque(true);
                    label.setBackground(Color.LIGHT_GRAY);
                }
                return label;
            }
        };
    }

    private TableCellEditor getCellEditor(final SwingTreeCol col) {
        return new DefaultCellEditor(new JComboBox()){
            JComponent control;

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, final int row, final int column) {
                JComponent comp;
                ColumnType colType = col.getColumnType();
                if (colType == ColumnType.DYNAMIC) {
                    colType = ColumnType.valueOf((String)SwingTree.this.extractDynamicColType(SwingTree.this.elements.toArray()[row], column));
                }
                XulTreeCell cell = SwingTree.this.getRootChildren().getItem(row).getRow().getCell(column);
                switch (colType) {
                    case CHECKBOX: {
                        final JCheckBox checkbox = new JCheckBox();
                        final JTable tbl = table;
                        checkbox.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent event) {
                                SwingTree.this.table.setValueAt(checkbox.isSelected(), row, column);
                                tbl.getCellEditor().stopCellEditing();
                            }
                        });
                        this.control = checkbox;
                        if (value instanceof String) {
                            checkbox.setSelected(((String)value).equalsIgnoreCase("true"));
                        } else if (value instanceof Boolean) {
                            checkbox.setSelected((Boolean)value);
                        } else if (value == null) {
                            checkbox.setSelected(false);
                        }
                        if (isSelected) {
                            checkbox.setBackground(Color.LIGHT_GRAY);
                        }
                        comp = checkbox;
                        checkbox.setEnabled(!cell.isDisabled());
                        break;
                    }
                    case COMBOBOX: 
                    case EDITABLECOMBOBOX: {
                        Vector val = value != null && value instanceof Vector ? (Vector)value : new Vector();
                        final JComboBox comboBox = new JComboBox(val);
                        if (isSelected) {
                            comboBox.setBackground(Color.LIGHT_GRAY);
                        }
                        if (colType == ColumnType.EDITABLECOMBOBOX) {
                            comboBox.setEditable(true);
                            final JTextComponent textComp = (JTextComponent)comboBox.getEditor().getEditorComponent();
                            textComp.addKeyListener(new KeyListener(){
                                private String oldValue = "";

                                @Override
                                public void keyPressed(KeyEvent e) {
                                    this.oldValue = textComp.getText();
                                }

                                @Override
                                public void keyReleased(KeyEvent e) {
                                    if (this.oldValue != null && !this.oldValue.equals(textComp.getText())) {
                                        SwingTree.this.table.setValueAt(textComp.getText(), row, column);
                                        this.oldValue = textComp.getText();
                                    } else if (this.oldValue == null) {
                                        this.oldValue = textComp.getText();
                                    } else {
                                        logger.debug((Object)"Special key pressed, ignoring");
                                    }
                                }

                                @Override
                                public void keyTyped(KeyEvent e) {
                                }
                            });
                            comboBox.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    logger.debug((Object)("Setting ComboBox value from editor: " + comboBox.getSelectedItem() + ", " + row + ", " + column));
                                    SwingTree.this.table.setValueAt(comboBox.getSelectedIndex(), row, column);
                                }
                            });
                        } else {
                            comboBox.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent event) {
                                    logger.debug((Object)("Setting ComboBox value from editor: " + comboBox.getSelectedItem() + ", " + row + ", " + column));
                                    SwingTree.this.table.setValueAt(comboBox.getSelectedIndex(), row, column);
                                }
                            });
                        }
                        this.control = comboBox;
                        comboBox.setEnabled(!cell.isDisabled());
                        comp = comboBox;
                        break;
                    }
                    case LABEL: {
                        JLabel lbl;
                        comp = lbl = new JLabel(cell.getLabel());
                        this.control = lbl;
                        break;
                    }
                    case CUSTOM: {
                        return new CustomCellEditorWrapper(cell, (TreeCellEditor)SwingTree.this.customEditors.get(col.getType()));
                    }
                    default: {
                        final JTextField label = new JTextField((String)value);
                        label.getDocument().addDocumentListener(new DocumentListener(){

                            @Override
                            public void changedUpdate(DocumentEvent arg0) {
                                SwingTree.this.table.setValueAt(label.getText(), row, column);
                            }

                            @Override
                            public void insertUpdate(DocumentEvent arg0) {
                                SwingTree.this.table.setValueAt(label.getText(), row, column);
                            }

                            @Override
                            public void removeUpdate(DocumentEvent arg0) {
                                SwingTree.this.table.setValueAt(label.getText(), row, column);
                            }
                        });
                        if (isSelected) {
                            label.setOpaque(true);
                        }
                        this.control = label;
                        comp = label;
                        label.setEnabled(!cell.isDisabled());
                        label.setDisabledTextColor(Color.DARK_GRAY);
                    }
                }
                return comp;
            }

            @Override
            public Object getCellEditorValue() {
                if (this.control instanceof JCheckBox) {
                    return ((JCheckBox)this.control).isSelected();
                }
                if (this.control instanceof JComboBox) {
                    JComboBox box = (JComboBox)this.control;
                    if (box.isEditable()) {
                        return ((JTextComponent)box.getEditor().getEditorComponent()).getText();
                    }
                    return box.getSelectedIndex();
                }
                if (this.control instanceof JTextField) {
                    return ((JTextField)this.control).getText();
                }
                return ((JLabel)this.control).getText();
            }
        };
    }

    public void clearSelection() {
        this.table.getSelectionModel().clearSelection();
        TableCellEditor ce = this.table.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    public void setSelectedRows(int[] rows) {
        if (this.isHierarchical) {
            this.tree.setSelectionRows(rows);
        } else {
            this.table.clearSelection();
            for (int row : rows) {
                this.table.changeSelection(row, -1, false, true);
            }
        }
    }

    public String getOnedit() {
        return this.onedit;
    }

    public void setOnedit(String onedit) {
        this.onedit = onedit;
    }

    public <T> void setElements(Collection<T> elements) {
        TableCellEditor ce;
        this.suppressEvents = true;
        this.elements = elements;
        this.getRootChildren().removeAll();
        if (this.table != null && (ce = this.table.getCellEditor()) != null) {
            ce.stopCellEditing();
        }
        if (elements == null) {
            if (this.table != null) {
                this.table.updateUI();
            } else {
                this.tree.updateUI();
            }
            this.changeSupport.firePropertyChange("selectedRows", null, this.getSelectedRows());
            this.changeSupport.firePropertyChange("absoluteSelectedRows", null, this.getAbsoluteSelectedRows());
            return;
        }
        try {
            if (this.table != null) {
                for (T o : elements) {
                    XulTreeRow row = this.getRootChildren().addNewRow();
                    for (int x = 0; x < this.getColumns().getChildNodes().size(); ++x) {
                        XulTreeCol col = this.getColumns().getColumn(x);
                        final XulTreeCell cell = (XulTreeCell)this.getDocument().createElement("treecell");
                        XulTreeCol column = col;
                        for (InlineBindingExpression exp : col.getBindingExpressions()) {
                            Binding binding;
                            logger.debug((Object)("applying binding expression [" + exp + "] to xul tree cell [" + cell + "] and model [" + o + "]"));
                            String colType = column.getType();
                            if (!StringUtils.isEmpty((String)colType) && colType.equalsIgnoreCase("dynamic")) {
                                colType = this.extractDynamicColType(o, x);
                            }
                            if (colType == null) {
                                if (!StringUtils.isNotEmpty((String)exp.getModelAttr())) continue;
                                binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                                if (!this.editable) {
                                    binding.setBindingType(Binding.Type.ONE_WAY);
                                }
                                this.domContainer.addBinding(binding);
                                binding.fireSourceChanged();
                                continue;
                            }
                            if ((colType.equalsIgnoreCase("combobox") || colType.equalsIgnoreCase("editablecombobox")) && column.getCombobinding() != null) {
                                binding = this.createBinding((XulEventSource)o, column.getCombobinding(), (XulEventSource)cell, "value");
                                binding.setBindingType(Binding.Type.ONE_WAY);
                                this.domContainer.addBinding(binding);
                                binding.fireSourceChanged();
                                binding = this.createBinding((XulEventSource)o, col.getBinding(), (XulEventSource)cell, "selectedIndex");
                                binding.setConversion((BindingConvertor)new BindingConvertor<Object, Integer>(){

                                    public Integer sourceToTarget(Object value) {
                                        int index = ((Vector)cell.getValue()).indexOf(value);
                                        return index > -1 ? index : 0;
                                    }

                                    public Object targetToSource(Integer value) {
                                        return ((Vector)cell.getValue()).get(value);
                                    }
                                });
                                this.domContainer.addBinding(binding);
                                binding.fireSourceChanged();
                                if (!colType.equalsIgnoreCase("editablecombobox")) continue;
                                binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                                if (!this.editable) {
                                    binding.setBindingType(Binding.Type.ONE_WAY);
                                } else {
                                    binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
                                }
                                this.domContainer.addBinding(binding);
                                continue;
                            }
                            if (colType.equalsIgnoreCase("checkbox")) {
                                if (!StringUtils.isNotEmpty((String)exp.getModelAttr())) continue;
                                binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, "value");
                                if (!this.editable) {
                                    binding.setBindingType(Binding.Type.ONE_WAY);
                                }
                                this.domContainer.addBinding(binding);
                                binding.fireSourceChanged();
                                continue;
                            }
                            if (colType != null && this.customEditors.containsKey(colType)) {
                                binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, "value");
                                binding.setBindingType(Binding.Type.BI_DIRECTIONAL);
                                this.domContainer.addBinding(binding);
                                binding.fireSourceChanged();
                                continue;
                            }
                            if (!StringUtils.isNotEmpty((String)exp.getModelAttr())) continue;
                            binding = this.createBinding((XulEventSource)o, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                            if (!this.editable) {
                                binding.setBindingType(Binding.Type.ONE_WAY);
                            }
                            this.domContainer.addBinding(binding);
                            binding.fireSourceChanged();
                        }
                        if (column.getDisabledbinding() != null) {
                            String prop = column.getDisabledbinding();
                            Binding bind = this.createBinding((XulEventSource)o, column.getDisabledbinding(), (XulEventSource)cell, "disabled");
                            bind.setBindingType(Binding.Type.ONE_WAY);
                            this.domContainer.addBinding(bind);
                            bind.fireSourceChanged();
                        }
                        row.addCell(cell);
                    }
                }
                if (this.popupListener == null && StringUtils.isNotEmpty((String)this.newItemBinding)) {
                    if (this.isCollectionManaged()) {
                        this.popupListener = new PopupListener();
                        this.table.addMouseListener(this.popupListener);
                        this.table.getTableHeader().addMouseListener(this.popupListener);
                    } else {
                        logger.error((Object)"Operations associated with newitembinding attribute not allowed on an unbound collection. Refactor your model to use a managed collection (for an example, see AbstractModelList).");
                    }
                }
            } else {
                for (T o : elements) {
                    XulTreeRow row = this.getRootChildren().addNewRow();
                    this.addTreeChild(o, row);
                }
            }
            if (this.table != null) {
                this.table.updateUI();
            } else {
                this.setupTree();
                this.tree.updateUI();
            }
            this.suppressEvents = false;
            this.changeSupport.firePropertyChange("selectedRows", null, this.getSelectedRows());
            this.changeSupport.firePropertyChange("absoluteSelectedRows", null, this.getAbsoluteSelectedRows());
        }
        catch (XulException e) {
            logger.error((Object)"error adding elements", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"error adding elements", (Throwable)e);
        }
    }

    private <T> void addTreeChild(T element, XulTreeRow row) {
        try {
            XulTreeCell cell = (XulTreeCell)this.getDocument().createElement("treecell");
            for (InlineBindingExpression exp : ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getBindingExpressions()) {
                logger.debug((Object)("applying binding expression [" + exp + "] to xul tree cell [" + cell + "] and model [" + element + "]"));
                Binding binding = this.createBinding((XulEventSource)element, exp.getModelAttr(), (XulEventSource)cell, exp.getXulCompAttr());
                binding.setBindingType(Binding.Type.ONE_WAY);
                this.domContainer.addBinding(binding);
                binding.fireSourceChanged();
            }
            row.addCell(cell);
            String property = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding();
            property = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method childrenMethod = null;
            try {
                childrenMethod = element.getClass().getMethod(property, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                logger.debug((Object)("Could not find children binding method for object: " + element.getClass().getSimpleName()));
            }
            Collection children = null;
            if (childrenMethod != null) {
                children = (Collection)childrenMethod.invoke(element, new Object[0]);
            } else if (element instanceof Collection) {
                children = (Collection)element;
            }
            XulTreeChildren treeChildren = null;
            if (children != null && children.size() > 0) {
                treeChildren = (XulTreeChildren)this.getDocument().createElement("treechildren");
                row.getParent().addChild((Element)treeChildren);
            }
            for (Object child : children) {
                row = treeChildren.addNewRow();
                this.addTreeChild(child, row);
            }
        }
        catch (Exception e) {
            logger.error((Object)"error adding elements", (Throwable)e);
        }
    }

    public <T> Collection<T> getElements() {
        return this.elements;
    }

    private void fireSelectedItem() {
        this.changeSupport.firePropertyChange("selectedItem", null, this.getSelectedItem());
    }

    public Object getSelectedItem() {
        if (this.isHierarchical && this.elements != null) {
            int[] vals = this.tree.getSelectionRows();
            if (vals == null || vals.length == 0) {
                return null;
            }
            TreePath path = this.tree.getSelectionPath();
            if (path.getLastPathComponent() instanceof XulTreeNode) {
                XulTreeNode node = (XulTreeNode)path.getLastPathComponent();
                SearchBundle b = this.findSelectedIndex(new SearchBundle(), this.getRootChildren(), node.item);
                vals[0] = b.curPos;
            }
            String property = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding();
            property = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
            FindSelectedItemTuple tuple = this.findSelectedItem((Object)this.elements, property, new FindSelectedItemTuple(vals[0]));
            return tuple != null ? tuple.selectedItem : null;
        }
        if (!this.isHierarchical() && this.elements != null && this.getSelectedRows().length > 0 && this.elements.toArray().length > this.getSelectedRows()[0]) {
            return this.elements.toArray()[this.getSelectedRows()[0]];
        }
        return null;
    }

    private SearchBundle findSelectedIndex(SearchBundle bundle, XulTreeChildren children, XulTreeItem selectedItem) {
        for (XulComponent c : children.getChildNodes()) {
            if (c == selectedItem) {
                bundle.found = true;
                return bundle;
            }
            ++bundle.curPos;
            if (c.getChildNodes().size() <= 1) continue;
            SearchBundle b = this.findSelectedIndex(bundle, (XulTreeChildren)c.getChildNodes().get(1), selectedItem);
            if (!b.found) continue;
            return b;
        }
        return bundle;
    }

    private FindSelectedItemTuple findSelectedItem(Object parent, String childrenMethodProperty, FindSelectedItemTuple tuple) {
        if (tuple.curpos == tuple.selectedIndex) {
            tuple.selectedItem = parent;
            return tuple;
        }
        Collection children = SwingTree.getChildCollection(parent, childrenMethodProperty);
        if (children == null || children.size() == 0) {
            return null;
        }
        for (Object child : children) {
            ++tuple.curpos;
            this.findSelectedItem(child, childrenMethodProperty, tuple);
            if (tuple.selectedItem == null) continue;
            return tuple;
        }
        return null;
    }

    private static Collection getChildCollection(Object obj, String childrenMethodProperty) {
        Method childrenMethod;
        Collection children;
        block5: {
            children = null;
            childrenMethod = null;
            try {
                childrenMethod = obj.getClass().getMethod(childrenMethodProperty, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                if (!(obj instanceof Collection)) break block5;
                children = (Collection)obj;
            }
        }
        try {
            if (childrenMethod != null) {
                children = (Collection)childrenMethod.invoke(obj, new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        return children;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.tree != null) {
            int rowCount = 0;
            int newRowCount = 0;
            while ((newRowCount = this.tree.getRowCount()) > 0 && newRowCount > rowCount) {
                rowCount = newRowCount;
                for (int i = 0; i < rowCount; ++i) {
                    this.tree.expandRow(i);
                }
            }
        }
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void registerCellEditor(String key, TreeCellEditor editor) {
        this.customEditors.put(key, editor);
    }

    public void registerCellRenderer(String key, TreeCellRenderer renderer) {
    }

    public void setBoundObjectExpanded(Object o, boolean expanded) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void setTreeItemExpanded(XulTreeItem item, boolean expanded) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void collapseAll() {
        if (this.isHierarchical) {
            // empty if block
        }
    }

    public void expandAll() {
        if (this.isHierarchical) {
            this.setExpanded(true);
        }
    }

    public <T> Collection<T> getSelectedItems() {
        return null;
    }

    public <T> void setSelectedItems(Collection<T> items) {
        int[] selIndexes = new int[items.size()];
        if (this.isHierarchical && this.elements != null) {
            int pos = 0;
            for (T t : items) {
                selIndexes[pos++] = this.findIndexOfItem(t);
            }
        }
        this.setSelectedRows(selIndexes);
    }

    public int findIndexOfItem(Object o) {
        String property = ((XulTreeCol)this.getColumns().getChildNodes().get(0)).getChildrenbinding();
        property = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        Method childrenMethod = null;
        try {
            childrenMethod = this.elements.getClass().getMethod(property, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.debug((Object)e);
        }
        FindSelectedIndexTuple tuple = this.findSelectedItem((Object)this.elements, childrenMethod, new FindSelectedIndexTuple(o));
        return tuple.selectedIndex;
    }

    private FindSelectedIndexTuple findSelectedItem(Object parent, Method childrenMethod, FindSelectedIndexTuple tuple) {
        if (tuple.selectedItem == tuple.currentItem) {
            tuple.selectedItem = parent;
            return tuple;
        }
        Collection children = null;
        try {
            children = (Collection)childrenMethod.invoke(parent, new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
        if (children == null || children.size() == 0) {
            return null;
        }
        for (Object child : children) {
            ++tuple.curpos;
            this.findSelectedItem(child, childrenMethod, tuple);
            if (tuple.selectedIndex <= -1) continue;
            return tuple;
        }
        return null;
    }

    public boolean isHiddenrootnode() {
        return false;
    }

    public void setHiddenrootnode(boolean hidden) {
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isPreserveexpandedstate() {
        return false;
    }

    public void setPreserveexpandedstate(boolean preserve) {
    }

    public boolean isSortable() {
        return false;
    }

    public void setSortable(boolean sort) {
    }

    public boolean isTreeLines() {
        return false;
    }

    public void setTreeLines(boolean visible) {
    }

    public void setNewitembinding(String binding) {
        this.newItemBinding = binding;
    }

    public String getNewitembinding() {
        return this.newItemBinding;
    }

    public void setAutocreatenewrows(boolean auto) {
        this.autoCreateNewRows = auto;
    }

    public boolean getAutocreatenewrows() {
        return this.autoCreateNewRows;
    }

    private void insertRowAtLast() {
        if (this.elements != null && this.newItemBinding != null) {
            this.invoke(this.newItemBinding);
        } else if (this.autoCreateNewRows) {
            this.getRootChildren().addNewRow();
            this.update();
        }
    }

    public boolean isPreserveselection() {
        return false;
    }

    public void setPreserveselection(boolean preserve) {
    }

    private Binding createBinding(XulEventSource source, String prop1, XulEventSource target, String prop2) {
        if (this.bindingProvider != null) {
            return this.bindingProvider.getBinding(source, prop1, target, prop2);
        }
        return new SwingBinding(source, prop1, target, prop2);
    }

    private boolean isCollectionManaged() {
        return this.elements instanceof XulManagedCollection;
    }

    class ScrollableJTable
    extends JTable {
        ScrollableJTable() {
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.getPreferredSize().height < this.getParent().getHeight();
        }
    }

    class KeepOnlyRowsActionAdapter
    implements ActionListener {
        SwingTree adaptee;

        KeepOnlyRowsActionAdapter(SwingTree adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = this.adaptee.getAbsoluteSelectedRows();
            Object[] elementObjects = SwingTree.this.elements.toArray();
            for (int modelIndex = SwingTree.this.elements.size() - 1; modelIndex >= 0; --modelIndex) {
                boolean inProcessRows = false;
                for (int i = 0; i < rows.length; ++i) {
                    boolean bl = inProcessRows = modelIndex == rows[i];
                    if (inProcessRows) break;
                }
                if (inProcessRows) continue;
                SwingTree.this.elements.remove(elementObjects[modelIndex]);
            }
        }
    }

    class DeleteRowsActionAdapter
    implements ActionListener {
        SwingTree adaptee;

        DeleteRowsActionAdapter(SwingTree adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            int[] rows = this.adaptee.getAbsoluteSelectedRows();
            Object[] elementObjects = SwingTree.this.elements.toArray();
            ArrayList<Integer> rowArray = new ArrayList<Integer>();
            for (i = 0; i < rows.length; ++i) {
                rowArray.add(rows[i]);
            }
            Collections.sort(rowArray, Collections.reverseOrder());
            for (i = 0; i < rowArray.size(); ++i) {
                int item = (Integer)rowArray.get(i);
                if (item < 0 || item >= SwingTree.this.elements.size()) continue;
                SwingTree.this.elements.remove(elementObjects[item]);
            }
        }
    }

    class InsertRowsActionAdapter
    implements ActionListener {
        SwingTree adaptee;

        InsertRowsActionAdapter(SwingTree adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingTree.this.insertRowAtLast();
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int count = SwingTree.this.getAbsoluteSelectedRows().length;
                SwingTree.this.deleteRowMenu.setEnabled(count == 1);
                SwingTree.this.deleteRowsMenu.setEnabled(count > 1);
                SwingTree.this.keepOnlyRowsMenu.setEnabled(count > 0);
                SwingTree.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static class FindSelectedIndexTuple {
        Object selectedItem = null;
        Object currentItem = null;
        int curpos = -1;
        int selectedIndex = -1;

        public FindSelectedIndexTuple(Object selectedItem) {
            this.selectedItem = selectedItem;
        }
    }

    private static class CustomTreeCellEditor
    implements TreeCellEditor {
        private TreeCellEditorCallback callback;

        private CustomTreeCellEditor() {
        }

        public Object getValue() {
            return null;
        }

        public void hide() {
        }

        public void setValue(Object val) {
        }

        public void show(int row, int col, Object boundObj, String columnBinding, TreeCellEditorCallback callback) {
            this.callback = callback;
            String returnVal = JOptionPane.showInputDialog("Enter a Value");
            this.callback.onCellEditorClosed((Object)returnVal);
        }
    }

    private class CustomCellEditorWrapper
    extends JLabel
    implements TreeCellEditorCallback {
        private TreeCellEditor editor;
        private XulTreeCell cell;

        public CustomCellEditorWrapper(XulTreeCell cell, TreeCellEditor editor) {
            this.editor = editor;
            this.cell = cell;
            this.setText(this.cell.getValue().toString());
            final int col = cell.getParent().getChildNodes().indexOf(cell);
            XulTreeItem item = (XulTreeItem)cell.getParent().getParent();
            final int row = item.getParent().getChildNodes().indexOf(item);
            final Object boundObj = SwingTree.this.getElements() != null ? SwingTree.this.getElements().toArray()[row] : null;
            final String columnBinding = SwingTree.this.getColumns().getColumn(col).getBinding();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent arg0) {
                    CustomCellEditorWrapper.this.editor.show(row, col, boundObj, columnBinding, (TreeCellEditorCallback)CustomCellEditorWrapper.this);
                }
            });
        }

        public void onCellEditorClosed(Object value) {
            this.setText(value.toString());
            this.cell.setValue(value);
        }
    }

    private static class FindSelectedItemTuple {
        Object selectedItem = null;
        int curpos = -1;
        int selectedIndex;

        public FindSelectedItemTuple(int selectedIndex) {
            this.selectedIndex = selectedIndex;
        }
    }

    private class SearchBundle {
        int curPos;
        boolean found;
        Object selectedItem;

        private SearchBundle() {
        }
    }

    private class XulTableModel
    extends AbstractTableModel {
        SwingTree tree = null;

        public XulTableModel(SwingTree tree) {
            this.tree = tree;
        }

        public void update() {
        }

        @Override
        public int getColumnCount() {
            return this.tree.getColumns().getColumnCount();
        }

        @Override
        public int getRowCount() {
            if (this.tree != null) {
                XulTreeChildren children = this.tree.getRootChildren();
                return children != null ? children.getItemCount() : 0;
            }
            return 0;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            XulTreeCol col = this.tree.getColumns().getColumn(columnIndex);
            XulTreeCell cell = this.tree.getRootChildren().getItem(rowIndex).getRow().getCell(columnIndex);
            if (cell == null) {
                return null;
            }
            ColumnType colType = col.getColumnType();
            if (colType == ColumnType.DYNAMIC) {
                colType = ColumnType.valueOf((String)SwingTree.this.extractDynamicColType(SwingTree.this.elements.toArray()[rowIndex], columnIndex));
            }
            try {
                switch (colType) {
                    case CHECKBOX: {
                        if (cell.getValue() != null) {
                            return cell.getValue();
                        }
                    }
                    case COMBOBOX: 
                    case EDITABLECOMBOBOX: {
                        if (cell.getValue() == null) break;
                        return cell.getValue();
                    }
                }
                return cell.getLabel();
            }
            catch (Exception e) {
                logger.error((Object)("Error getting value of cell at row:" + rowIndex + " column:" + columnIndex), (Throwable)e);
                return null;
            }
        }

        @Override
        public int findColumn(String columnName) {
            for (int i = 0; i < this.tree.getColumns().getColumnCount(); ++i) {
                if (!this.tree.getColumns().getColumn(i).getName().toUpperCase().equals(columnName.toUpperCase())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (this.tree.getColumns().getColumn(columnIndex).getColumnType()) {
                case CHECKBOX: {
                    return Boolean.class;
                }
                case COMBOBOX: 
                case EDITABLECOMBOBOX: {
                    return Vector.class;
                }
            }
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return this.tree.getColumns().getColumn(column).getLabel();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.tree.getColumns().getColumn(columnIndex).isEditable();
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            XulTreeItem row;
            if (SwingTree.this.onedit != null && !SwingTree.this.suppressEvents) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingTree.this.invoke(SwingTree.this.onedit, new Object[]{new Integer(SwingTree.this.table.getSelectedRow())});
                    }
                });
            }
            if ((row = this.tree.getRootChildren().getItem(rowIndex)) == null) {
                logger.info((Object)"Row removed, setVal returning");
                return;
            }
            XulTreeCell cell = row.getRow().getCell(columnIndex);
            ColumnType colType = this.tree.getColumns().getColumn(columnIndex).getColumnType();
            if (colType == ColumnType.DYNAMIC) {
                colType = ColumnType.valueOf((String)SwingTree.this.extractDynamicColType(SwingTree.this.elements.toArray()[rowIndex], columnIndex));
            }
            switch (colType) {
                case CHECKBOX: {
                    cell.setValue((Object)((Boolean)value));
                    break;
                }
                case COMBOBOX: 
                case EDITABLECOMBOBOX: {
                    if (value instanceof String) {
                        cell.setLabel((String)value);
                        break;
                    }
                    if ((Integer)value <= -1) break;
                    cell.setSelectedIndex(((Integer)value).intValue());
                    cell.setLabel(((Vector)cell.getValue()).get((Integer)value).toString());
                    break;
                }
                default: {
                    cell.setLabel((String)value);
                }
            }
        }
    }

    private class XulTreeModel
    extends DefaultTreeModel {
        public XulTreeModel(TreeNode root) {
            super(root);
        }
    }

    private class XulTreeNode
    extends DefaultMutableTreeNode {
        XulTreeItem item;

        public XulTreeNode(Object obj, XulTreeItem item) {
            super(obj);
            this.item = null;
            this.item = item;
        }
    }

    public static enum SELECTION_MODE {
        SINGLE,
        CELL,
        MULTIPLE,
        NONE;

    }
}

