/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.xpath.DefaultXPath;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulContainer;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.dom.DocumentFactory;
import org.pentaho.ui.xul.dom.dom4j.DocumentDom4J;
import org.pentaho.ui.xul.dom.dom4j.ElementDom4J;
import org.pentaho.ui.xul.impl.XulFragmentContainer;
import org.pentaho.ui.xul.impl.XulParser;
import org.pentaho.ui.xul.impl.XulWindowContainer;
import org.pentaho.ui.xul.util.ResourceBundleTranslator;

public abstract class AbstractXulLoader
implements XulLoader {
    protected XulParser parser;
    protected String rootDir = "/";
    protected Object outerContext = null;
    protected static final Log logger = LogFactory.getLog(AbstractXulLoader.class);
    private ResourceBundle mainBundle = null;
    private List<Object> resourceBundleList = new ArrayList<Object>();
    private List<ClassLoader> classloaders = new ArrayList<ClassLoader>();
    private HashMap<String, ResourceBundle> cachedResourceBundles;
    private XulSettingsManager settings;
    private Locale locale;
    private List<String> includedSources = new ArrayList<String>();
    private List<String> resourceBundles = new ArrayList<String>();
    private URLClassLoader localDirClassLoader;

    public AbstractXulLoader() throws XulException {
        this.classloaders.add(this.getClass().getClassLoader());
        DocumentFactory.registerDOMClass(DocumentDom4J.class);
        DocumentFactory.registerElementClass(ElementDom4J.class);
        this.cachedResourceBundles = new HashMap();
        try {
            this.parser = new XulParser();
        }
        catch (Exception e) {
            throw new XulException("Error getting XulParser Instance, probably a DOM Factory problem: " + e.getMessage(), e);
        }
        this.locale = Locale.getDefault();
    }

    @Override
    public XulDomContainer loadXul(Object xulDocument) throws IllegalArgumentException, XulException {
        Document document = (Document)xulDocument;
        try {
            xulDocument = this.preProcess(document);
            String processedDoc = this.performIncludeTranslations(document.asXML());
            String localOutput = this.mainBundle != null ? ResourceBundleTranslator.translate(processedDoc, this.mainBundle) : processedDoc;
            SAXReader rdr = new SAXReader();
            Document doc = rdr.read((Reader)new StringReader(localOutput));
            XulWindowContainer container = new XulWindowContainer(this);
            container.setOuterContext(this.outerContext);
            container.setSettingsManager(this.settings);
            container.setResourceBundles(this.resourceBundleList);
            this.parser.setContainer(container);
            this.parser.setClassLoaders(this.classloaders);
            this.parser.parseDocument(doc.getRootElement());
            for (ClassLoader l : this.classloaders) {
                container.registerClassLoader(l);
            }
            return container;
        }
        catch (Exception e) {
            throw new XulException(e);
        }
    }

    @Override
    public void setRootDir(String loc) {
        if (!this.rootDir.equals("/")) {
            return;
        }
        if (loc.lastIndexOf("/") > 0 && loc.indexOf(".xul") > -1) {
            this.rootDir = loc.substring(0, loc.lastIndexOf("/") + 1);
        } else {
            this.rootDir = loc;
            if (loc.lastIndexOf(47) != loc.length()) {
                this.rootDir = this.rootDir + "/";
            }
        }
    }

    public void registerResourceBundle(ResourceBundle bundle) {
        if (bundle == null) {
            throw new NullPointerException();
        }
        this.resourceBundleList.add(bundle);
    }

    @Override
    public XulDomContainer loadXulFragment(Object xulDocument) throws IllegalArgumentException, XulException {
        Document document = (Document)xulDocument;
        XulFragmentContainer container = new XulFragmentContainer(this);
        container.setResourceBundles(this.resourceBundleList);
        container.setOuterContext(this.outerContext);
        container.setSettingsManager(this.settings);
        this.parser.reset();
        this.parser.setClassLoaders(this.classloaders);
        this.parser.setContainer(container);
        this.parser.parseDocument(document.getRootElement());
        return container;
    }

    @Override
    public XulComponent createElement(String elementName) throws XulException {
        return this.parser.getElement(elementName);
    }

    private ResourceBundle loadResourceBundle(String resStr) {
        ResourceBundle res = this.cachedResourceBundles.get(resStr);
        if (res == null) {
            for (ClassLoader cl : this.classloaders) {
                try {
                    res = ResourceBundle.getBundle(resStr, this.locale, cl);
                    if (res == null) continue;
                    break;
                }
                catch (MissingResourceException e) {
                }
            }
            if (res == null) {
                try {
                    URLClassLoader cls = this.getLocalDirClassLoader();
                    res = ResourceBundle.getBundle(resStr, this.locale, cls);
                }
                catch (MalformedURLException ex) {
                    return null;
                }
                catch (MissingResourceException ex) {
                    return null;
                }
            }
            this.cachedResourceBundles.put(resStr, res);
        }
        return res;
    }

    @Override
    public XulDomContainer loadXul(String resource) throws IllegalArgumentException, XulException {
        this.setRootDir(resource);
        String resStr = resource.replace(".xul", "");
        ResourceBundle res = this.loadResourceBundle(resStr);
        if (res == null) {
            Document doc = this.findDocument(resource);
            return this.loadXul(doc);
        }
        return this.loadXul(resource, res);
    }

    @Override
    public XulDomContainer loadXul(String resource, Object bundle) throws XulException {
        Document doc = this.findDocument(resource);
        this.setRootDir(resource);
        this.mainBundle = (ResourceBundle)bundle;
        String resStr = resource.replace(".xul", "");
        ResourceBundle res = this.loadResourceBundle(resStr);
        if (res == null) {
            return this.loadXul(doc);
        }
        this.resourceBundleList.add(res);
        this.resourceBundleList.add(this.mainBundle);
        return this.loadXul(doc);
    }

    @Override
    public XulDomContainer loadXulFragment(String resource) throws IllegalArgumentException, XulException {
        this.setRootDir(resource);
        String resStr = resource.replace(".xul", "");
        ResourceBundle res = this.loadResourceBundle(resStr);
        if (res == null) {
            Document doc = this.findDocument(resource);
            return this.loadXulFragment(doc);
        }
        return this.loadXulFragment(resource, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XulDomContainer loadXulFragment(String resource, Object bundle) throws XulException {
        XulDomContainer xulDomContainer;
        if (!(bundle instanceof ResourceBundle)) {
            throw new XulException("Need a resource-bundle as bundle");
        }
        InputStream in = this.getResourceAsStream(resource);
        if (in == null) {
            throw new XulException("Given resource does not yield a valid document");
        }
        try {
            this.resourceBundleList.add(bundle);
            String localOutput = ResourceBundleTranslator.translate(in, (ResourceBundle)bundle);
            SAXReader rdr = new SAXReader();
            Document doc = rdr.read((Reader)new StringReader(localOutput));
            this.setRootDir(resource);
            xulDomContainer = this.loadXulFragment(doc);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (DocumentException e) {
                throw new XulException("Error parsing Xul Document", e);
            }
            catch (IOException e) {
                throw new XulException("Error loading Xul Document into Freemarker", e);
            }
        }
        in.close();
        return xulDomContainer;
    }

    public String performIncludeTranslations(String input) throws XulException {
        for (String includeSrc : this.includedSources) {
            String resStr = includeSrc.replace(".xul", "");
            ResourceBundle res = this.loadResourceBundle(resStr);
            if (res != null) {
                this.resourceBundleList.add(res);
                continue;
            }
            try {
                URLClassLoader cls = this.getLocalDirClassLoader();
                this.resourceBundleList.add(ResourceBundle.getBundle(resStr, this.locale, cls));
            }
            catch (MalformedURLException ex) {
            }
            catch (MissingResourceException ex) {}
        }
        for (String resource : this.resourceBundles) {
            logger.debug((Object)("Processing Resource Bundle: " + resource));
            ResourceBundle res = this.loadResourceBundle(resource);
            if (res != null) {
                this.resourceBundleList.add(res);
                continue;
            }
            try {
                URLClassLoader cls = this.getLocalDirClassLoader();
                this.resourceBundleList.add(ResourceBundle.getBundle(resource, this.locale, cls));
            }
            catch (MalformedURLException ex) {
            }
            catch (MissingResourceException ex) {}
        }
        String output = input;
        for (Object bundle : this.resourceBundleList) {
            try {
                output = ResourceBundleTranslator.translate(output, (ResourceBundle)bundle);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private URLClassLoader getLocalDirClassLoader() throws MalformedURLException {
        if (this.localDirClassLoader == null) {
            URL url = new File(".").toURI().toURL();
            this.localDirClassLoader = URLClassLoader.newInstance(new URL[]{url});
        }
        return this.localDirClassLoader;
    }

    @Override
    public void register(String tagName, String className) {
        this.parser.registerHandler(tagName, className);
    }

    @Override
    public String getRootDir() {
        return this.rootDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document preProcess(Document srcDoc) throws XulException {
        DefaultXPath xpath = new DefaultXPath("//pen:include");
        HashMap<String, String> uris = new HashMap<String, String>();
        uris.put("xul", "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul");
        uris.put("pen", "http://www.pentaho.org/2008/xul");
        xpath.setNamespaceURIs(uris);
        List eles = xpath.selectNodes((Object)srcDoc);
        for (Element ele : eles) {
            String src = "";
            src = this.getRootDir() + ele.attributeValue("src");
            String resourceBundle = ele.attributeValue("resource");
            if (resourceBundle != null) {
                this.resourceBundles.add(resourceBundle);
            } else {
                this.resourceBundles.add(src.replace(".xul", ""));
            }
            InputStream in = null;
            try {
                int index;
                List contentOfParent;
                in = this.getResourceAsStream(src);
                if (in != null) {
                    logger.debug((Object)("Adding include src: " + src));
                    this.includedSources.add(src);
                } else {
                    src = ele.attributeValue("src");
                    in = this.getResourceAsStream(src);
                    if (in != null) {
                        this.includedSources.add(src);
                        logger.debug((Object)("Adding include src: " + src));
                    } else {
                        File f = new File(this.getRootDir() + src);
                        if (f.exists()) {
                            try {
                                in = new FileInputStream(f);
                                this.includedSources.add(src);
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                Document doc = this.getDocFromInputStream(in);
                Element root = doc.getRootElement();
                String ignoreRoot = ele.attributeValue("ignoreroot");
                if (root.getName().equals("overlay")) {
                    this.processOverlay(root, ele.getDocument().getRootElement());
                    continue;
                }
                if (ignoreRoot == null || ignoreRoot.equalsIgnoreCase("false")) {
                    String newOnload;
                    logger.debug((Object)("Including entire file: " + src));
                    contentOfParent = ele.getParent().content();
                    index = contentOfParent.indexOf(ele);
                    contentOfParent.set(index, root);
                    if (root.getName().equals("dialog") && (newOnload = root.attributeValue("onload")) != null) {
                        String existingOnload = srcDoc.getRootElement().attributeValue("onload");
                        String finalOnload = "";
                        if (existingOnload != null) {
                            finalOnload = existingOnload + ", ";
                        }
                        finalOnload = finalOnload + newOnload;
                        srcDoc.getRootElement().setAttributeValue("onload", finalOnload);
                    }
                    List overlays = ele.elements();
                    for (Element overlay : overlays) {
                        logger.debug((Object)"Processing overlay within include");
                        this.processOverlay(overlay.attributeValue("src"), srcDoc);
                    }
                    continue;
                }
                logger.debug((Object)("Including children: " + src));
                contentOfParent = ele.getParent().content();
                index = contentOfParent.indexOf(ele);
                contentOfParent.remove(index);
                List children = root.elements();
                for (int i = children.size() - 1; i >= 0; --i) {
                    String newOnload;
                    Element child = (Element)children.get(i);
                    contentOfParent.add(index, child);
                    if (!child.getName().equals("dialog") || (newOnload = child.attributeValue("onload")) == null) continue;
                    String existingOnload = srcDoc.getRootElement().attributeValue("onload");
                    String finalOnload = "";
                    if (existingOnload != null) {
                        finalOnload = existingOnload + ", ";
                    }
                    finalOnload = finalOnload + newOnload;
                    srcDoc.getRootElement().setAttributeValue("onload", finalOnload);
                }
                List overlays = ele.elements();
                for (Element overlay : overlays) {
                    logger.debug((Object)"Processing overlay within include");
                    this.processOverlay(overlay.attributeValue("src"), srcDoc);
                }
            }
            finally {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return srcDoc;
    }

    protected Document getDocFromInputStream(InputStream in) throws XulException {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuffer buf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
            }
            in.close();
            String upperedIdDoc = this.upperCaseIDAttrs(buf.toString());
            SAXReader rdr = new SAXReader();
            return rdr.read((Reader)new StringReader(upperedIdDoc));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected Document findDocument(String src) throws XulException {
        Document doc = this.getDocFromClasspath(src);
        if (doc == null) {
            doc = this.getDocFromFile(src);
        }
        if (doc == null) {
            throw new XulException("Can not locate Xul document [" + src + "]");
        }
        return doc;
    }

    protected Document getDocFromClasspath(String src) throws XulException {
        InputStream in = this.getResourceAsStream(this.getRootDir() + src);
        if (in != null) {
            Document doc = this.getDocFromInputStream(in);
            return doc;
        }
        in = this.getResourceAsStream(src);
        if (in != null) {
            return this.getDocFromInputStream(in);
        }
        return null;
    }

    protected Document getDocFromFile(String src) throws XulException {
        File f = new File(this.getRootDir() + src);
        if (f.exists()) {
            try {
                Document doc = this.getDocFromInputStream(new FileInputStream(f));
                return doc;
            }
            catch (FileNotFoundException ignored) {}
        } else {
            f = new File(src);
            if (f.exists()) {
                try {
                    Document doc = this.getDocFromInputStream(new FileInputStream(f));
                    return doc;
                }
                catch (FileNotFoundException ignored) {}
            } else {
                return null;
            }
        }
        return null;
    }

    protected void processOverlay(String overlaySrc, Document doc) {
        try {
            Document overlayDoc = this.findDocument(overlaySrc);
            this.processOverlay(overlayDoc.getRootElement(), doc.getRootElement());
        }
        catch (Exception e) {
            logger.error((Object)("Could not load include overlay document: " + overlaySrc), (Throwable)e);
        }
    }

    protected void processOverlay(Element overlayEle, Element srcEle) {
        for (Object child : overlayEle.elements()) {
            Element overlay = (Element)child;
            String overlayId = overlay.attributeValue("ID");
            logger.debug((Object)("Processing overlay\nID: " + overlayId));
            Element sourceElement = srcEle.getDocument().elementByID(overlayId);
            if (sourceElement == null) {
                logger.error((Object)("Could not find corresponding element in src doc with id: " + overlayId));
                continue;
            }
            logger.debug((Object)"Found match in source doc:");
            String removeElement = overlay.attributeValue("removeelement");
            if (removeElement != null && removeElement.equalsIgnoreCase("true")) {
                sourceElement.getParent().remove(sourceElement);
                continue;
            }
            List attribs = overlay.attributes();
            for (Object o : attribs) {
                Attribute atr = (Attribute)o;
                sourceElement.addAttribute(atr.getName(), atr.getValue());
            }
            Document targetDocument = srcEle.getDocument();
            for (Object overlayChild : overlay.elements()) {
                String newOnload;
                Element pluckedElement = (Element)overlay.content().remove(overlay.content().indexOf(overlayChild));
                if (pluckedElement.getName().equals("dialog") && (newOnload = pluckedElement.attributeValue("onload")) != null) {
                    String existingOnload = targetDocument.getRootElement().attributeValue("onload");
                    String finalOnload = "";
                    if (existingOnload != null) {
                        finalOnload = existingOnload + ", ";
                    }
                    finalOnload = finalOnload + newOnload;
                    targetDocument.getRootElement().setAttributeValue("onload", finalOnload);
                }
                String insertBefore = pluckedElement.attributeValue("insertbefore");
                String insertAfter = pluckedElement.attributeValue("insertafter");
                String position = pluckedElement.attributeValue("position");
                int positionToInsert = -1;
                if (insertBefore != null) {
                    Element insertBeforeTarget = sourceElement.elementByID(insertBefore);
                    positionToInsert = sourceElement.elements().indexOf(insertBeforeTarget);
                } else if (insertAfter != null) {
                    Element insertAfterTarget = sourceElement.elementByID(insertAfter);
                    positionToInsert = sourceElement.elements().indexOf(insertAfterTarget);
                    if (positionToInsert != -1) {
                        ++positionToInsert;
                    }
                } else if (position != null) {
                    int pos = Integer.parseInt(position);
                    int n = positionToInsert = pos <= sourceElement.elements().size() ? pos : -1;
                }
                if (positionToInsert == -1) {
                    positionToInsert = sourceElement.elements().size();
                }
                if (positionToInsert > sourceElement.elements().size()) {
                    sourceElement.elements().add(pluckedElement);
                } else {
                    sourceElement.elements().add(positionToInsert, pluckedElement);
                }
                logger.debug((Object)("processed overlay child: " + ((Element)overlayChild).getName() + " : " + pluckedElement.getName()));
            }
        }
    }

    private InputStream getInputStreamForSrc(String src) {
        InputStream in = this.getResourceAsStream(this.getRootDir() + src);
        if (in == null && (in = this.getResourceAsStream(src)) == null) {
            File f = new File(src);
            if (f.exists()) {
                try {
                    in = new FileInputStream(f);
                }
                catch (FileNotFoundException e) {
                    logger.error((Object)e);
                }
            } else {
                logger.error((Object)"Cant find overlay source");
            }
        }
        return in;
    }

    @Override
    public void processOverlay(String overlaySrc, org.pentaho.ui.xul.dom.Document targetDocument, XulDomContainer container) throws XulException {
        String baseName = overlaySrc.replace(".xul", "");
        ResourceBundle res = this.loadResourceBundle(baseName);
        if (res == null) {
            baseName = (this.getRootDir() + overlaySrc).replace(".xul", "");
            res = this.loadResourceBundle(baseName);
            if (res == null) {
                logger.debug((Object)"could not find resource bundle, defaulting to main");
                res = this.mainBundle;
            } else {
                this.resourceBundleList.add(res);
            }
        } else {
            this.resourceBundleList.add(res);
        }
        this.processOverlay(overlaySrc, targetDocument, container, res);
    }

    @Override
    public void processOverlay(String overlaySrc, org.pentaho.ui.xul.dom.Document targetDocument, XulDomContainer container, Object resourceBundle) throws XulException {
        String upperedIdDoc;
        SAXReader rdr;
        InputStream in = this.getInputStreamForSrc(overlaySrc);
        Document doc = null;
        ResourceBundle res = (ResourceBundle)resourceBundle;
        String runningTranslatedOutput = this.getDocFromInputStream(in).asXML();
        if (resourceBundle != null) {
            try {
                runningTranslatedOutput = ResourceBundleTranslator.translate(runningTranslatedOutput, res);
            }
            catch (IOException e) {
                logger.error((Object)("Error loading resource bundle for overlay: " + overlaySrc), (Throwable)e);
            }
        }
        if (this.mainBundle != null) {
            try {
                runningTranslatedOutput = ResourceBundleTranslator.translate(runningTranslatedOutput, this.mainBundle);
                try {
                    rdr = new SAXReader();
                    upperedIdDoc = this.upperCaseIDAttrs(runningTranslatedOutput.toString());
                    doc = rdr.read((Reader)new StringReader(upperedIdDoc));
                }
                catch (DocumentException e) {
                    logger.error((Object)"Error loading XML while applying top level message bundle to overlay file:", (Throwable)e);
                }
            }
            catch (IOException e) {
                logger.error((Object)"Error loading Resource Bundle File to apply to overlay: ", (Throwable)e);
            }
        } else {
            try {
                rdr = new SAXReader();
                upperedIdDoc = this.upperCaseIDAttrs(runningTranslatedOutput.toString());
                doc = rdr.read((Reader)new StringReader(upperedIdDoc));
            }
            catch (DocumentException e) {
                logger.error((Object)"Error loading XML while applying top level message bundle to overlay file:", (Throwable)e);
            }
        }
        Element overlayRoot = doc.getRootElement();
        for (Object child : overlayRoot.elements()) {
            Element overlay = (Element)child;
            String overlayId = overlay.attributeValue("ID");
            String removeElement = overlay.attributeValue("removeelement");
            XulComponent sourceElement = targetDocument.getElementById(overlayId);
            if (sourceElement == null) {
                logger.warn((Object)("Cannot overlay element with id [" + overlayId + "] " + "as it does not exist in the target document."));
                continue;
            }
            if (removeElement != null && removeElement.equals("true")) {
                sourceElement.getParent().removeChild(sourceElement);
            }
            this.parser.setClassLoaders(this.classloaders);
            for (Object childToParse : overlay.elements()) {
                Element childElement = (Element)childToParse;
                logger.debug((Object)("Processing overlay on element with id: " + overlayId));
                this.parser.reset();
                this.parser.setContainer(container);
                XulComponent c = this.parser.parse(childElement, (XulContainer)sourceElement);
                String insertBefore = childElement.attributeValue("insertbefore");
                String insertAfter = childElement.attributeValue("insertafter");
                String position = childElement.attributeValue("position");
                XulContainer sourceContainer = (XulContainer)sourceElement;
                int positionToInsert = -1;
                if (insertBefore != null) {
                    XulComponent insertBeforeTarget = targetDocument.getElementById(insertBefore);
                    positionToInsert = sourceContainer.getChildNodes().indexOf(insertBeforeTarget);
                } else if (insertAfter != null) {
                    XulComponent insertAfterTarget = targetDocument.getElementById(insertAfter);
                    positionToInsert = sourceContainer.getChildNodes().indexOf(insertAfterTarget);
                    if (positionToInsert != -1) {
                        ++positionToInsert;
                    }
                } else if (position != null) {
                    int pos = Integer.parseInt(position);
                    int n = positionToInsert = pos <= sourceContainer.getChildNodes().size() ? pos : -1;
                }
                if (positionToInsert == -1 || positionToInsert == sourceContainer.getChildNodes().size()) {
                    sourceContainer.addChild(c);
                } else {
                    sourceContainer.addChildAt(c, positionToInsert);
                }
                this.notifyOverlayDomReady(c);
                logger.debug((Object)("added child: " + c));
            }
            List attribs = overlay.attributes();
            for (Object o : attribs) {
                Attribute atr = (Attribute)o;
                try {
                    BeanUtils.setProperty((Object)sourceElement, (String)atr.getName(), (Object)atr.getValue());
                    sourceElement.setAttribute(atr.getName(), atr.getValue());
                }
                catch (InvocationTargetException e) {
                    logger.error((Object)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    protected void notifyOverlayDomReady(XulComponent comp) {
        comp.onDomReady();
        for (XulComponent ele : comp.getChildNodes()) {
            this.notifyOverlayDomReady(ele);
        }
    }

    @Override
    public void removeOverlay(String overlaySrc, org.pentaho.ui.xul.dom.Document targetDocument, XulDomContainer container) throws XulException {
        Document doc = this.findDocument(overlaySrc);
        Element overlayRoot = doc.getRootElement();
        for (Object child : overlayRoot.elements()) {
            Element overlay = (Element)child;
            for (Object childToParse : overlay.elements()) {
                String childId = ((Element)childToParse).attributeValue("ID");
                XulComponent prevOverlayedEle = targetDocument.getElementById(childId);
                if (prevOverlayedEle == null) {
                    logger.debug((Object)("Source Element from target document is null: " + childId));
                    continue;
                }
                prevOverlayedEle.getParent().removeChild(prevOverlayedEle);
            }
        }
    }

    private String upperCaseIDAttrs(String src) {
        String result = src.replace(" id=", " ID=");
        return result;
    }

    @Override
    public void setOuterContext(Object context) {
        this.outerContext = context;
    }

    @Override
    public boolean isRegistered(String elementName) {
        return this.parser.handlers.containsKey(elementName);
    }

    @Override
    public void registerClassLoader(Object loader) {
        if (!this.classloaders.contains(loader)) {
            this.classloaders.add((ClassLoader)loader);
        }
    }

    @Override
    public void deRegisterClassLoader(Object loader) {
        if (this.classloaders.contains(loader)) {
            this.classloaders.remove(loader);
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        for (ClassLoader loader : this.classloaders) {
            InputStream str = loader.getResourceAsStream(name);
            if (str == null) continue;
            return str;
        }
        return null;
    }

    @Override
    public void setSettingsManager(XulSettingsManager settings) {
        this.settings = settings;
    }

    @Override
    public XulSettingsManager getSettingsManager() {
        return this.settings;
    }
}

