/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.impl.sql.graph;

import org.pentaho.metadata.query.impl.sql.graph.ConsistencyException;
import org.pentaho.metadata.query.impl.sql.graph.GraphElement;
import org.pentaho.metadata.query.impl.sql.graph.GraphElementRequirement;

public class GraphElementDomain {
    private GraphElement element;
    private GraphElementRequirement requirement;

    public GraphElementDomain(GraphElement element) {
        this.element = element;
        this.requirement = GraphElementRequirement.UNKNOWN;
    }

    public boolean setRequirement(boolean required) throws ConsistencyException {
        if (!required && this.requirement == GraphElementRequirement.NOT_REQUIRED || required && this.requirement == GraphElementRequirement.REQUIRED) {
            return false;
        }
        if (this.requirement != GraphElementRequirement.UNKNOWN) {
            throw new ConsistencyException(this.element);
        }
        this.requirement = required ? GraphElementRequirement.REQUIRED : GraphElementRequirement.NOT_REQUIRED;
        return true;
    }

    public void clearRequirement() {
        this.requirement = GraphElementRequirement.UNKNOWN;
    }

    public GraphElementRequirement getRequirement() {
        return this.requirement;
    }
}

