/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.concept.types.datatype;

import org.pentaho.pms.schema.concept.types.ConceptPropertyBase;
import org.pentaho.pms.schema.concept.types.ConceptPropertyType;
import org.pentaho.pms.schema.concept.types.datatype.DataTypeSettings;

public class ConceptPropertyDataType
extends ConceptPropertyBase
implements Cloneable {
    public static final ConceptPropertyDataType UNKNOWN = new ConceptPropertyDataType("datatype", DataTypeSettings.UNKNOWN);
    public static final ConceptPropertyDataType STRING = new ConceptPropertyDataType("datatype", DataTypeSettings.STRING);
    public static final ConceptPropertyDataType DATE = new ConceptPropertyDataType("datatype", DataTypeSettings.DATE);
    public static final ConceptPropertyDataType BOOLEAN = new ConceptPropertyDataType("datatype", DataTypeSettings.BOOLEAN);
    public static final ConceptPropertyDataType NUMERIC = new ConceptPropertyDataType("datatype", DataTypeSettings.NUMERIC);
    public static final ConceptPropertyDataType BINARY = new ConceptPropertyDataType("datatype", DataTypeSettings.BINARY);
    public static final ConceptPropertyDataType IMAGE = new ConceptPropertyDataType("datatype", DataTypeSettings.IMAGE);
    public static final ConceptPropertyDataType URL = new ConceptPropertyDataType("datatype", DataTypeSettings.URL);
    private DataTypeSettings value;

    public ConceptPropertyDataType(String name, DataTypeSettings value) {
        this(name, value, false);
    }

    public ConceptPropertyDataType(String name, DataTypeSettings value, boolean required) {
        super(name, required);
        this.value = value;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ConceptPropertyDataType rtn = (ConceptPropertyDataType)super.clone();
        if (this.value != null) {
            rtn.value = new DataTypeSettings(this.value.getType());
        }
        return rtn;
    }

    @Override
    public ConceptPropertyType getType() {
        return ConceptPropertyType.DATATYPE;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = (DataTypeSettings)value;
    }

    @Override
    public boolean equals(Object obj) {
        if (this.value != null) {
            return this.value.equals(obj);
        }
        return this.value == obj;
    }

    @Override
    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return -1;
    }
}

