/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.pms.schema.security.SecurityOwner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RowLevelSecurity
implements Cloneable {
    private static final String ATTR_VALUE_NONE = "none";
    private static final String ATTR_VALUE_ROLE_BASED = "role-based";
    private static final String ATTR_VALUE_GLOBAL = "global";
    private static final String EQUALS = "=";
    private static final String SPACE = " ";
    private static final Log logger = LogFactory.getLog(RowLevelSecurity.class);
    private static final String EMPTY_STRING = "";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String EMPTY_ELEM_NAME_END = " />";
    private static final String FINISH_ELEM_NAME_BEGIN = "</";
    private static final String ELEM_NAME_END = ">";
    private static final String START_ELEM_NAME_BEGIN = "<";
    private static final String ELEM_FORMULA = "formula";
    private static final String ELEM_ROW_LEVEL_SECURITY = "row-level-security";
    private static final String ELEM_ENTRIES = "entries";
    private static final String ELEM_ENTRY = "entry";
    private static final String ELEM_OWNER = "owner";
    private static final String FUNC_AND = "AND";
    private static final String FUNC_OR = "OR";
    private static final String FUNC_IN = "IN";
    private static final String PARAM_LIST_BEGIN = "(";
    private static final String PARAM_LIST_END = ")";
    private static final String PARAM_SEPARATOR = ";";
    private static final String FUNC_ROLES = "ROLES()";
    private static final String FUNC_USER = "USER()";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_QUOTE = "\"";
    private static final String PARAM_QUOTE = "\"";
    private Type type;
    private String globalConstraint = "";
    private Map<SecurityOwner, String> roleBasedConstraintMap = new HashMap<SecurityOwner, String>();

    public RowLevelSecurity(String globalConstraint) {
        this(Type.GLOBAL, globalConstraint, null);
    }

    public RowLevelSecurity(Map<SecurityOwner, String> roleBasedConstraintMap) {
        this(Type.ROLEBASED, null, roleBasedConstraintMap);
    }

    public RowLevelSecurity() {
        this(Type.NONE, null, null);
    }

    public RowLevelSecurity(Type type, String globalConstraint, Map<SecurityOwner, String> roleBasedConstraintMap) {
        this.setGlobalConstraint(globalConstraint);
        this.setRoleBasedConstraintMap(roleBasedConstraintMap);
        this.type = type;
    }

    public Object clone() throws CloneNotSupportedException {
        return new RowLevelSecurity(this.type, this.globalConstraint, this.roleBasedConstraintMap != null ? this.cloneRoleBasedConstraintMap(this.roleBasedConstraintMap) : null);
    }

    protected Map<SecurityOwner, String> cloneRoleBasedConstraintMap(Map<SecurityOwner, String> map) {
        HashMap<SecurityOwner, String> copy = new HashMap<SecurityOwner, String>();
        for (Map.Entry<SecurityOwner, String> entry : map.entrySet()) {
            SecurityOwner clonedOwner = (SecurityOwner)entry.getKey().clone();
            copy.put(clonedOwner, entry.getValue());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RowLevelSecurity)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        RowLevelSecurity rhs = (RowLevelSecurity)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)rhs.type).append((Object)this.globalConstraint, (Object)rhs.globalConstraint).append(this.roleBasedConstraintMap, rhs.roleBasedConstraintMap).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 71).append((Object)this.type).append((Object)this.globalConstraint).append(this.roleBasedConstraintMap).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(ATTR_TYPE, (Object)this.type).append("globalConstraint", (Object)this.globalConstraint).append("roleBasedConstraintMap", this.roleBasedConstraintMap).toString();
    }

    public String toXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(START_ELEM_NAME_BEGIN).append(ELEM_ROW_LEVEL_SECURITY).append(SPACE).append(ATTR_TYPE).append(EQUALS);
        if (this.isGlobal()) {
            xml.append("\"").append(ATTR_VALUE_GLOBAL).append("\"");
        } else if (this.isRoleBased()) {
            xml.append("\"").append(ATTR_VALUE_ROLE_BASED).append("\"");
        } else {
            xml.append("\"").append(ATTR_VALUE_NONE).append("\"");
        }
        xml.append(ELEM_NAME_END);
        xml.append(START_ELEM_NAME_BEGIN).append(ELEM_FORMULA).append(ELEM_NAME_END);
        xml.append(CDATA_BEGIN).append(this.globalConstraint).append(CDATA_END);
        xml.append(FINISH_ELEM_NAME_BEGIN).append(ELEM_FORMULA).append(ELEM_NAME_END);
        xml.append(START_ELEM_NAME_BEGIN).append(ELEM_ENTRIES).append(ELEM_NAME_END);
        for (Map.Entry<SecurityOwner, String> entry : this.roleBasedConstraintMap.entrySet()) {
            xml.append(START_ELEM_NAME_BEGIN).append(ELEM_ENTRY).append(ELEM_NAME_END);
            SecurityOwner owner = entry.getKey();
            String formula = entry.getValue();
            xml.append(owner.toXML());
            xml.append(START_ELEM_NAME_BEGIN).append(ELEM_FORMULA).append(ELEM_NAME_END);
            xml.append(CDATA_BEGIN).append(formula).append(CDATA_END);
            xml.append(FINISH_ELEM_NAME_BEGIN).append(ELEM_FORMULA).append(ELEM_NAME_END);
            xml.append(FINISH_ELEM_NAME_BEGIN).append(ELEM_ENTRY).append(ELEM_NAME_END);
        }
        xml.append(FINISH_ELEM_NAME_BEGIN).append(ELEM_ENTRIES).append(ELEM_NAME_END);
        xml.append(FINISH_ELEM_NAME_BEGIN).append(ELEM_ROW_LEVEL_SECURITY).append(ELEM_NAME_END);
        return xml.toString();
    }

    public RowLevelSecurity(Node rlsNode) throws Exception {
        String typeString = rlsNode.getAttributes().getNamedItem(ATTR_TYPE).getTextContent();
        this.type = ATTR_VALUE_GLOBAL.equals(typeString) ? Type.GLOBAL : (ATTR_VALUE_ROLE_BASED.equals(typeString) ? Type.ROLEBASED : Type.NONE);
        Node globalFormulaNode = XMLHandler.getSubNode((Node)rlsNode, (String)ELEM_FORMULA);
        this.globalConstraint = globalFormulaNode.getTextContent();
        HashMap<SecurityOwner, String> map = new HashMap<SecurityOwner, String>();
        Node entriesNode = XMLHandler.getSubNode((Node)rlsNode, (String)ELEM_ENTRIES);
        int entryCount = XMLHandler.countNodes((Node)entriesNode, (String)ELEM_ENTRY);
        for (int i = 0; i < entryCount; ++i) {
            Node entryNode = XMLHandler.getSubNodeByNr((Node)entriesNode, (String)ELEM_ENTRY, (int)i);
            Node ownerNode = XMLHandler.getSubNode((Node)entryNode, (String)ELEM_OWNER);
            SecurityOwner owner = new SecurityOwner(ownerNode);
            Node formulaNode = XMLHandler.getSubNode((Node)entryNode, (String)ELEM_FORMULA);
            String formula = formulaNode.getTextContent();
            map.put(owner, formula);
        }
        this.roleBasedConstraintMap = map;
    }

    public static RowLevelSecurity fromXML(String value) throws Exception {
        Document doc = XMLHandler.loadXMLString((String)value);
        return new RowLevelSecurity(XMLHandler.getSubNode((Node)doc, (String)ELEM_ROW_LEVEL_SECURITY));
    }

    public boolean isGlobal() {
        return this.type == Type.GLOBAL;
    }

    public boolean isRoleBased() {
        return this.type == Type.ROLEBASED;
    }

    protected String generateRuleBasedConstraint(String user, List<String> roles) {
        ArrayList<String> pieces = new ArrayList<String>();
        for (Map.Entry<SecurityOwner, String> entry : this.roleBasedConstraintMap.entrySet()) {
            SecurityOwner owner = entry.getKey();
            String formula = entry.getValue();
            if ((owner.getOwnerType() != 0 || !owner.getOwnerName().equals(user)) && (roles == null || owner.getOwnerType() != 1 || !roles.contains(owner.getOwnerName()))) continue;
            pieces.add(formula);
        }
        if (pieces.size() == 0) {
            return "FALSE()";
        }
        if (pieces.size() == 1) {
            return (String)pieces.get(0);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(FUNC_OR);
        buf.append(PARAM_LIST_BEGIN);
        int index = 0;
        for (String piece : pieces) {
            if (index > 0) {
                buf.append(PARAM_SEPARATOR);
            }
            buf.append(piece);
            ++index;
        }
        buf.append(PARAM_LIST_END);
        return buf.toString();
    }

    protected String getIntermediateFormula() {
        if (this.isGlobal()) {
            return this.globalConstraint;
        }
        if (this.isRoleBased()) {
            return this.roleMapToFormula();
        }
        return EMPTY_STRING;
    }

    protected String roleMapToFormula() {
        ArrayList<String> pieces = new ArrayList<String>();
        for (Map.Entry<SecurityOwner, String> entry : this.roleBasedConstraintMap.entrySet()) {
            SecurityOwner owner = entry.getKey();
            String formula = entry.getValue();
            StringBuilder formulaBuf = new StringBuilder();
            formulaBuf.append(FUNC_AND).append(PARAM_LIST_BEGIN).append(FUNC_IN).append(PARAM_LIST_BEGIN).append("\"").append(owner.getOwnerName()).append("\"").append(PARAM_SEPARATOR).append(owner.getOwnerType() == 1 ? FUNC_ROLES : FUNC_USER).append(PARAM_LIST_END).append(PARAM_SEPARATOR).append(formula).append(PARAM_LIST_END);
            pieces.add(formulaBuf.toString());
        }
        StringBuilder buf = new StringBuilder();
        buf.append(FUNC_OR);
        buf.append(PARAM_LIST_BEGIN);
        int index = 0;
        for (String piece : pieces) {
            if (index > 0) {
                buf.append(PARAM_SEPARATOR);
            }
            buf.append(piece);
            ++index;
        }
        buf.append(PARAM_LIST_END);
        logger.debug((Object)("singleFormula: " + buf));
        return buf.toString();
    }

    public String getMQLFormula(String user, List<String> roles) {
        if (this.isGlobal()) {
            return this.expandFunctions(this.globalConstraint, user, roles);
        }
        if (this.isRoleBased()) {
            return this.generateRuleBasedConstraint(user, roles);
        }
        return EMPTY_STRING;
    }

    protected String expandFunctions(String formula, String user, List<String> roles) {
        formula = formula.replaceAll("USER\\(\\)", String.format("\"%s\"", user));
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (String role : roles) {
            if (i > 0) {
                buf.append(PARAM_SEPARATOR);
            }
            buf.append(String.format("\"%s\"", role));
            ++i;
        }
        return formula.replaceAll("ROLES\\(\\)", buf.toString());
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getGlobalConstraint() {
        return this.globalConstraint;
    }

    public void setGlobalConstraint(String globalConstraint) {
        this.globalConstraint = globalConstraint != null ? globalConstraint : EMPTY_STRING;
    }

    public Map<SecurityOwner, String> getRoleBasedConstraintMap() {
        return this.roleBasedConstraintMap;
    }

    public void setRoleBasedConstraintMap(Map<SecurityOwner, String> roleBasedConstraintMap) {
        this.roleBasedConstraintMap = roleBasedConstraintMap != null ? roleBasedConstraintMap : new HashMap<SecurityOwner, String>();
    }

    public static void main(String[] args) {
        String formula = "OR(AND(IN(\"suzy\";USER());[BT_CUSTOMER_W_TER_CUSTOMER_W_TER.BC_CUSTOMER_W_TER_COUNTRY] = \"USA\"))";
        formula = formula.replaceAll("USER\\(\\)", String.format("\"%s\"", "whatever"));
        System.out.println(formula);
    }

    public static enum Type {
        NONE,
        GLOBAL,
        ROLEBASED;

    }
}

