/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard;

import java.awt.Color;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroupBody;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.filter.types.ContentType;
import org.pentaho.reporting.engine.classic.core.filter.types.LabelType;
import org.pentaho.reporting.engine.classic.core.filter.types.TextFieldType;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.wizard.AutoGeneratorUtility;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.RelationalAutoGeneratorPreProcessor;
import org.pentaho.reporting.engine.classic.wizard.WizardOverrideFormattingFunction;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DetailFieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.FieldDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupType;
import org.pentaho.reporting.engine.classic.wizard.model.Length;
import org.pentaho.reporting.engine.classic.wizard.model.RootBandDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.WatermarkDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class WizardProcessor
extends AbstractReportPreProcessor {
    private static final Log logger = LogFactory.getLog(WizardProcessor.class);
    protected DefaultDataAttributeContext attributeContext;
    protected AbstractReportDefinition definition;
    protected DefaultFlowController flowController;
    protected WizardSpecification wizardSpecification;

    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        return (MasterReport)this.performCommonPreProcessing((AbstractReportDefinition)definition, flowController, definition.getResourceManager());
    }

    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        return (SubReport)this.performCommonPreProcessing((AbstractReportDefinition)definition, flowController, definition.getResourceManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractReportDefinition performCommonPreProcessing(AbstractReportDefinition definition, DefaultFlowController flowController, ResourceManager resourceManager) throws ReportProcessingException {
        try {
            this.wizardSpecification = WizardProcessorUtil.loadWizardSpecification(definition, resourceManager);
            if (this.wizardSpecification == null) {
                AbstractReportDefinition abstractReportDefinition = definition;
                return abstractReportDefinition;
            }
            StructureFunction[] functions = definition.getStructureFunctions();
            boolean hasOverrideFunction = false;
            for (int i = 0; i < functions.length; ++i) {
                StructureFunction function = functions[i];
                if (!(function instanceof WizardOverrideFormattingFunction)) continue;
                hasOverrideFunction = true;
                break;
            }
            if (!hasOverrideFunction) {
                definition.addStructureFunction((StructureFunction)new WizardOverrideFormattingFunction());
            }
            ProcessingContext reportContext = flowController.getReportContext();
            this.definition = definition;
            this.flowController = flowController;
            this.attributeContext = new DefaultDataAttributeContext(reportContext.getOutputProcessorMetaData(), reportContext.getResourceBundleFactory().getLocale());
            Object o = definition.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable");
            if (!Boolean.TRUE.equals(o)) {
                AbstractReportDefinition abstractReportDefinition = this.performRefreshPreProcessing();
                return abstractReportDefinition;
            }
            AbstractReportDefinition abstractReportDefinition = this.performGenerationPreProcessing();
            return abstractReportDefinition;
        }
        finally {
            this.wizardSpecification = null;
            this.definition = null;
            this.flowController = null;
            this.attributeContext = null;
        }
    }

    private AbstractReportDefinition performRefreshPreProcessing() throws ReportProcessingException {
        GroupDefinition[] groupDefinitions = this.wizardSpecification.getGroupDefinitions();
        int wizardCount = groupDefinitions.length;
        int groupCount = this.definition.getGroupCount();
        int count = Math.min(groupCount, wizardCount);
        for (int i = 0; i < count; ++i) {
            int groupIdx = groupCount - i - 1;
            int wizGroupIdx = wizardCount - i - 1;
            GroupDefinition gd = groupDefinitions[wizGroupIdx];
            RelationalGroup g = this.definition.getRelationalGroup(groupIdx);
            if (g == null) break;
            GroupHeader groupHeader = g.getHeader();
            GroupFooter groupFooter = g.getFooter();
            this.iterateSection((Section)groupHeader, new UpdateHeaderTask(gd));
            this.iterateSection((Section)groupFooter, new UpdateFooterTask(gd));
        }
        ItemBand itemband = this.definition.getItemBand();
        DetailsHeader detailsHeader = this.definition.getDetailsHeader();
        DetailsFooter detailsFooter = this.definition.getDetailsFooter();
        DetailFieldDefinition[] detailFieldDefinitions = this.wizardSpecification.getDetailFieldDefinitions();
        for (int i = 0; i < detailFieldDefinitions.length; ++i) {
            DetailFieldDefinition fieldDefinition = detailFieldDefinitions[i];
            UpdateDetailsTask updateTask = new UpdateDetailsTask(fieldDefinition);
            this.iterateSection((Section)itemband, updateTask);
            this.iterateSection((Section)detailsHeader, updateTask);
            this.iterateSection((Section)detailsFooter, updateTask);
        }
        return this.definition;
    }

    protected void iterateSection(Section s, UpdateTask task) {
        int count = s.getElementCount();
        for (int i = 0; i < count; ++i) {
            Element element = s.getElement(i);
            task.processElement((ReportElement)element);
            if (element instanceof SubReport || !(element instanceof Section)) continue;
            this.iterateSection((Section)element, task);
        }
    }

    protected AbstractReportDefinition performGenerationPreProcessing() throws ReportProcessingException {
        this.setupWatermark();
        this.setupRelationalGroups();
        this.setupDetails();
        return this.definition;
    }

    private void clearCrosstab() {
        CrosstabGroup crosstabGroup = this.lookupCrosstab();
        if (crosstabGroup != null) {
            if (this.definition.getRootGroup() == crosstabGroup) {
                this.definition.setRootGroup((Group)new RelationalGroup());
            } else {
                Section parentSection = crosstabGroup.getParentSection();
                if (parentSection instanceof SubGroupBody) {
                    SubGroupBody sgb = (SubGroupBody)parentSection;
                    sgb.setGroup((Group)new RelationalGroup());
                }
            }
        }
    }

    private void setupCrosstab() throws ReportProcessingException {
        CrosstabOtherGroup relationalGroup;
        GroupDefinition groupDefinition;
        int i;
        CrosstabGroup crosstab = this.lookupCrosstab();
        if (crosstab == null) {
            crosstab = new CrosstabGroup();
            this.insertCrosstab(crosstab);
        }
        CrosstabGroup insertGroup = crosstab;
        GroupDefinition[] groupDefinitions = this.wizardSpecification.getGroupDefinitions();
        for (i = 0; i < groupDefinitions.length; ++i) {
            groupDefinition = groupDefinitions[i];
            if (!GroupType.CT_OTHER.equals(groupDefinition.getGroupType())) continue;
            relationalGroup = new CrosstabOtherGroup();
            if (groupDefinition.getGroupName() != null) {
                relationalGroup.setName(groupDefinition.getGroupName());
            }
            this.configureCrosstabOtherGroup(relationalGroup, groupDefinition);
            insertGroup.setBody((GroupBody)new CrosstabOtherGroupBody(relationalGroup));
            insertGroup = relationalGroup;
        }
        for (i = 0; i < groupDefinitions.length; ++i) {
            groupDefinition = groupDefinitions[i];
            if (!GroupType.CT_ROW.equals(groupDefinition.getGroupType())) continue;
            relationalGroup = new CrosstabRowGroup();
            if (groupDefinition.getGroupName() != null) {
                relationalGroup.setName(groupDefinition.getGroupName());
            }
            this.configureCrosstabRowGroup((CrosstabRowGroup)relationalGroup, groupDefinition);
            insertGroup.setBody((GroupBody)new CrosstabRowGroupBody((CrosstabRowGroup)relationalGroup));
            insertGroup = relationalGroup;
        }
        for (i = 0; i < groupDefinitions.length; ++i) {
            groupDefinition = groupDefinitions[i];
            if (!GroupType.CT_COLUMN.equals(groupDefinition.getGroupType())) continue;
            relationalGroup = new CrosstabColumnGroup();
            if (groupDefinition.getGroupName() != null) {
                relationalGroup.setName(groupDefinition.getGroupName());
            }
            this.configureCrosstabColumnGroup((CrosstabColumnGroup)relationalGroup, groupDefinition);
            insertGroup.setBody((GroupBody)new CrosstabColumnGroupBody((CrosstabColumnGroup)relationalGroup));
            insertGroup = relationalGroup;
        }
        Band itemBand = AutoGeneratorUtility.findGeneratedContent((Band)this.definition.getItemBand());
        if (itemBand == null) {
            return;
        }
        DetailFieldDefinition[] detailFieldDefinitions = this.wizardSpecification.getDetailFieldDefinitions();
        if (detailFieldDefinitions.length == 0) {
            return;
        }
        Float[] widthSpecs = new Float[detailFieldDefinitions.length];
        for (int i2 = 0; i2 < detailFieldDefinitions.length; ++i2) {
            DetailFieldDefinition fieldDefinition = detailFieldDefinitions[i2];
            Length length = fieldDefinition.getWidth();
            if (length == null) continue;
            widthSpecs[i2] = length.getNormalizedValue();
        }
        float[] computedWidth = AutoGeneratorUtility.computeFieldWidths((Float[])widthSpecs, (float)this.definition.getPageDefinition().getWidth());
        itemBand.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"row");
        for (int i3 = 0; i3 < detailFieldDefinitions.length; ++i3) {
            DetailFieldDefinition detailFieldDefinition = detailFieldDefinitions[i3];
            this.setupField(null, null, itemBand, detailFieldDefinition, computedWidth[i3], i3);
        }
    }

    protected void setupDetails() throws ReportProcessingException {
        DetailFieldDefinition[] detailFieldDefinitions = this.wizardSpecification.getDetailFieldDefinitions();
        if (detailFieldDefinitions.length == 0) {
            if (this.wizardSpecification.isAutoGenerateDetails()) {
                RelationalAutoGeneratorPreProcessor generatorPreProcessor = new RelationalAutoGeneratorPreProcessor();
                if (this.definition instanceof MasterReport) {
                    generatorPreProcessor.performPreProcessing((MasterReport)this.definition, this.flowController);
                } else if (this.definition instanceof SubReport) {
                    generatorPreProcessor.performPreProcessing((SubReport)this.definition, this.flowController);
                }
            }
            return;
        }
        this.definition.getDetailsHeader().setRepeat(true);
        this.definition.getDetailsFooter().setRepeat(true);
        Band detailsHeader = AutoGeneratorUtility.findGeneratedContent((Band)this.definition.getDetailsHeader());
        Band detailsFooter = AutoGeneratorUtility.findGeneratedContent((Band)this.definition.getDetailsFooter());
        Band itemBand = AutoGeneratorUtility.findGeneratedContent((Band)this.definition.getItemBand());
        if (itemBand == null) {
            return;
        }
        Float[] widthSpecs = new Float[detailFieldDefinitions.length];
        for (int i = 0; i < detailFieldDefinitions.length; ++i) {
            DetailFieldDefinition fieldDefinition = detailFieldDefinitions[i];
            Length length = fieldDefinition.getWidth();
            if (length == null) continue;
            widthSpecs[i] = length.getNormalizedValue();
        }
        float[] computedWidth = AutoGeneratorUtility.computeFieldWidths((Float[])widthSpecs, (float)this.definition.getPageDefinition().getWidth());
        itemBand.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"row");
        if (detailsHeader != null) {
            detailsHeader.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"row");
        }
        if (detailsFooter != null) {
            detailsFooter.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"row");
        }
        for (int i = 0; i < detailFieldDefinitions.length; ++i) {
            DetailFieldDefinition detailFieldDefinition = detailFieldDefinitions[i];
            this.setupField(detailsHeader, detailsFooter, itemBand, detailFieldDefinition, computedWidth[i], i);
        }
        if (detailsFooter != null) {
            Element[] elements = detailsFooter.getElementArray();
            boolean footerEmpty = true;
            for (int i = 0; i < elements.length; ++i) {
                Element element = elements[i];
                if (LabelType.class.isInstance(element.getElementType())) continue;
                footerEmpty = false;
                break;
            }
            if (footerEmpty) {
                detailsFooter.clear();
            }
        }
    }

    protected void setupDefaultPadding(Band band, Element detailElement) {
        Object maybePaddingTop = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "padding-top");
        Object maybePaddingLeft = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "padding-left");
        Object maybePaddingBottom = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "padding-bottom");
        Object maybePaddingRight = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "padding-right");
        if (!(maybePaddingTop instanceof Number && maybePaddingLeft instanceof Number && maybePaddingBottom instanceof Number && maybePaddingRight instanceof Number)) {
            return;
        }
        Number paddingTop = (Number)maybePaddingTop;
        Number paddingLeft = (Number)maybePaddingLeft;
        Number paddingBottom = (Number)maybePaddingBottom;
        Number paddingRight = (Number)maybePaddingRight;
        ElementStyleSheet styleSheet = detailElement.getStyle();
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_TOP, (Object)new Float(paddingTop.floatValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_LEFT, (Object)new Float(paddingLeft.floatValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_BOTTOM, (Object)new Float(paddingBottom.floatValue()));
        styleSheet.setStyleProperty(ElementStyleKeys.PADDING_RIGHT, (Object)new Float(paddingRight.floatValue()));
    }

    protected void setupDefaultGrid(Band band, Element detailElement) {
        this.setupDefaultPadding(band, detailElement);
        ElementStyleSheet styleSheet = detailElement.getStyle();
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)new Float(-100.0f));
        Object maybeBorderStyle = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "grid-style");
        Object maybeBorderWidth = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "grid-width");
        Object maybeBorderColor = band.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "grid-color");
        if (!(maybeBorderColor instanceof Color && maybeBorderStyle instanceof BorderStyle && maybeBorderWidth instanceof Number)) {
            return;
        }
        BorderStyle style = (BorderStyle)maybeBorderStyle;
        Color color = (Color)maybeBorderColor;
        Number number = (Number)maybeBorderWidth;
        Float width = new Float(number.floatValue());
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_WIDTH, (Object)width);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_COLOR, (Object)color);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_TOP_STYLE, (Object)style);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_WIDTH, (Object)width);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_COLOR, (Object)color);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_LEFT_STYLE, (Object)style);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_WIDTH, (Object)width);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_COLOR, (Object)color);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_BOTTOM_STYLE, (Object)style);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_WIDTH, (Object)width);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_COLOR, (Object)color);
        styleSheet.setStyleProperty(ElementStyleKeys.BORDER_RIGHT_STYLE, (Object)style);
    }

    protected void setupField(Band detailsHeader, Band detailsFooter, Band itemBand, DetailFieldDefinition field, float width, int fieldIdx) throws ReportProcessingException {
        if (StringUtils.isEmpty((String)field.getField())) {
            return;
        }
        Element detailElement = AutoGeneratorUtility.generateDetailsElement((String)field.getField(), (ElementType)this.computeElementType(field));
        this.setupDefaultGrid(itemBand, detailElement);
        String id = "wizard::details-" + field.getField();
        detailElement.setName(id);
        detailElement.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(width));
        if (Boolean.TRUE.equals(detailElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
            detailElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)field);
        }
        if (Boolean.TRUE.equals(detailElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
            detailElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)field);
        }
        itemBand.addElement(detailElement);
        if (Boolean.TRUE.equals(field.getOnlyShowChangingValues())) {
            detailElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "only-show-changing-values", (Object)Boolean.TRUE);
        }
        if (detailsHeader != null) {
            Element headerElement = AutoGeneratorUtility.generateHeaderElement((String)field.getField());
            this.setupDefaultGrid(detailsHeader, headerElement);
            headerElement.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(width));
            if (Boolean.TRUE.equals(headerElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
                headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)field);
            }
            if (Boolean.TRUE.equals(headerElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
                headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)field);
            }
            headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "horizontal-alignment", (Object)field.getHorizontalAlignment());
            detailsHeader.addElement(headerElement);
        }
        if (detailsFooter != null) {
            Class aggFunctionClass = field.getAggregationFunction();
            Element footerElement = AutoGeneratorUtility.generateFooterElement((Class)aggFunctionClass, (ElementType)this.computeElementType(field), null, (String)field.getField());
            this.setupDefaultGrid(detailsFooter, footerElement);
            footerElement.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(width));
            if (Boolean.TRUE.equals(footerElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
                footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)field);
            }
            if (Boolean.TRUE.equals(footerElement.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
                footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)field);
            }
            detailsFooter.addElement(footerElement);
        }
    }

    private void removedUnusedTemplateGroups(int groupsDefined) {
        RelationalGroup[] templateRelationalGroups = this.getTemplateRelationalGroups();
        int templateRelationalGroupCount = templateRelationalGroups.length;
        for (int i = groupsDefined; i < templateRelationalGroupCount; ++i) {
            RelationalGroup templateRelationalGroup = templateRelationalGroups[i];
            this.definition.removeGroup(templateRelationalGroup);
        }
    }

    private RelationalGroup[] getTemplateRelationalGroups() {
        ArrayList<RelationalGroup> relationalGroups = new ArrayList<RelationalGroup>();
        Group group = this.definition.getRootGroup();
        while (group != null && group instanceof RelationalGroup) {
            relationalGroups.add((RelationalGroup)group);
            GroupBody body = group.getBody();
            if (body instanceof SubGroupBody) {
                SubGroupBody sgBody = (SubGroupBody)body;
                if (sgBody.getGroup() instanceof RelationalGroup) {
                    group = sgBody.getGroup();
                    continue;
                }
                group = null;
                continue;
            }
            group = null;
        }
        return relationalGroups.toArray(new RelationalGroup[relationalGroups.size()]);
    }

    private void setupRelationalGroups() throws ReportProcessingException {
        Group rootgroup = this.definition.getRootGroup();
        RelationalGroup group = !(rootgroup instanceof RelationalGroup) ? null : (RelationalGroup)rootgroup;
        RelationalGroup template = this.findInnermostRelationalGroup(this.definition);
        GroupDefinition[] groupDefinitions = this.wizardSpecification.getGroupDefinitions();
        for (int i = 0; i < groupDefinitions.length; ++i) {
            GroupDefinition groupDefinition = groupDefinitions[i];
            GroupType type = groupDefinition.getGroupType();
            if (type != null && !GroupType.RELATIONAL.equals(type)) continue;
            if (group == null) {
                RelationalGroup relationalGroup = template != null ? (RelationalGroup)template.derive() : new RelationalGroup();
                if (groupDefinition.getGroupName() != null) {
                    relationalGroup.setName(groupDefinition.getGroupName());
                }
                this.configureRelationalGroup(relationalGroup, groupDefinition, i);
                this.insertGroup(relationalGroup);
                continue;
            }
            this.configureRelationalGroup(group, groupDefinition, i);
            GroupBody body = group.getBody();
            if (body instanceof SubGroupBody) {
                SubGroupBody sgBody = (SubGroupBody)body;
                if (sgBody.getGroup() instanceof RelationalGroup) {
                    group = (RelationalGroup)sgBody.getGroup();
                    continue;
                }
                group = null;
                continue;
            }
            group = null;
        }
        this.removedUnusedTemplateGroups(groupDefinitions.length);
    }

    private RelationalGroup findInnermostRelationalGroup(AbstractReportDefinition definition) {
        RelationalGroup retval = null;
        Group existingGroup = definition.getRootGroup();
        while (existingGroup instanceof RelationalGroup) {
            retval = (RelationalGroup)existingGroup;
            GroupBody body = existingGroup.getBody();
            if (!(body instanceof SubGroupBody)) {
                return retval;
            }
            SubGroupBody sgb = (SubGroupBody)body;
            existingGroup = sgb.getGroup();
        }
        return retval;
    }

    private void insertCrosstab(CrosstabGroup crosstabGroup) {
        Group existingGroup = this.definition.getRootGroup();
        GroupBody gb = existingGroup.getBody();
        while (gb instanceof SubGroupBody) {
            SubGroupBody sgb = (SubGroupBody)gb;
            existingGroup = sgb.getGroup();
            gb = existingGroup.getBody();
        }
        existingGroup.setBody((GroupBody)new SubGroupBody((Group)crosstabGroup));
    }

    private CrosstabGroup lookupCrosstab() {
        Group existingGroup = this.definition.getRootGroup();
        if (existingGroup instanceof CrosstabGroup) {
            return (CrosstabGroup)existingGroup;
        }
        GroupBody gb = existingGroup.getBody();
        while (gb instanceof SubGroupBody) {
            SubGroupBody sgb = (SubGroupBody)gb;
            existingGroup = sgb.getGroup();
            if (existingGroup instanceof CrosstabGroup) {
                return (CrosstabGroup)existingGroup;
            }
            gb = existingGroup.getBody();
        }
        return null;
    }

    private void insertGroup(RelationalGroup group) {
        Group lastGroup = null;
        Group insertGroup = this.definition.getRootGroup();
        while (true) {
            SubGroupBody sgb;
            GroupBody body;
            if (!(insertGroup instanceof RelationalGroup)) {
                if (lastGroup == null) {
                    this.definition.setRootGroup((Group)group);
                    group.setBody((GroupBody)new SubGroupBody(insertGroup));
                    return;
                }
                body = lastGroup.getBody();
                sgb = new SubGroupBody((Group)group);
                lastGroup.setBody((GroupBody)sgb);
                group.setBody(body);
                return;
            }
            body = insertGroup.getBody();
            if (!(body instanceof SubGroupBody)) {
                sgb = new SubGroupBody((Group)group);
                insertGroup.setBody((GroupBody)sgb);
                group.setBody(body);
                return;
            }
            lastGroup = insertGroup;
            sgb = (SubGroupBody)body;
            insertGroup = sgb.getGroup();
        }
    }

    private void configureCrosstabOtherGroup(CrosstabOtherGroup group, GroupDefinition groupDefinition) throws ReportProcessingException {
        String groupField = groupDefinition.getField();
        group.setField(groupField);
        this.configureCrosstabGroupHeader((Group)group, groupDefinition);
        this.configureCrosstabGroupFooter((Group)group, groupDefinition);
    }

    private void configureCrosstabRowGroup(CrosstabRowGroup group, GroupDefinition groupDefinition) throws ReportProcessingException {
        String groupField = groupDefinition.getField();
        group.setField(groupField);
        this.configureCrosstabGroupHeader((Group)group, groupDefinition);
        this.configureCrosstabGroupFooter((Group)group, groupDefinition);
    }

    private void configureCrosstabColumnGroup(CrosstabColumnGroup group, GroupDefinition groupDefinition) throws ReportProcessingException {
        String groupField = groupDefinition.getField();
        group.setField(groupField);
        this.configureCrosstabGroupHeader((Group)group, groupDefinition);
        this.configureCrosstabGroupFooter((Group)group, groupDefinition);
    }

    protected void configureRelationalGroup(RelationalGroup group, GroupDefinition groupDefinition, int index) throws ReportProcessingException {
        String groupField = groupDefinition.getField();
        if (groupField != null) {
            group.setFieldsArray(new String[]{groupField});
        }
        this.configureRelationalGroupFooter(group, groupDefinition, index);
        this.configureRelationalGroupHeader(group, groupDefinition, index);
    }

    private void configureCrosstabGroupHeader(Group group, GroupDefinition groupDefinition) {
    }

    protected void configureRelationalGroupHeader(RelationalGroup group, GroupDefinition groupDefinition, int index) {
        RootBandDefinition headerDefinition = groupDefinition.getHeader();
        if (headerDefinition.isVisible()) {
            Band content;
            GroupHeader header = group.getHeader();
            Boolean repeat = headerDefinition.getRepeat();
            if (repeat != null) {
                header.setRepeat(repeat.booleanValue());
            }
            if ((content = AutoGeneratorUtility.findGeneratedContent((Band)header)) == null) {
                return;
            }
            Element headerLabelElement = new Element();
            headerLabelElement.setElementType((ElementType)new LabelType());
            if (groupDefinition.getDisplayName() != null) {
                headerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)groupDefinition.getDisplayName());
            } else {
                headerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)groupDefinition.getField());
                headerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", (Object)groupDefinition.getField());
                headerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", (Object)Boolean.TRUE);
            }
            Element headerValueElement = AutoGeneratorUtility.generateDetailsElement((String)groupDefinition.getField(), (ElementType)this.computeElementType(groupDefinition));
            headerValueElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", (Object)"-");
            Band headerElement = new Band();
            headerElement.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"inline");
            headerElement.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(-100.0f));
            headerElement.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, (Object)Boolean.TRUE);
            headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", (Object)Boolean.TRUE);
            headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", (Object)groupDefinition.getField());
            headerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)headerDefinition);
            headerElement.addElement(headerLabelElement);
            headerElement.addElement(headerValueElement);
            content.clear();
            content.addElement((Element)headerElement);
        }
    }

    protected void configureRelationalGroupFooter(RelationalGroup group, GroupDefinition groupDefinition, int index) throws ReportProcessingException {
        Band content;
        RootBandDefinition footerDefinition = groupDefinition.getFooter();
        if (!footerDefinition.isVisible()) {
            return;
        }
        if (groupDefinition.getAggregationFunction() == null && (groupDefinition.getGroupTotalsLabel() == null || groupDefinition.getGroupTotalsLabel().length() == 0)) {
            return;
        }
        GroupFooter footer = group.getFooter();
        Boolean repeat = footerDefinition.getRepeat();
        if (repeat != null) {
            footer.setRepeat(repeat.booleanValue());
        }
        if ((content = AutoGeneratorUtility.findGeneratedContent((Band)footer)) == null) {
            return;
        }
        Class aggFunctionClass = groupDefinition.getAggregationFunction();
        Element footerValueElement = AutoGeneratorUtility.generateFooterElement((Class)aggFunctionClass, (ElementType)this.computeElementType(groupDefinition), (String)groupDefinition.getGroupName(), (String)groupDefinition.getField());
        Element footerLabelElement = new Element();
        footerLabelElement.setElementType((ElementType)new LabelType());
        if (groupDefinition.getGroupTotalsLabel() != null) {
            footerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)groupDefinition.getGroupTotalsLabel());
        } else {
            footerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)groupDefinition.getField());
            footerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", (Object)groupDefinition.getField());
            footerLabelElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes", (Object)Boolean.TRUE);
        }
        Band footerElement = new Band();
        footerElement.getStyle().setStyleProperty(BandStyleKeys.LAYOUT, (Object)"inline");
        footerElement.getStyle().setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)new Float(-100.0f));
        footerElement.getStyle().setStyleProperty(ElementStyleKeys.DYNAMIC_HEIGHT, (Object)Boolean.TRUE);
        footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling", (Object)Boolean.TRUE);
        footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for", (Object)groupDefinition.getField());
        footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)footerDefinition);
        footerElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)groupDefinition);
        footerElement.addElement(footerLabelElement);
        footerElement.addElement(footerValueElement);
        content.clear();
        content.addElement((Element)footerElement);
    }

    private void configureCrosstabGroupFooter(Group group, GroupDefinition groupDefinition) throws ReportProcessingException {
    }

    protected ElementType computeElementType(FieldDefinition fieldDefinition) {
        String field = fieldDefinition.getField();
        DataAttributes attributes = this.flowController.getDataSchema().getAttributes(field);
        if (attributes == null) {
            logger.warn((Object)("Field '" + field + "' is declared in the wizard-specification, " + "but not present in the data. Assuming defaults."));
            return new TextFieldType();
        }
        Class fieldType = (Class)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "value-type", Class.class, (DataAttributeContext)this.attributeContext);
        if (fieldType == null) {
            return new TextFieldType();
        }
        return AutoGeneratorUtility.createFieldType((Class)fieldType);
    }

    private boolean isCrosstab() {
        GroupDefinition[] groupDefinitions = this.wizardSpecification.getGroupDefinitions();
        for (int i = 0; i < groupDefinitions.length; ++i) {
            GroupDefinition groupDefinition = groupDefinitions[i];
            GroupType groupType = groupDefinition.getGroupType();
            if (!GroupType.CT_COLUMN.equals(groupType) && !GroupType.CT_ROW.equals(groupType)) continue;
            return true;
        }
        DataAttributes tableAttributes = this.flowController.getDataSchema().getTableAttributes();
        Object crosstabMode = tableAttributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "crosstab-mode", String.class, (DataAttributeContext)this.attributeContext);
        return "normalized".equals(crosstabMode);
    }

    private void setupWatermark() {
        WatermarkDefinition watermarkDefinition = this.wizardSpecification.getWatermarkDefinition();
        if (!watermarkDefinition.isVisible()) {
            return;
        }
        if (watermarkDefinition.getSource() == null) {
            return;
        }
        Watermark watermark = this.definition.getWatermark();
        Band content = AutoGeneratorUtility.findGeneratedContent((Band)watermark);
        if (content == null) {
            return;
        }
        content.clear();
        Element watermarkImage = new Element();
        watermarkImage.setElementType((ElementType)new ContentType());
        watermarkImage.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Object)watermarkDefinition.getSource());
        ElementStyleSheet watermarkStyle = watermarkImage.getStyle();
        watermarkStyle.setStyleProperty(ElementStyleKeys.POS_X, (Object)this.convertLength(watermarkDefinition.getX()));
        watermarkStyle.setStyleProperty(ElementStyleKeys.POS_Y, (Object)this.convertLength(watermarkDefinition.getY()));
        watermarkStyle.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)this.convertLength(watermarkDefinition.getWidth()));
        watermarkStyle.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)this.convertLength(watermarkDefinition.getHeight()));
        watermarkStyle.setStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO, (Object)watermarkDefinition.getKeepAspectRatio());
        watermarkStyle.setStyleProperty(ElementStyleKeys.SCALE, (Object)watermarkDefinition.getScale());
        content.addElement(watermarkImage);
    }

    private Float convertLength(Length length) {
        if (length == null) {
            return null;
        }
        return length.getNormalizedValue();
    }

    private static class UpdateDetailsTask
    implements UpdateTask {
        private FieldDefinition fieldDefinition;

        private UpdateDetailsTask(FieldDefinition groupDefinition) {
            this.fieldDefinition = groupDefinition;
        }

        @Override
        public void processElement(ReportElement e) {
            Object fieldName;
            String field = this.fieldDefinition.getField();
            Object labelFor = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "label-for");
            if (labelFor != null ? !ObjectUtilities.equal((Object)field, (Object)labelFor) : !ObjectUtilities.equal((Object)field, (Object)(fieldName = e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "field")))) {
                return;
            }
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)this.fieldDefinition);
                if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "preserve-user-styling"))) {
                    ElementStyleSheet styleSheet = e.getStyle();
                    if (styleSheet.isLocalKey(TextStyleKeys.BOLD) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-bold") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-bold", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(TextStyleKeys.ITALIC) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-italics") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-italics", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(TextStyleKeys.UNDERLINED) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-underline") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-underline", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(TextStyleKeys.STRIKETHROUGH) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-strikethrough") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-strikethrough", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(TextStyleKeys.FONT) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontfamily") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontfamily", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(TextStyleKeys.FONTSIZE) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontsize") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-fontsize", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(ElementStyleKeys.PAINT) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-color") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-color", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(ElementStyleKeys.BACKGROUND_COLOR) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-background-color") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-background-color", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(ElementStyleKeys.VALIGNMENT) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-valignment") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-valignment", (Object)Boolean.FALSE);
                    }
                    if (styleSheet.isLocalKey(ElementStyleKeys.ALIGNMENT) && e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-alignment") != null) {
                        e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable-style-alignment", (Object)Boolean.FALSE);
                    }
                }
            }
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)this.fieldDefinition);
            }
        }
    }

    private static class UpdateFooterTask
    implements UpdateTask {
        private GroupDefinition groupDefinition;

        private UpdateFooterTask(GroupDefinition groupDefinition) {
            this.groupDefinition = groupDefinition;
        }

        @Override
        public void processElement(ReportElement e) {
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)this.groupDefinition.getFooter());
            }
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)this.groupDefinition);
            }
        }
    }

    private static class UpdateHeaderTask
    implements UpdateTask {
        private GroupDefinition groupDefinition;

        private UpdateHeaderTask(GroupDefinition groupDefinition) {
            this.groupDefinition = groupDefinition;
        }

        @Override
        public void processElement(ReportElement e) {
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-styling"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFormatData", (Object)this.groupDefinition.getHeader());
            }
            if (Boolean.TRUE.equals(e.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "allow-metadata-attributes"))) {
                e.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "CachedWizardFieldData", (Object)this.groupDefinition);
            }
        }
    }

    protected static interface UpdateTask {
        public void processElement(ReportElement var1);
    }
}

