/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.parser;

import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportParserUtil;
import org.pentaho.reporting.engine.classic.wizard.model.DefaultGroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupDefinition;
import org.pentaho.reporting.engine.classic.wizard.model.GroupType;
import org.pentaho.reporting.engine.classic.wizard.parser.DetailsFieldDefinitionReadHandler;
import org.pentaho.reporting.engine.classic.wizard.parser.RootBandDefinitionReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class GroupDefinitionReadHandler
extends AbstractXmlReadHandler {
    private GroupDefinition groupDefinition = new DefaultGroupDefinition();

    protected void startParsing(Attributes attrs) throws SAXException {
        String thAlightAttr = attrs.getValue(this.getUri(), "totals-align");
        this.groupDefinition.setTotalsHorizontalAlignment(ReportParserUtil.parseHorizontalElementAlignment((String)thAlightAttr, (Locator)this.getLocator()));
        this.groupDefinition.setNullString(attrs.getValue(this.getUri(), "null-string"));
        this.groupDefinition.setDisplayName(attrs.getValue(this.getUri(), "display-name"));
        this.groupDefinition.setField(attrs.getValue(this.getUri(), "field"));
        this.groupDefinition.setDataFormat(attrs.getValue(this.getUri(), "data-format"));
        String aggFunctionName = attrs.getValue(this.getUri(), "aggregation-function");
        if (aggFunctionName != null) {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(DetailsFieldDefinitionReadHandler.class);
            try {
                Class<?> c = Class.forName(aggFunctionName, false, classLoader);
                if (!Expression.class.isAssignableFrom(c)) {
                    throw new ParseException("Failed to parse attribute 'aggregation-function': invalid class name");
                }
                this.groupDefinition.setAggregationFunction(c);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("Failed to parse attribute 'aggregation-function': invalid class name", (Exception)e);
            }
        }
        this.groupDefinition.setGroupName(attrs.getValue(this.getUri(), "group-name"));
        this.groupDefinition.setGroupTotalsLabel(attrs.getValue(this.getUri(), "group-totals-label"));
        this.groupDefinition.setGroupType(this.parseGroupType(attrs.getValue(this.getUri(), "group-type")));
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("footer".equals(tagName) || "group-footer".equals(tagName)) {
            return new RootBandDefinitionReadHandler(this.groupDefinition.getFooter());
        }
        if ("header".equals(tagName) || "group-header".equals(tagName)) {
            return new RootBandDefinitionReadHandler(this.groupDefinition.getHeader());
        }
        return null;
    }

    private GroupType parseGroupType(String s) {
        GroupType[] types = GroupType.values();
        for (int i = 0; i < types.length; ++i) {
            GroupType type = types[i];
            if (!type.getType().equals(s)) continue;
            return type;
        }
        return GroupType.RELATIONAL;
    }

    public Object getObject() throws SAXException {
        return this.groupDefinition;
    }
}

