/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats.mapreduce;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.LoadFunc;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.ScriptState;

public class MRScriptState
extends ScriptState {
    private static final Log LOG = LogFactory.getLog(MRScriptState.class);
    private Map<MapReduceOper, String> featureMap = null;
    private Map<MapReduceOper, String> aliasMap = Maps.newHashMap();
    private Map<MapReduceOper, String> aliasLocationMap = Maps.newHashMap();

    public MRScriptState(String id) {
        super(id);
    }

    public static MRScriptState get() {
        return (MRScriptState)ScriptState.get();
    }

    public void addSettingsToConf(MapReduceOper mro, Configuration conf) {
        ArrayList<String> outputDirs;
        LinkedList<POStore> stores;
        LOG.info((Object)"Pig script settings are added to the job");
        conf.set(ScriptState.PIG_PROPERTY.HADOOP_VERSION.toString(), this.getHadoopVersion());
        conf.set(ScriptState.PIG_PROPERTY.VERSION.toString(), this.getPigVersion());
        conf.set(ScriptState.PIG_PROPERTY.SCRIPT_ID.toString(), this.id);
        conf.set(ScriptState.PIG_PROPERTY.SCRIPT.toString(), this.getScript());
        conf.set(ScriptState.PIG_PROPERTY.COMMAND_LINE.toString(), this.getCommandLine());
        try {
            stores = PlanHelper.getPhysicalOperators(mro.mapPlan, POStore.class);
            outputDirs = new ArrayList<String>();
            for (POStore st : stores) {
                outputDirs.add(st.getSFile().getFileName());
            }
            conf.set(ScriptState.PIG_PROPERTY.MAP_OUTPUT_DIRS.toString(), LoadFunc.join(outputDirs, ","));
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map stores", (Throwable)e);
        }
        if (!mro.reducePlan.isEmpty()) {
            try {
                stores = PlanHelper.getPhysicalOperators(mro.reducePlan, POStore.class);
                outputDirs = new ArrayList();
                for (POStore st : stores) {
                    outputDirs.add(st.getSFile().getFileName());
                }
                conf.set(ScriptState.PIG_PROPERTY.REDUCE_OUTPUT_DIRS.toString(), LoadFunc.join(outputDirs, ","));
            }
            catch (VisitorException e) {
                LOG.warn((Object)"unable to get the reduce stores", (Throwable)e);
            }
        }
        try {
            LinkedList<POLoad> lds = PlanHelper.getPhysicalOperators(mro.mapPlan, POLoad.class);
            ArrayList<String> inputDirs = new ArrayList<String>();
            if (lds != null && lds.size() > 0) {
                for (POLoad ld : lds) {
                    inputDirs.add(ld.getLFile().getFileName());
                }
                conf.set(ScriptState.PIG_PROPERTY.INPUT_DIRS.toString(), LoadFunc.join(inputDirs, ","));
            }
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get the map loads", (Throwable)e);
        }
        this.setPigFeature(mro, conf);
        this.setJobParents(mro, conf);
        conf.set("mapreduce.workflow.id", "pig_" + this.id);
        conf.set("mapreduce.workflow.name", this.getFileName().isEmpty() ? "default" : this.getFileName());
        conf.set("mapreduce.workflow.node.name", mro.getOperatorKey().toString());
    }

    public void addWorkflowAdjacenciesToConf(MROperPlan mrop, Configuration conf) {
        for (MapReduceOper source : mrop) {
            ArrayList<String> targets = new ArrayList<String>();
            if (mrop.getSuccessors(source) != null) {
                for (MapReduceOper target : mrop.getSuccessors(source)) {
                    targets.add(target.getOperatorKey().toString());
                }
            }
            String[] s = new String[targets.size()];
            conf.setStrings("mapreduce.workflow.adjacency." + source.getOperatorKey().toString(), targets.toArray(s));
        }
    }

    private void setPigFeature(MapReduceOper mro, Configuration conf) {
        conf.set(ScriptState.PIG_PROPERTY.JOB_FEATURE.toString(), this.getPigFeature(mro));
        if (this.scriptFeatures != 0L) {
            conf.set(ScriptState.PIG_PROPERTY.SCRIPT_FEATURES.toString(), String.valueOf(this.scriptFeatures));
        }
        conf.set(ScriptState.PIG_PROPERTY.JOB_ALIAS.toString(), this.getAlias(mro));
        conf.set(ScriptState.PIG_PROPERTY.JOB_ALIAS_LOCATION.toString(), this.getAliasLocation(mro));
    }

    private void setJobParents(MapReduceOper mro, Configuration conf) {
        List<Operator> preds;
        PigStats.JobGraph jg = PigStats.get().getJobGraph();
        JobStats js = null;
        for (JobStats job : jg) {
            if (!job.getName().equals(mro.getOperatorKey().toString())) continue;
            js = job;
            break;
        }
        if (js != null && (preds = jg.getPredecessors(js)) != null) {
            StringBuilder sb = new StringBuilder();
            for (Operator op : preds) {
                JobStats job = (JobStats)op;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(job.getJobId());
            }
            conf.set(ScriptState.PIG_PROPERTY.JOB_PARENTS.toString(), sb.toString());
        }
    }

    public String getAlias(MapReduceOper mro) {
        if (!this.aliasMap.containsKey(mro)) {
            this.setAlias(mro);
        }
        return this.aliasMap.get(mro);
    }

    private void setAlias(MapReduceOper mro) {
        ArrayList<String> alias = new ArrayList<String>();
        String aliasLocationStr = "";
        try {
            ArrayList<String> aliasLocation = new ArrayList<String>();
            new ScriptState.AliasVisitor(mro.mapPlan, alias, aliasLocation).visit();
            aliasLocationStr = aliasLocationStr + "M: " + LoadFunc.join(aliasLocation, ",");
            if (mro.combinePlan != null) {
                aliasLocation = new ArrayList();
                new ScriptState.AliasVisitor(mro.combinePlan, alias, aliasLocation).visit();
                aliasLocationStr = aliasLocationStr + " C: " + LoadFunc.join(aliasLocation, ",");
            }
            aliasLocation = new ArrayList();
            new ScriptState.AliasVisitor(mro.reducePlan, alias, aliasLocation).visit();
            aliasLocationStr = aliasLocationStr + " R: " + LoadFunc.join(aliasLocation, ",");
            if (!alias.isEmpty()) {
                Collections.sort(alias);
            }
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to get alias", (Throwable)e);
        }
        this.aliasMap.put(mro, LoadFunc.join(alias, ","));
        this.aliasLocationMap.put(mro, aliasLocationStr);
    }

    public String getAliasLocation(MapReduceOper mro) {
        if (!this.aliasLocationMap.containsKey(mro)) {
            this.setAlias(mro);
        }
        return this.aliasLocationMap.get(mro);
    }

    public String getPigFeature(MapReduceOper mro) {
        String retStr;
        if (this.featureMap == null) {
            this.featureMap = new HashMap<MapReduceOper, String>();
        }
        if ((retStr = this.featureMap.get(mro)) == null) {
            BitSet feature = new BitSet();
            feature.clear();
            if (mro.isSkewedJoin()) {
                feature.set(ScriptState.PIG_FEATURE.SKEWED_JOIN.ordinal());
            }
            if (mro.isGlobalSort()) {
                feature.set(ScriptState.PIG_FEATURE.ORDER_BY.ordinal());
            }
            if (mro.isSampler()) {
                feature.set(ScriptState.PIG_FEATURE.SAMPLER.ordinal());
            }
            if (mro.isIndexer()) {
                feature.set(ScriptState.PIG_FEATURE.INDEXER.ordinal());
            }
            if (mro.isCogroup()) {
                feature.set(ScriptState.PIG_FEATURE.COGROUP.ordinal());
            }
            if (mro.isGroupBy()) {
                feature.set(ScriptState.PIG_FEATURE.GROUP_BY.ordinal());
            }
            if (mro.isRegularJoin()) {
                feature.set(ScriptState.PIG_FEATURE.HASH_JOIN.ordinal());
            }
            if (mro.needsDistinctCombiner()) {
                feature.set(ScriptState.PIG_FEATURE.DISTINCT.ordinal());
            }
            if (!mro.combinePlan.isEmpty()) {
                feature.set(ScriptState.PIG_FEATURE.COMBINER.ordinal());
            }
            if (mro instanceof NativeMapReduceOper) {
                feature.set(ScriptState.PIG_FEATURE.NATIVE.ordinal());
            } else {
                try {
                    new ScriptState.FeatureVisitor(mro.mapPlan, feature).visit();
                    if (mro.reducePlan.isEmpty()) {
                        feature.set(ScriptState.PIG_FEATURE.MAP_ONLY.ordinal());
                    } else {
                        new ScriptState.FeatureVisitor(mro.reducePlan, feature).visit();
                    }
                }
                catch (VisitorException e) {
                    LOG.warn((Object)"Feature visitor failed", (Throwable)e);
                }
            }
            StringBuilder sb = new StringBuilder();
            int i = feature.nextSetBit(0);
            while (i >= 0) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(ScriptState.PIG_FEATURE.values()[i].name());
                i = feature.nextSetBit(i + 1);
            }
            retStr = sb.toString();
            this.featureMap.put(mro, retStr);
        }
        return retStr;
    }
}

