/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.accumulo;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.SqoopOptions;

public final class AccumuloUtil {
    private static final Log LOG = LogFactory.getLog(AccumuloUtil.class);
    private static boolean testingMode = false;
    private static final String INSTANCE_CLASS = "org.apache.accumulo.core.client.Instance";

    private AccumuloUtil() {
    }

    public static void setAlwaysNoAccumuloJarMode(boolean mode) {
        testingMode = mode;
    }

    public static boolean isAccumuloJarPresent() {
        if (testingMode) {
            return false;
        }
        try {
            Class.forName(INSTANCE_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
        return true;
    }

    public static void addJars(Job job, SqoopOptions options) throws IOException {
        if (AccumuloUtil.isLocalJobTracker(job)) {
            LOG.info((Object)"Not adding Accumulo jars to distributed cache in local mode");
        } else if (options.isSkipDistCache()) {
            LOG.info((Object)"Not adding Accumulo jars to distributed cache as requested");
        } else {
            Configuration conf = job.getConfiguration();
            String accumuloHome = null;
            String zookeeperHome = null;
            LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
            if (options != null) {
                accumuloHome = options.getAccumuloHome();
            }
            if (accumuloHome == null) {
                accumuloHome = SqoopOptions.getAccumuloHomeDefault();
            }
            LOG.info((Object)("Accumulo job : Accumulo Home = " + accumuloHome));
            if (options != null) {
                zookeeperHome = options.getZookeeperHome();
            }
            if (zookeeperHome == null) {
                zookeeperHome = SqoopOptions.getZookeeperHomeDefault();
            }
            LOG.info((Object)("Accumulo job : Zookeeper Home = " + zookeeperHome));
            conf.addResource(accumuloHome + "/conf/accumulo-site.xml");
            HashSet<String> localUrls = new HashSet<String>();
            localUrls.addAll(conf.getStringCollection("tmpjars"));
            String dir = accumuloHome + File.separator + "lib";
            LOG.info((Object)("Adding jar files under " + dir + " to distributed cache"));
            AccumuloUtil.addDirToCache(new File(dir), (FileSystem)fs, localUrls, false);
            dir = zookeeperHome;
            LOG.info((Object)("Adding jar files under " + dir + " to distributed cache"));
            AccumuloUtil.addDirToCache(new File(dir), (FileSystem)fs, localUrls, false);
            String tmpjars = conf.get("tmpjars");
            StringBuilder sb = new StringBuilder(1024);
            if (null != tmpjars) {
                sb.append(tmpjars);
                sb.append(",");
            }
            sb.append(StringUtils.arrayToString((String[])localUrls.toArray(new String[0])));
            conf.set("tmpjars", sb.toString());
        }
    }

    private static void addDirToCache(File dir, FileSystem fs, Set<String> localUrls, boolean recursive) {
        if (dir != null) {
            File[] fileList = dir.listFiles();
            if (fileList != null) {
                for (File libFile : dir.listFiles()) {
                    if (libFile.exists() && !libFile.isDirectory() && libFile.getName().endsWith("jar")) {
                        Path p = new Path(libFile.toString());
                        if (libFile.canRead()) {
                            String qualified = p.makeQualified(fs).toString();
                            LOG.info((Object)("Adding to job classpath: " + qualified));
                            localUrls.add(qualified);
                        } else {
                            LOG.warn((Object)("Ignoring unreadable file " + libFile));
                        }
                    }
                    if (!recursive || !libFile.isDirectory()) continue;
                    AccumuloUtil.addDirToCache(libFile, fs, localUrls, recursive);
                }
            } else {
                LOG.warn((Object)("No files under " + dir + " to add to distributed cache for Accumulo job"));
            }
        }
    }

    public static boolean isLocalJobTracker(Job job) {
        boolean retval = false;
        Configuration conf = job.getConfiguration();
        if ("yarn".equalsIgnoreCase(conf.get("mapreduce.framework.name"))) {
            retval = false;
        } else {
            String jtAddr = conf.get("mapred.job.tracker");
            String jtAddr2 = conf.get("mapreduce.jobtracker.address");
            retval = jtAddr != null && jtAddr.equals("local") || jtAddr2 != null && jtAddr2.equals("local");
        }
        return retval;
    }
}

