/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayCombinerStream
extends InputStream {
    private final ArrayList<byte[]> arrays;
    private final long specifiedLength;
    private long gOffset = 0L;
    private int arrayIndex = 0;
    private byte[] curArray;
    private int off = 0;

    public ByteArrayCombinerStream(ArrayList<byte[]> arrayList, long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Length cannot be negative: " + l);
        }
        this.specifiedLength = l;
        long l2 = l;
        if (arrayList != null && arrayList.size() > 0) {
            byte[] byArray;
            int n = arrayList.size();
            this.arrays = new ArrayList(n);
            for (int i = 0; i < n && l2 > 0L; l2 -= (long)byArray.length, ++i) {
                byArray = arrayList.get(i);
                if (l2 < (long)byArray.length) {
                    byte[] byArray2 = new byte[(int)l2];
                    System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                    this.arrays.add(byArray2);
                    l2 -= (long)byArray2.length;
                    break;
                }
                this.arrays.add(byArray);
            }
            this.curArray = this.nextArray();
        } else {
            this.gOffset = l;
            this.arrays = null;
        }
        if (l2 > 0L) {
            throw new IllegalArgumentException("Not enough data, " + l2 + " bytes short of specified length " + l);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curArray == null) {
            return -1;
        }
        if (this.off >= this.curArray.length) {
            this.curArray = this.nextArray();
            if (this.curArray == null) {
                return -1;
            }
        }
        ++this.gOffset;
        return this.curArray[this.off++];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.curArray == null) {
            return -1;
        }
        if (n2 <= this.curArray.length - this.off) {
            System.arraycopy(this.curArray, this.off, byArray, n, n2);
            this.off += n2;
            this.gOffset += (long)n2;
            n3 = n2;
        } else {
            int n4 = 0;
            while (this.curArray != null && n3 < n2) {
                n4 = Math.min(this.curArray.length - this.off, n2 - n3);
                System.arraycopy(this.curArray, this.off, byArray, n + n3, n4);
                n3 += n4;
                this.gOffset += (long)n4;
                this.off += n4;
                if (this.off < this.curArray.length) break;
                this.curArray = this.nextArray();
            }
        }
        return n3;
    }

    @Override
    public int available() {
        return (int)(this.specifiedLength - this.gOffset);
    }

    private byte[] nextArray() {
        if (this.arrayIndex >= this.arrays.size()) {
            return null;
        }
        byte[] byArray = this.arrays.get(this.arrayIndex);
        this.arrays.set(this.arrayIndex++, null);
        this.off = 0;
        return byArray;
    }
}

