/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.IMetaStoreAttribute;
import org.pentaho.metastore.api.IMetaStoreElement;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class MetaStoreUtil {
    public static void verifyNamespaceCreated(IMetaStore metaStore, String namespace) throws MetaStoreException {
        if (!metaStore.namespaceExists(namespace)) {
            metaStore.createNamespace(namespace);
        }
    }

    public static String getChildString(IMetaStoreAttribute attribute, String id) {
        IMetaStoreAttribute child = attribute.getChild(id);
        if (child == null) {
            return null;
        }
        return MetaStoreUtil.getAttributeString(child);
    }

    public static String getAttributeString(IMetaStoreAttribute attribute) {
        if (attribute.getValue() == null) {
            return null;
        }
        return attribute.getValue().toString();
    }

    public static boolean getAttributeBoolean(IMetaStoreAttribute attribute, String id) {
        String b = MetaStoreUtil.getChildString(attribute, id);
        if (b == null) {
            return false;
        }
        return "true".equalsIgnoreCase(b) || "y".equalsIgnoreCase(b);
    }

    public static <T> T executeLockedOperation(Lock lock, Callable<T> callee) throws MetaStoreException {
        lock.lock();
        try {
            if (callee != null) {
                T t = callee.call();
                return t;
            }
        }
        catch (Exception e) {
            if (e instanceof MetaStoreException) {
                throw (MetaStoreException)e;
            }
            throw new MetaStoreException(e);
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public static <T> T executeLockedOperationQuietly(Lock lock, Callable<T> callee) {
        T result = null;
        try {
            result = MetaStoreUtil.executeLockedOperation(lock, callee);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String[] getElementNames(String namespace, IMetaStore metaStore, IMetaStoreElementType elementType) throws MetaStoreException {
        ArrayList<String> names = new ArrayList<String>();
        List<IMetaStoreElement> elements = metaStore.getElements(namespace, elementType);
        for (IMetaStoreElement element : elements) {
            names.add(element.getName());
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }
}

