/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.web.http.api.resources.DirectoryResource;
import org.pentaho.platform.web.http.api.resources.FileResource;
import org.pentaho.platform.web.http.api.resources.RepositoryImportResource;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.pensol.SolutionFileModel;

public class JCRSolutionDirectFileModel
implements SolutionFileModel {
    private static final Log logger = LogFactory.getLog(JCRSolutionDirectFileModel.class);
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String DO_GET_ROOT_CHILDREN = "doGetRootChildren";
    private static final String DO_GET_FILE_OR_DIR_AS_DOWNLOAD = "doGetFileOrDirAsDownload";
    private static final String FAILED_TO_ACCESS_REPOSITORY = "Failed to access repository";
    private static final String FILE_NOT_FOUND = "File does not exist: {0}";
    private static final String FAILED_TO_WRITE_FILE = "Failed to write file: {0}";
    private static final String NULL_OBJECT = "Repository returned <null> for file: {0}";
    private static final String NULL_MODIFIED_DATE = "Repository returned <null> for last-modified-date on file: ";
    private static final String INVALID_USERNAME_OR_PASSWORD = "Invalid username or password";
    private static final String BAD_RESPONSE = "Failed with error-code: {0}";
    private static final String NOT_SUPPORTED = "Operation not supported: {0}";
    private RepositoryFileTreeDto root;
    private FileResource fileRes = new FileResource();
    private DirectoryResource dirRes = new DirectoryResource();
    private RepositoryImportResource importRes = new RepositoryImportResource();
    private Method doGetRootChildrenMethod;
    private Method doGetFileOrDirAsDownloadMethod;

    public JCRSolutionDirectFileModel() {
        try {
            this.doGetRootChildrenMethod = this.fileRes.getClass().getDeclaredMethod(DO_GET_ROOT_CHILDREN, Integer.class, String.class, Boolean.class);
        }
        catch (NoSuchMethodException e) {
            this.doGetRootChildrenMethod = null;
        }
        try {
            this.doGetFileOrDirAsDownloadMethod = this.fileRes.getClass().getDeclaredMethod(DO_GET_FILE_OR_DIR_AS_DOWNLOAD, String.class, String.class);
        }
        catch (NoSuchMethodException e) {
            this.doGetFileOrDirAsDownloadMethod = null;
        }
    }

    private RepositoryFileTreeDto getFileTree() throws FileSystemException {
        int depth = -1;
        String filter = "*";
        boolean showHidden = true;
        RepositoryFileTreeDto fileTree = null;
        if (this.doGetRootChildrenMethod == null) {
            fileTree = this.fileRes.doGetRootTree(Integer.valueOf(-1), "*", Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            try {
                fileTree = (RepositoryFileTreeDto)this.doGetRootChildrenMethod.invoke((Object)this.fileRes, -1, "*", true);
            }
            catch (InvocationTargetException e) {
                throw new FileSystemException(FAILED_TO_ACCESS_REPOSITORY);
            }
            catch (IllegalAccessException e) {
                throw new FileSystemException(FAILED_TO_ACCESS_REPOSITORY);
            }
        }
        return fileTree;
    }

    private RepositoryFileTreeDto getTreeNode(FileName fullName) throws FileSystemException {
        if (this.root == null) {
            this.refresh();
        }
        return this.searchTreeNode(this.stackName(fullName), this.root);
    }

    private RepositoryFileTreeDto searchTreeNode(FastStack<String> fullName, RepositoryFileTreeDto treeNode) {
        if (fullName.size() == 0) {
            return treeNode;
        }
        String fileOrDirName = (String)fullName.peek();
        List children = treeNode.getChildren();
        for (RepositoryFileTreeDto child : children) {
            String childName = child.getFile().getName();
            if (!fileOrDirName.equals(childName)) continue;
            fullName.pop();
            return this.searchTreeNode(fullName, child);
        }
        return null;
    }

    private FastStack<String> stackName(FileName fullName) {
        FastStack stack = new FastStack();
        while (fullName != null) {
            String name = fullName.getBaseName().trim();
            if (!name.equals("")) {
                stack.push((Object)name);
            }
            fullName = fullName.getParent();
        }
        return stack;
    }

    private RepositoryFileDto getFile(FileName fullName) throws FileSystemException {
        RepositoryFileTreeDto tree = this.getTreeNode(fullName);
        if (tree == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)fullName);
        }
        return tree.getFile();
    }

    private List<RepositoryFileTreeDto> getChildNodes(FileName fullName) throws FileSystemException {
        RepositoryFileTreeDto tree = this.getTreeNode(fullName);
        if (tree == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)fullName);
        }
        List children = tree.getChildren();
        return children == null ? Collections.emptyList() : children;
    }

    private String pathToId(String path) {
        return path.replace(SLASH, COLON);
    }

    private void throwExceptionOnBadResponse(Response response) throws FileSystemException {
        int status = response.getStatus();
        switch (status) {
            case 200: {
                logger.debug((Object)"OK");
                break;
            }
            case 302: 
            case 401: 
            case 403: {
                logger.debug((Object)"FORBIDDEN");
                throw new FileSystemException(INVALID_USERNAME_OR_PASSWORD);
            }
            default: {
                logger.debug((Object)("ERROR " + status));
                throw new FileSystemException(BAD_RESPONSE, (Object)status);
            }
        }
    }

    @Override
    public void refresh() throws FileSystemException {
        logger.debug((Object)"refresh");
        this.root = this.getFileTree();
    }

    @Override
    public String[] getChilds(FileName fullName) throws FileSystemException {
        logger.debug((Object)("getChilds: " + fullName));
        List<RepositoryFileTreeDto> children = this.getChildNodes(fullName);
        logger.debug((Object)("size = " + children.size()));
        String[] childrenArray = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            RepositoryFileTreeDto treeNode = children.get(i);
            if (treeNode == null) continue;
            RepositoryFileDto file = treeNode.getFile();
            if (file != null) {
                logger.debug((Object)("file " + file.getName()));
                childrenArray[i] = file.getName();
                continue;
            }
            throw new FileSystemException(NULL_OBJECT);
        }
        return childrenArray;
    }

    @Override
    public boolean exists(FileName fullName) throws FileSystemException {
        return this.getTreeNode(fullName) != null;
    }

    @Override
    public boolean isVisible(FileName fullName) throws FileSystemException {
        return !this.getFile(fullName).isHidden();
    }

    @Override
    public boolean isDirectory(FileName fullName) throws FileSystemException {
        return this.getFile(fullName).isFolder();
    }

    @Override
    public long getLastModifiedDate(FileName fullName) throws FileSystemException {
        Date lastModifiedDate = this.getFile(fullName).getLastModifiedDate();
        if (lastModifiedDate == null) {
            logger.error((Object)(NULL_MODIFIED_DATE + fullName));
            return -1L;
        }
        return lastModifiedDate.getTime();
    }

    @Override
    public String getLocalizedName(FileName fullName) throws FileSystemException {
        return this.getFile(fullName).getTitle();
    }

    @Override
    public void setDescription(FileName fullName, String description) throws FileSystemException {
        this.getFile(fullName).setDescription(description);
    }

    @Override
    public String getDescription(FileName fullName) throws FileSystemException {
        return this.getFile(fullName).getDescription();
    }

    @Override
    public long getContentSize(FileName fullName) throws FileSystemException {
        return this.getFile(fullName).getFileSize();
    }

    @Override
    public byte[] getData(FileName fullName) throws FileSystemException {
        logger.debug((Object)("getData: " + fullName));
        try {
            String fileId = this.pathToId(fullName.getPath());
            Response response = null;
            if (this.doGetFileOrDirAsDownloadMethod == null) {
                response = this.fileRes.doGetFileOrDirAsDownload(null, fileId, "false");
            } else {
                try {
                    response = (Response)this.doGetFileOrDirAsDownloadMethod.invoke((Object)this.fileRes, fileId, "false");
                }
                catch (InvocationTargetException e) {
                    throw new FileSystemException(FAILED_TO_ACCESS_REPOSITORY);
                }
                catch (IllegalAccessException e) {
                    throw new FileSystemException(FAILED_TO_ACCESS_REPOSITORY);
                }
            }
            this.throwExceptionOnBadResponse(response);
            StreamingOutput output = (StreamingOutput)response.getEntity();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            output.write((OutputStream)stream);
            return stream.toByteArray();
        }
        catch (FileNotFoundException e) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)fullName);
        }
        catch (IOException e) {
            throw new FileSystemException(FAILED_TO_WRITE_FILE, (Object)fullName);
        }
    }

    @Override
    public void setData(FileName fullName, byte[] data) throws FileSystemException {
        logger.debug((Object)("setData: " + fullName));
        String name = fullName.getBaseName();
        String parent = fullName.getParent().getPath();
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        FormDataContentDisposition fd = ((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)name).fileName(name)).build();
        Response response = this.importRes.doPostImport(parent, (InputStream)stream, "true", null, "true", "true", null, "WARN", fd, null);
        this.throwExceptionOnBadResponse(response);
    }

    @Override
    public void createFolder(FileName fullName) throws FileSystemException {
        logger.debug((Object)("createFolder: " + fullName));
        Response response = this.dirRes.createDirs(this.pathToId(fullName.getPath()));
        this.throwExceptionOnBadResponse(response);
        this.refresh();
    }

    @Override
    public boolean delete(FileName fullName) throws FileSystemException {
        logger.debug((Object)("delete: " + fullName));
        Response response = this.fileRes.doDeleteFiles(this.getFile(fullName).getId());
        this.throwExceptionOnBadResponse(response);
        this.refresh();
        return true;
    }

    @Override
    public String getParamServiceUrl(FileName fullName) throws FileSystemException {
        throw new FileSystemException(NOT_SUPPORTED, (Object)"getParamServiceUrl");
    }

    @Override
    public String getUrl(FileName fullName) throws FileSystemException {
        throw new FileSystemException(NOT_SUPPORTED, (Object)"getUrl");
    }
}

