/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileDto;
import org.pentaho.platform.repository2.unified.webservices.RepositoryFileTreeDto;
import org.pentaho.platform.util.RepositoryPathEncoder;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.base.util.URLEncoder;
import org.pentaho.reporting.libraries.pensol.CookiesHandlerFilter;
import org.pentaho.reporting.libraries.pensol.LibPensolBoot;
import org.pentaho.reporting.libraries.pensol.SolutionFileModel;

public class JCRSolutionFileModel
implements SolutionFileModel {
    private static final Log logger = LogFactory.getLog(JCRSolutionFileModel.class);
    private static final String LOAD_REPOSITORY_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.LoadRepositoryDoc");
    private static final String CREATE_FOLDER_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.CreateNewFolder");
    private static final String DOWNLOAD_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.DownloadService");
    private static final String UPLOAD_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.UploadService");
    public static final String RETRIEVE_CONTENT_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.RetrieveContent");
    public static final String RETRIEVE_PARAMETER_URL_SERVICE = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.RetrieveParameters");
    public static final String DELETE_FILE_OR_FOLDER = LibPensolBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.pensol.jcr.delete.file.or.folder");
    private static final String BI_SERVER_NULL_OBJECT = "BI-Server returned a RepositoryFileTreeDto without an attached RepositoryFileDto. Please file a bug report at http://jira.pentaho.org/browse/BISERVER !";
    private static final String FILE_NOT_FOUND = "The specified file name does not exist: {0}";
    private static final String SLASH = "/";
    private Client client;
    private String url;
    private RepositoryFileTreeDto root;
    private HashMap<FileName, String> descriptionEntries;
    private long refreshTime;
    private String majorVersion;
    private String minorVersion;
    private String releaseVersion;
    private String buildVersion;
    private String milestoneVersion;

    public JCRSolutionFileModel(String url, String username, String password, int timeout) {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.descriptionEntries = new HashMap();
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
        config.getProperties().put("com.sun.jersey.client.property.readTimeout", timeout);
        this.client = Client.create((ClientConfig)config);
        this.client.addFilter((ClientFilter)new CookiesHandlerFilter());
        this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        this.majorVersion = "999";
        this.minorVersion = "999";
        this.releaseVersion = "999";
        this.buildVersion = "999";
        this.milestoneVersion = "999";
    }

    @Override
    public void refresh() throws IOException {
        WebResource resource = this.client.resource(this.url + LOAD_REPOSITORY_SERVICE);
        RepositoryFileTreeDto tree = (RepositoryFileTreeDto)resource.path("").accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(RepositoryFileTreeDto.class);
        this.setRoot(tree);
    }

    @Override
    public void createFolder(FileName file) throws FileSystemException {
        try {
            String path = URLEncoder.encodeUTF8((String)URLDecoder.decode(JCRSolutionFileModel.normalizePath(file.getPath().replaceAll("\\+", "%2B")), "UTF-8")).replaceAll("\\!", "%21");
            String service = MessageFormat.format(CREATE_FOLDER_SERVICE, path);
            WebResource resource = this.client.resource(this.url + service);
            ClientResponse response = (ClientResponse)resource.type("text/plain").put(ClientResponse.class, null);
            if (response.getStatus() != 200) {
                throw new FileSystemException("Failed with error-code", (Object)response.getStatus());
            }
            this.refresh();
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException("Failed", (Throwable)e);
        }
    }

    private static String normalizePath(String path) {
        return RepositoryPathEncoder.encodeRepositoryPath((String)path);
    }

    public RepositoryFileTreeDto getRoot() throws IOException {
        if (this.root == null && this.refreshTime == 0L) {
            this.refresh();
        }
        return this.root;
    }

    public void setRoot(RepositoryFileTreeDto root) {
        if (root == null) {
            throw new NullPointerException();
        }
        this.descriptionEntries.clear();
        this.root = root;
        this.refreshTime = System.currentTimeMillis();
    }

    @Override
    public boolean isDirectory(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return fileDto.isFolder();
    }

    @Override
    public boolean exists(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        return fileInfo != null;
    }

    @Override
    public boolean isVisible(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return !fileDto.isHidden();
    }

    @Override
    public void setDescription(FileName file, String description) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        fileDto.setDescription(description);
    }

    @Override
    public String getDescription(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return fileDto.getDescription();
    }

    @Override
    public long getLastModifiedDate(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        Date lastModifiedDate = fileDto.getLastModifiedDate();
        if (lastModifiedDate == null) {
            logger.error((Object)("Repository returned <null> for last-modified-date on file: " + file));
            return -1L;
        }
        return lastModifiedDate.getTime();
    }

    private String getFormattedServiceUrl(String urlService, FileName file) throws FileSystemException {
        if (urlService == null) {
            throw new NullPointerException();
        }
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        String restName = JCRSolutionFileModel.normalizePath(file.getPath());
        return MessageFormat.format(urlService, URLEncoder.encodeUTF8((String)restName).replaceAll("\\!", "%21").replaceAll("\\+", "%2B"));
    }

    @Override
    public String getUrl(FileName file) throws FileSystemException {
        return this.getFormattedServiceUrl(RETRIEVE_CONTENT_SERVICE, file);
    }

    public List<RepositoryFileTreeDto> getChildren(FileName parent) throws FileSystemException {
        String[] pathArray = this.computeFileNames(parent);
        RepositoryFileTreeDto fileInfo = this.lookupNode(pathArray);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)parent);
        }
        List childNodes = fileInfo.getChildren();
        return childNodes == null ? Collections.emptyList() : childNodes;
    }

    protected RepositoryFileTreeDto lookupNode(String[] path) throws FileSystemException {
        if (this.root == null) {
            try {
                this.refresh();
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        if (path.length == 0) {
            return this.root;
        }
        if ("".equals(path[0]) && path.length == 1) {
            return this.root;
        }
        RepositoryFileTreeDto element = this.root;
        for (String pathSegment : path) {
            RepositoryFileTreeDto name = null;
            List children = element.getChildren();
            if (children == null) {
                return null;
            }
            for (RepositoryFileTreeDto child : children) {
                RepositoryFileDto file = child.getFile();
                if (file == null) {
                    throw new FileSystemException(BI_SERVER_NULL_OBJECT);
                }
                if (!pathSegment.equals(file.getName())) continue;
                name = child;
                break;
            }
            if (name == null) {
                return null;
            }
            element = name;
        }
        return element;
    }

    protected String[] computeFileNames(FileName file) {
        FastStack stack = new FastStack();
        while (file != null) {
            String name;
            try {
                name = URLDecoder.decode(file.getBaseName().trim().replaceAll("\\+", "%2B"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                name = file.getBaseName().trim();
            }
            if (!"".equals(name)) {
                stack.push((Object)name);
            }
            file = file.getParent();
        }
        int size = stack.size();
        String[] result = new String[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)stack.pop();
        }
        return result;
    }

    @Override
    public byte[] getData(FileName file) throws FileSystemException {
        String path;
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new IllegalStateException(BI_SERVER_NULL_OBJECT);
        }
        String urlPath = path = JCRSolutionFileModel.normalizePath(fileDto.getPath());
        try {
            urlPath = URLEncoder.encodeUTF8((String)path).replaceAll("\\!", "%21").replaceAll("\\+", "%2B");
        }
        catch (Exception ex) {
            // empty catch block
        }
        String service = MessageFormat.format(DOWNLOAD_SERVICE, urlPath);
        return (byte[])this.client.resource(this.url + service).accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE}).get(byte[].class);
    }

    @Override
    public void setData(FileName file, byte[] data) throws FileSystemException {
        ByteArrayInputStream stream;
        String[] fileName = this.computeFileNames(file);
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < fileName.length; ++i) {
            if (i != 0) {
                b.append(SLASH);
            }
            b.append(fileName[i]);
        }
        String service = MessageFormat.format(UPLOAD_SERVICE, URLEncoder.encodeUTF8((String)JCRSolutionFileModel.normalizePath(b.toString()).replaceAll("\\!", "%21").replaceAll("\\+", "%2B")));
        WebResource resource = this.client.resource(this.url + service);
        ClientResponse response = (ClientResponse)resource.put(ClientResponse.class, (Object)(stream = new ByteArrayInputStream(data)));
        int status = response.getStatus();
        if (status != 200) {
            if (status == 302 || status == 403 || status == 401) {
                throw new FileSystemException("ERROR_INVALID_USERNAME_OR_PASSWORD");
            }
            throw new FileSystemException("ERROR_FAILED", (Object)status);
        }
        try {
            this.refresh();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public String[] getChilds(FileName name) throws FileSystemException {
        List<RepositoryFileTreeDto> children = this.getChildren(name);
        String[] childrenArray = new String[children.size()];
        for (int i = 0; i < children.size(); ++i) {
            RepositoryFileTreeDto repositoryFileTreeDto = children.get(i);
            if (repositoryFileTreeDto == null) continue;
            RepositoryFileDto file = repositoryFileTreeDto.getFile();
            if (file == null) {
                throw new FileSystemException(BI_SERVER_NULL_OBJECT);
            }
            childrenArray[i] = file.getName().replaceAll("\\%", "%25").replaceAll("\\!", "%21").replaceAll("\\+", "%2B");
        }
        return childrenArray;
    }

    @Override
    public String getLocalizedName(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        RepositoryFileTreeDto fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)file);
        }
        RepositoryFileDto fileDto = fileInfo.getFile();
        if (fileDto == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return fileDto.getTitle();
    }

    @Override
    public String getParamServiceUrl(FileName name) throws FileSystemException {
        return this.url + this.getFormattedServiceUrl(RETRIEVE_PARAMETER_URL_SERVICE, name);
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public HashMap<FileName, String> getDescriptionEntries() {
        return this.descriptionEntries;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getMilestoneVersion() {
        return this.milestoneVersion;
    }

    @Override
    public long getContentSize(FileName name) throws FileSystemException {
        String[] pathArray = this.computeFileNames(name);
        RepositoryFileTreeDto fileInfo = this.lookupNode(pathArray);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)name);
        }
        RepositoryFileDto file = fileInfo.getFile();
        if (file == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return file.getFileSize();
    }

    @Override
    public boolean delete(FileName name) throws FileSystemException {
        boolean success = false;
        RepositoryFileDto file = this.getFile(name);
        try {
            WebResource resource = this.client.resource(this.url + DELETE_FILE_OR_FOLDER);
            ClientResponse response = (ClientResponse)resource.put(ClientResponse.class, (Object)file.getId());
            if (response == null || response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new FileSystemException("Failed with error-code " + response.getStatus());
            }
            this.refresh();
            success = true;
        }
        catch (Exception e) {
            throw new FileSystemException("Failed", (Throwable)e);
        }
        return success;
    }

    private RepositoryFileDto getFile(FileName name) throws FileSystemException {
        if (name == null) {
            throw new FileSystemException(FILE_NOT_FOUND);
        }
        String[] pathArray = this.computeFileNames(name);
        RepositoryFileTreeDto fileInfo = this.lookupNode(pathArray);
        if (fileInfo == null) {
            throw new FileSystemException(FILE_NOT_FOUND, (Object)name);
        }
        RepositoryFileDto file = fileInfo.getFile();
        if (file == null) {
            throw new FileSystemException(BI_SERVER_NULL_OBJECT);
        }
        return file;
    }
}

