/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.pentaho.reporting.libraries.pensol.SolutionFileModel;
import org.pentaho.reporting.libraries.pensol.SolutionFileOutputStream;

public class WebSolutionFileObject
extends AbstractFileObject {
    private SolutionFileModel fs;

    public WebSolutionFileObject(FileName name, AbstractFileSystem fileSystem, SolutionFileModel fs) {
        super(name, fileSystem);
        this.fs = fs;
    }

    protected void doAttach() throws Exception {
        super.doAttach();
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return this.getName().getDepth() >= 2;
    }

    protected FileType doGetType() throws Exception {
        if (this.getName().getDepth() < 2) {
            return FileType.FOLDER;
        }
        if (!this.fs.exists(this.getName())) {
            return FileType.IMAGINARY;
        }
        if (this.fs.isDirectory(this.getName())) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return this.fs.getChilds(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.fs.getContentSize(this.getName());
    }

    protected boolean doIsHidden() throws Exception {
        return !this.fs.isVisible(this.getName());
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.fs.getLastModifiedDate(this.getName());
    }

    protected Map doGetAttributes() throws Exception {
        String description = this.fs.getDescription(this.getName());
        String localizedName = this.fs.getLocalizedName(this.getName());
        String paramServiceUrl = this.fs.getParamServiceUrl(this.getName());
        String url = this.fs.getUrl(this.getName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("description", description);
        map.put("localized-name", localizedName);
        map.put("param-service-url", paramServiceUrl);
        map.put("url", url);
        return map;
    }

    protected void doSetAttribute(String atttrName, Object value) throws Exception {
        if ("description".equals(atttrName)) {
            if (value instanceof String) {
                this.fs.setDescription(this.getName(), String.valueOf(value));
            } else {
                this.fs.setDescription(this.getName(), null);
            }
        }
    }

    protected InputStream doGetInputStream() throws Exception {
        return new ByteArrayInputStream(this.fs.getData(this.getName()));
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        byte[] existingData = bAppend ? this.fs.getData(this.getName()) : new byte[]{};
        return new SolutionFileOutputStream(this, existingData);
    }

    public void writeData(byte[] data) throws FileSystemException {
        this.fs.setData(this.getName(), data);
    }

    protected void doCreateFolder() throws Exception {
        this.fs.createFolder(this.getName());
    }

    public String getDescription() throws FileSystemException {
        return this.fs.getDescription(this.getName());
    }

    public void setDescription(String description) throws FileSystemException {
        this.fs.setDescription(this.getName(), description);
    }

    public int delete(FileSelector selector) throws FileSystemException {
        return this.fs.delete(this.getName()) ? 1 : 0;
    }
}

