/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pensol.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.pentaho.reporting.libraries.base.util.FastStack;
import org.pentaho.reporting.libraries.pensol.SolutionFileModel;
import org.pentaho.reporting.libraries.pensol.vfs.FileInfo;
import org.pentaho.reporting.libraries.pensol.vfs.FileInfoParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class XmlSolutionFileModel
implements SolutionFileModel {
    private static final Log logger = LogFactory.getLog(XmlSolutionFileModel.class);
    private FileInfo root;
    private HashMap<FileName, String> descriptionEntries = new HashMap();
    private long refreshTime;
    private String majorVersion;
    private String minorVersion;
    private String releaseVersion;
    private String buildVersion;
    private String milestoneVersion;

    protected XmlSolutionFileModel() {
    }

    public FileInfo getRoot() {
        return this.root;
    }

    public void setRoot(FileInfo root) {
        this.root = root;
        this.refreshTime = System.currentTimeMillis();
    }

    @Override
    public boolean isDirectory(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.isDirectory();
    }

    @Override
    public boolean exists(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        return fileInfo != null;
    }

    @Override
    public boolean isVisible(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.isVisible();
    }

    public String getName(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getName();
    }

    @Override
    public String getLocalizedName(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getLocalizedName();
    }

    @Override
    public void setDescription(FileName file, String description) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        fileInfo.setDescription(description);
    }

    @Override
    public String getDescription(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getDescription();
    }

    @Override
    public long getLastModifiedDate(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getLastModifiedDate();
    }

    @Override
    public String getParamServiceUrl(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getParameterServiceURL();
    }

    public String getTitle(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getTitle();
    }

    @Override
    public String[] getChilds(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        FileInfo[] childs = fileInfo.getChilds();
        String[] childNames = new String[childs.length];
        for (int i = 0; i < childs.length; ++i) {
            FileInfo child = childs[i];
            childNames[i] = child.getName();
        }
        return childNames;
    }

    @Override
    public String getUrl(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return fileInfo.getUrl();
    }

    protected FileInfo lookupNode(String[] path) throws FileSystemException {
        if (this.root == null) {
            try {
                this.refresh();
            }
            catch (IOException e) {
                throw new FileSystemException((Throwable)e);
            }
        }
        if (path.length == 0) {
            return this.root;
        }
        if ("".equals(path[0])) {
            if (path.length == 1) {
                return this.root;
            }
        } else {
            return null;
        }
        FileInfo element = this.root;
        for (int i = 1; i < path.length; ++i) {
            FileInfo name = element.getChild(path[i]);
            if (name == null) {
                return null;
            }
            element = name;
        }
        return element;
    }

    protected String[] computeFileNames(FileName file) {
        FastStack stack = new FastStack();
        while (file != null) {
            String name = file.getBaseName();
            stack.push((Object)name);
            file = file.getParent();
        }
        int size = stack.size();
        String[] result = new String[size];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)stack.pop();
        }
        return result;
    }

    protected FileInfo performParse(InputStream postResult) throws IOException {
        try {
            FileInfoParser contentHandler = new FileInfoParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/xmlns-uris", false);
            }
            catch (SAXException e) {
                // empty catch block
            }
            try {
                reader.setFeature("http://xml.org/sax/features/namespaces", false);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            }
            catch (SAXException e) {
                logger.warn((Object)"No Namespace features will be available. (Yes, this is serious)", (Throwable)e);
            }
            reader.setContentHandler(contentHandler);
            reader.parse(new InputSource(postResult));
            this.majorVersion = contentHandler.getMajorVersion();
            this.minorVersion = contentHandler.getMinorVersion();
            this.releaseVersion = contentHandler.getReleaseVersion();
            this.buildVersion = contentHandler.getBuildVersion();
            this.milestoneVersion = contentHandler.getMilestoneVersion();
            return contentHandler.getRoot();
        }
        catch (ParserConfigurationException e) {
            throw new FileSystemException("Failed to init XML system", (Throwable)e);
        }
        catch (SAXException e) {
            throw new FileSystemException("Failed to parse document", (Throwable)e);
        }
    }

    @Override
    public byte[] getData(FileName file) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        return this.getDataInternally(fileInfo);
    }

    @Override
    public void setData(FileName file, byte[] data) throws FileSystemException {
        String[] fileName = this.computeFileNames(file);
        FileInfo fileInfo = this.lookupNode(fileName);
        if (fileInfo == null) {
            throw new FileSystemException("File is not valid.");
        }
        this.setDataInternally(fileInfo, data);
    }

    @Override
    public void createFolder(FileName file) throws FileSystemException {
        throw new FileSystemException("CreateFolder is not implemented");
    }

    protected abstract byte[] getDataInternally(FileInfo var1) throws FileSystemException;

    protected abstract void setDataInternally(FileInfo var1, byte[] var2) throws FileSystemException;

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public HashMap<FileName, String> getDescriptionEntries() {
        return this.descriptionEntries;
    }

    public String getMajorVersion() {
        return this.majorVersion;
    }

    public String getMinorVersion() {
        return this.minorVersion;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String getMilestoneVersion() {
        return this.milestoneVersion;
    }
}

