/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.RuntimeDroolsException;
import org.drools.base.TypeResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassTypeResolver
implements TypeResolver {
    private Set<String> imports = Collections.emptySet();
    private ClassLoader classLoader;
    private Map cachedImports = new HashMap();
    private static final Map internalNamesMap = new HashMap();

    public ClassTypeResolver(Set<String> imports, ClassLoader classLoader) {
        this.imports = imports;
        if (classLoader == null) {
            throw new RuntimeDroolsException("ClassTypeResolver cannot have a null parent ClassLoader");
        }
        this.classLoader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Set<String> getImports() {
        return this.imports;
    }

    @Override
    public void addImport(String importEntry) {
        if (this.imports == Collections.EMPTY_SET) {
            this.imports = new HashSet<String>();
        }
        this.imports.add(importEntry);
    }

    public Class lookupFromCache(String className) {
        return (Class)this.cachedImports.get(className);
    }

    @Override
    public Class resolveType(String className) throws ClassNotFoundException {
        Class clazz = null;
        boolean isArray = false;
        StringBuilder arrayClassName = new StringBuilder();
        if (internalNamesMap.containsKey(className)) {
            clazz = Class.forName("[" + internalNamesMap.get(className), true, this.classLoader).getComponentType();
        } else if (className.indexOf(91) > 0) {
            isArray = true;
            int bracketIndex = className.indexOf(91);
            String componentName = className.substring(0, bracketIndex);
            arrayClassName.append('[');
            while ((bracketIndex = className.indexOf(91, bracketIndex + 1)) > 0) {
                arrayClassName.append('[');
            }
            className = componentName;
        }
        if (clazz == null) {
            clazz = this.lookupFromCache(className);
        }
        if (clazz == null) {
            try {
                clazz = this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            HashSet<Class> validClazzCandidates = new HashSet<Class>();
            Iterator<String> it = this.imports.iterator();
            while (it.hasNext()) {
                clazz = this.importClass(it.next(), className);
                if (clazz == null) continue;
                validClazzCandidates.add(clazz);
            }
            if (validClazzCandidates.size() > 1) {
                StringBuilder sb = new StringBuilder();
                Iterator clazzCandIter = validClazzCandidates.iterator();
                while (clazzCandIter.hasNext()) {
                    if (0 != sb.length()) {
                        sb.append(", ");
                    }
                    sb.append(((Class)clazzCandIter.next()).getName());
                }
                throw new Error("Unable to find unambiguously defined class '" + className + "', candidates are: [" + sb.toString() + "]");
            }
            clazz = validClazzCandidates.size() == 1 ? (Class)validClazzCandidates.toArray()[0] : null;
        }
        if (clazz == null) {
            clazz = this.defaultClass(className);
        }
        if (isArray) {
            if (clazz == null && internalNamesMap.containsKey(className)) {
                arrayClassName.append(internalNamesMap.get(className));
            } else if (clazz != null) {
                arrayClassName.append("L").append(clazz.getName()).append(";");
            } else {
                arrayClassName.append("L").append(className).append(";");
            }
            try {
                clazz = Class.forName(arrayClassName.toString());
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to find class '" + className + "'");
        }
        return clazz;
    }

    private Class importClass(String importText, String className) {
        String qualifiedClass = null;
        Class<?> clazz = null;
        if (importText.endsWith("*")) {
            qualifiedClass = importText.substring(0, importText.indexOf(42)) + className;
        } else if (importText.endsWith("." + className)) {
            qualifiedClass = importText;
        } else if (className.indexOf(46) > 0 && importText.endsWith(className.split("\\.")[0])) {
            qualifiedClass = importText + className.substring(className.indexOf(46));
        } else if (importText.equals(className)) {
            qualifiedClass = importText;
        }
        if (qualifiedClass != null) {
            int lastIndex;
            try {
                clazz = this.classLoader.loadClass(qualifiedClass);
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            while (clazz == null && (lastIndex = qualifiedClass.lastIndexOf(46)) != -1) {
                try {
                    qualifiedClass = qualifiedClass.substring(0, lastIndex) + "$" + qualifiedClass.substring(lastIndex + 1);
                    clazz = this.classLoader.loadClass(qualifiedClass);
                }
                catch (ClassNotFoundException e) {
                    clazz = null;
                }
            }
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(className, clazz);
        }
        return clazz;
    }

    private Class defaultClass(String className) {
        String qualifiedClass = "java.lang." + className;
        Class<?> clazz = null;
        try {
            clazz = this.classLoader.loadClass(qualifiedClass);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clazz != null) {
            if (this.cachedImports == Collections.EMPTY_MAP) {
                this.cachedImports = new HashMap();
            }
            this.cachedImports.put(className, clazz);
        }
        return clazz;
    }

    public boolean isEmpty() {
        return this.imports.isEmpty();
    }

    @Override
    public String getFullTypeName(String shortName) throws ClassNotFoundException {
        Class clz = this.resolveType(shortName);
        if (clz == null) {
            throw new IllegalArgumentException("Unable to resolve the full type name for " + shortName);
        }
        return clz.getName();
    }

    static {
        internalNamesMap.put("int", "I");
        internalNamesMap.put("boolean", "Z");
        internalNamesMap.put("float", "F");
        internalNamesMap.put("long", "J");
        internalNamesMap.put("short", "S");
        internalNamesMap.put("byte", "B");
        internalNamesMap.put("double", "D");
        internalNamesMap.put("char", "C");
    }
}

