/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hdfs.vfs;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.pentaho.hdfs.vfs.HDFSFileSystem;
import org.pentaho.hdfs.vfs.HadoopFileSystem;
import org.pentaho.hdfs.vfs.HadoopFileSystemImpl;

public class MapRFileSystem
extends HDFSFileSystem
implements org.apache.commons.vfs.FileSystem {
    private HadoopFileSystem fs;

    public MapRFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, fileSystemOptions);
    }

    @Override
    public HadoopFileSystem getHDFSFileSystem() throws FileSystemException {
        if (this.fs == null) {
            Configuration conf = new Configuration();
            conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
            GenericFileName rootName = (GenericFileName)this.getRootName();
            String url = rootName.getScheme() + "://" + rootName.getHostName().trim();
            if (rootName.getPort() != -1) {
                url = url + ":" + rootName.getPort();
            }
            url = url + "/";
            conf.set("fs.default.name", url);
            MapRFileSystem.setFileSystemOptions(this.getFileSystemOptions(), conf);
            try {
                this.fs = new HadoopFileSystemImpl(FileSystem.get((Configuration)conf));
            }
            catch (Throwable t) {
                throw new FileSystemException("Could not get MapR FileSystem for " + url, t);
            }
        }
        return this.fs;
    }
}

