/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DelegationTokenManager {
    public static final String ENABLE_ZK_KEY = "zk-dt-secret-manager.enable";
    public static final String PREFIX = "delegation-token.";
    public static final String UPDATE_INTERVAL = "delegation-token.update-interval.sec";
    public static final long UPDATE_INTERVAL_DEFAULT = 86400L;
    public static final String MAX_LIFETIME = "delegation-token.max-lifetime.sec";
    public static final long MAX_LIFETIME_DEFAULT = 604800L;
    public static final String RENEW_INTERVAL = "delegation-token.renew-interval.sec";
    public static final long RENEW_INTERVAL_DEFAULT = 86400L;
    public static final String REMOVAL_SCAN_INTERVAL = "delegation-token.removal-scan-interval.sec";
    public static final long REMOVAL_SCAN_INTERVAL_DEFAULT = 3600L;
    private AbstractDelegationTokenSecretManager secretManager = null;
    private boolean managedSecretManager;
    private Text tokenKind;

    public DelegationTokenManager(Configuration conf, Text tokenKind) {
        this.secretManager = conf.getBoolean(ENABLE_ZK_KEY, false) ? new ZKSecretManager(conf, tokenKind) : new DelegationTokenSecretManager(conf, tokenKind);
        this.tokenKind = tokenKind;
        this.managedSecretManager = true;
    }

    public void setExternalDelegationTokenSecretManager(AbstractDelegationTokenSecretManager secretManager) {
        this.secretManager.stopThreads();
        this.secretManager = secretManager;
        this.tokenKind = ((TokenIdentifier)secretManager.createIdentifier()).getKind();
        this.managedSecretManager = false;
    }

    public void init() {
        if (this.managedSecretManager) {
            try {
                this.secretManager.startThreads();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not start " + this.secretManager.getClass() + ": " + ex.toString(), ex);
            }
        }
    }

    public void destroy() {
        if (this.managedSecretManager) {
            this.secretManager.stopThreads();
        }
    }

    public Token<DelegationTokenIdentifier> createToken(UserGroupInformation ugi, String renewer) {
        renewer = renewer == null ? ugi.getShortUserName() : renewer;
        String user = ugi.getUserName();
        Text owner = new Text(user);
        Text realUser = null;
        if (ugi.getRealUser() != null) {
            realUser = new Text(ugi.getRealUser().getUserName());
        }
        DelegationTokenIdentifier tokenIdentifier = new DelegationTokenIdentifier(this.tokenKind, owner, new Text(renewer), realUser);
        return new Token<DelegationTokenIdentifier>(tokenIdentifier, this.secretManager);
    }

    public long renewToken(Token<DelegationTokenIdentifier> token, String renewer) throws IOException {
        return this.secretManager.renewToken(token, renewer);
    }

    public void cancelToken(Token<DelegationTokenIdentifier> token, String canceler) throws IOException {
        canceler = canceler != null ? canceler : this.verifyToken(token).getShortUserName();
        this.secretManager.cancelToken(token, canceler);
    }

    public UserGroupInformation verifyToken(Token<DelegationTokenIdentifier> token) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream dis = new DataInputStream(buf);
        DelegationTokenIdentifier id = new DelegationTokenIdentifier(this.tokenKind);
        id.readFields(dis);
        dis.close();
        this.secretManager.verifyToken(id, token.getPassword());
        return id.getUser();
    }

    @VisibleForTesting
    public AbstractDelegationTokenSecretManager getDelegationTokenSecretManager() {
        return this.secretManager;
    }

    private static class ZKSecretManager
    extends ZKDelegationTokenSecretManager<DelegationTokenIdentifier> {
        private Text tokenKind;

        public ZKSecretManager(Configuration conf, Text tokenKind) {
            super(conf);
            this.tokenKind = tokenKind;
        }

        @Override
        public DelegationTokenIdentifier createIdentifier() {
            return new DelegationTokenIdentifier(this.tokenKind);
        }
    }

    private static class DelegationTokenSecretManager
    extends AbstractDelegationTokenSecretManager<DelegationTokenIdentifier> {
        private Text tokenKind;

        public DelegationTokenSecretManager(Configuration conf, Text tokenKind) {
            super(conf.getLong(DelegationTokenManager.UPDATE_INTERVAL, 86400L) * 1000L, conf.getLong(DelegationTokenManager.MAX_LIFETIME, 604800L) * 1000L, conf.getLong(DelegationTokenManager.RENEW_INTERVAL, 86400L) * 1000L, conf.getLong(DelegationTokenManager.REMOVAL_SCAN_INTERVAL, 3600000L));
            this.tokenKind = tokenKind;
        }

        @Override
        public DelegationTokenIdentifier createIdentifier() {
            return new DelegationTokenIdentifier(this.tokenKind);
        }
    }
}

