/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;

    public ConstructorDeclaration(int modifier, Type declaredAgainst, List<ParameterExpression> parameters, BlockStatement body) {
        this.modifier = modifier;
        this.resultType = declaredAgainst;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Visitor visitor) {
        BlockStatement body = this.body.accept(visitor);
        return visitor.visit(this, this.parameters, body);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).list("(", ", ", ")", Functions.adapt(this.parameters, new Function1<ParameterExpression, String>(){

            @Override
            public String apply(ParameterExpression parameter) {
                String modifiers = Modifier.toString(parameter.modifier);
                return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(parameter.getType()) + " " + parameter.name;
            }
        })).append(' ').append(this.body);
        writer.newlineAndIndent();
    }
}

