/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Blocks;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.LambdaExpression;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;
import net.hydromatic.linq4j.function.Function;
import net.hydromatic.linq4j.function.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionExpression<F extends Function<?>>
extends LambdaExpression {
    public final F function;
    public final BlockStatement body;
    public final List<ParameterExpression> parameterList;
    private F dynamicFunction;

    private FunctionExpression(Class<F> type, F function, BlockStatement body, List<ParameterExpression> parameterList) {
        super(ExpressionType.Lambda, type);
        assert (type != null);
        assert (function != null || body != null);
        this.function = function;
        this.body = body;
        this.parameterList = parameterList;
    }

    public FunctionExpression(F function) {
        this(function.getClass(), function, null, Collections.emptyList());
    }

    public FunctionExpression(Class<F> type, BlockStatement body, List<ParameterExpression> parameters) {
        this(type, null, body, parameters);
    }

    @Override
    public Expression accept(Visitor visitor) {
        BlockStatement body = this.body.accept(visitor);
        return visitor.visit(this, body, this.parameterList);
    }

    public Invokable compile() {
        return new Invokable(){

            public Object dynamicInvoke(Object ... args) {
                Evaluator evaluator = new Evaluator();
                for (int i = 0; i < args.length; ++i) {
                    evaluator.push(FunctionExpression.this.parameterList.get(i), args[i]);
                }
                return evaluator.evaluate(FunctionExpression.this.body);
            }
        };
    }

    public F getFunction() {
        if (this.function != null) {
            return this.function;
        }
        if (this.dynamicFunction == null) {
            final Invokable x = this.compile();
            this.dynamicFunction = (Function)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Types.toClass(this.type)}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return x.dynamicInvoke(args);
                }
            });
        }
        return this.dynamicFunction;
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> bridgeParams = new ArrayList<String>();
        ArrayList<String> bridgeArgs = new ArrayList<String>();
        ArrayList<String> boxBridgeParams = new ArrayList<String>();
        ArrayList<String> boxBridgeArgs = new ArrayList<String>();
        for (ParameterExpression parameterExpression : this.parameterList) {
            Type parameterType = parameterExpression.getType();
            Type parameterBoxType = Types.box(parameterType);
            String parameterBoxTypeName = Types.className(parameterBoxType);
            params.add(parameterExpression.declString());
            bridgeParams.add(parameterExpression.declString((Type)((Object)Object.class)));
            bridgeArgs.add("(" + parameterBoxTypeName + ") " + parameterExpression.name);
            boxBridgeParams.add(parameterExpression.declString(parameterBoxType));
            boxBridgeArgs.add(parameterExpression.name + (Primitive.is(parameterType) ? "." + Primitive.of((Type)parameterType).primitiveName + "Value()" : ""));
        }
        Type bridgeResultType = Functions.FUNCTION_RESULT_TYPES.get(this.type);
        if (bridgeResultType == null) {
            bridgeResultType = this.body.getType();
        }
        Type resultType2 = bridgeResultType;
        if (bridgeResultType == Object.class && !params.equals(bridgeParams) && !(this.body.getType() instanceof TypeVariable)) {
            resultType2 = this.body.getType();
        }
        String methodName = this.getAbstractMethodName();
        writer.append("new ").append(this.type).append("()").begin(" {\n").append("public ").append(Types.className(resultType2)).list(" " + methodName + "(", ", ", ") ", params).append(Blocks.toFunctionBlock(this.body));
        if (!boxBridgeParams.equals(params)) {
            writer.append("public ").append(Types.boxClassName(bridgeResultType)).list(" " + methodName + "(", ", ", ") ", boxBridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", boxBridgeArgs).end("}\n");
        }
        if (!bridgeParams.equals(params)) {
            writer.append("public ").append(Types.boxClassName(bridgeResultType)).list(" " + methodName + "(", ", ", ") ", bridgeParams).begin("{\n").list("return " + methodName + "(\n", ",\n", ");\n", bridgeArgs).end("}\n");
        }
        writer.end("}\n");
    }

    private String getAbstractMethodName() {
        if (this.type.toString().contains("OptiqFlatMapFunction")) {
            return "call";
        }
        return "apply";
    }

    public static interface Invokable {
        public Object dynamicInvoke(Object ... var1);
    }
}

