/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexExpression
extends Expression {
    public final Expression array;
    public final List<Expression> indexExpressions;

    public IndexExpression(Expression array, List<Expression> indexExpressions) {
        super(ExpressionType.ArrayIndex, Types.getComponentType(array.getType()));
        this.array = array;
        this.indexExpressions = indexExpressions;
        assert (indexExpressions.size() >= 1);
    }

    public int hashCode() {
        return this.nodeType.hashCode() ^ this.array.hashCode() ^ this.indexExpressions.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexExpression) {
            IndexExpression indexExpression = (IndexExpression)obj;
            return this.nodeType == indexExpression.nodeType && this.array.equals(indexExpression.array) && this.indexExpressions.equals(indexExpression.indexExpressions);
        }
        return false;
    }

    @Override
    public Expression accept(Visitor visitor) {
        Expression array = this.array.accept(visitor);
        List<Expression> indexExpressions = Expressions.acceptExpressions(this.indexExpressions, visitor);
        return visitor.visit(this, array, indexExpressions);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        this.array.accept(writer, lprec, this.nodeType.lprec);
        writer.list("[", ", ", "]", this.indexExpressions);
    }
}

