/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.PseudoField;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

public class MemberExpression
extends Expression {
    public final Expression expression;
    public final PseudoField field;

    public MemberExpression(Expression expression, Field field) {
        this(expression, Types.field(field));
    }

    public MemberExpression(Expression expression, PseudoField field) {
        super(ExpressionType.MemberAccess, field.getType());
        this.expression = expression;
        this.field = field;
        assert (expression != null || Modifier.isStatic(field.getModifiers())) : "must specify expression if field is not static";
    }

    public Expression accept(Visitor visitor) {
        Expression expression1 = this.expression == null ? null : this.expression.accept(visitor);
        return visitor.visit(this, expression1);
    }

    public Object evaluate(Evaluator evaluator) {
        Object o = this.expression == null ? null : this.expression.evaluate(evaluator);
        try {
            return this.field.get(o);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("error while evaluating " + this, e);
        }
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        if (this.expression != null) {
            this.expression.accept(writer, lprec, this.nodeType.lprec);
        } else {
            assert ((this.field.getModifiers() & 8) != 0);
            writer.append(this.field.getDeclaringClass());
        }
        writer.append('.').append(this.field.getName());
    }
}

