/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.MemberDeclaration;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDeclaration
extends MemberDeclaration {
    public final int modifier;
    public final String name;
    public final Type resultType;
    public final List<ParameterExpression> parameters;
    public final BlockStatement body;

    public MethodDeclaration(int modifier, String name, Type resultType, List<ParameterExpression> parameters, BlockStatement body) {
        this.modifier = modifier;
        this.name = name;
        this.resultType = resultType;
        this.parameters = parameters;
        this.body = body;
    }

    @Override
    public MemberDeclaration accept(Visitor visitor) {
        BlockStatement body = this.body.accept(visitor);
        return visitor.visit(this, this.parameters, body);
    }

    @Override
    public void accept(ExpressionWriter writer) {
        String modifiers = Modifier.toString(this.modifier);
        writer.append(modifiers);
        if (!modifiers.isEmpty()) {
            writer.append(' ');
        }
        writer.append(this.resultType).append(' ').append(this.name).list("(", ", ", ")", new AbstractList<String>(){

            @Override
            public String get(int index) {
                return MethodDeclaration.this.parameters.get(index).declString();
            }

            @Override
            public int size() {
                return MethodDeclaration.this.parameters.size();
            }
        }).append(' ').append(this.body);
        writer.newlineAndIndent();
    }
}

