/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import net.hydromatic.linq4j.expressions.Evaluator;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

public class ParameterExpression
extends Expression {
    private static int seq = 0;
    public final int modifier;
    public final String name;

    public ParameterExpression(Type type) {
        this(0, type, "p" + seq++);
    }

    public ParameterExpression(int modifier, Type type, String name) {
        super(ExpressionType.Parameter, type);
        this.modifier = modifier;
        this.name = name;
    }

    public Expression accept(Visitor visitor) {
        return visitor.visit(this);
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.peek(this);
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append(this.name);
    }

    String declString() {
        return this.declString(this.type);
    }

    String declString(Type type) {
        String modifiers = Modifier.toString(this.modifier);
        return modifiers + (modifiers.isEmpty() ? "" : " ") + Types.className(type) + " " + this.name;
    }
}

