/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileDepthSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileTypeSelector;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.VersionInfo;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginFolder;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hadoop.shim.api.Configuration;
import org.pentaho.hadoop.shim.api.DistributedCacheUtil;
import org.pentaho.hadoop.shim.api.fs.FileSystem;
import org.pentaho.hadoop.shim.api.fs.Path;
import org.pentaho.hadoop.shim.common.ShimUtils;

public class DistributedCacheUtilImpl
implements DistributedCacheUtil {
    private static final String PATH_LIB = "lib";
    private static final String PATH_PMR = "pmr";
    private static final String PATH_CLIENT = "client";
    private static final String PATH_PLUGINS = "plugins";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final Pattern NOT_LIB_FILES = Pattern.compile("^((?!/lib).)*$");
    private static final FsPermission CACHED_FILE_PERMISSION = new FsPermission(493);
    public static final String PENTAHO_BIG_DATA_PLUGIN_FOLDER_NAME = "pentaho-big-data-plugin";
    private HadoopConfiguration configuration;

    public DistributedCacheUtilImpl(HadoopConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.configuration = configuration;
    }

    public org.apache.hadoop.fs.Path getLockFileAt(org.apache.hadoop.fs.Path dir) {
        return new org.apache.hadoop.fs.Path(dir, ".lock");
    }

    public boolean isKettleEnvironmentInstalledAt(org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path root) throws IOException {
        org.apache.hadoop.fs.Path[] directories = new org.apache.hadoop.fs.Path[]{new org.apache.hadoop.fs.Path(root, PATH_LIB), new org.apache.hadoop.fs.Path(root, PATH_PLUGINS), new org.apache.hadoop.fs.Path(new org.apache.hadoop.fs.Path(root, PATH_PLUGINS), PENTAHO_BIG_DATA_PLUGIN_FOLDER_NAME)};
        org.apache.hadoop.fs.Path lock = this.getLockFileAt(root);
        for (org.apache.hadoop.fs.Path dir : directories) {
            if (fs.exists(dir) && fs.getFileStatus(dir).isDir()) continue;
            return false;
        }
        return !fs.exists(lock);
    }

    public void installKettleEnvironment(FileObject pmrArchive, org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path destination, FileObject bigDataPlugin, String additionalPlugins) throws IOException, KettleFileException {
        if (pmrArchive == null) {
            throw new NullPointerException("pmrArchive is required");
        }
        if (destination == null) {
            throw new NullPointerException("destination is required");
        }
        if (bigDataPlugin == null) {
            throw new NullPointerException("big data plugin required");
        }
        FileObject extracted = this.extractToTemp(pmrArchive);
        org.apache.hadoop.fs.Path lockFile = this.getLockFileAt(destination);
        fs.create(lockFile, true);
        this.stageForCache(extracted, fs, destination, true);
        this.stageBigDataPlugin(fs, destination, bigDataPlugin);
        if (!Const.isEmpty((String)additionalPlugins)) {
            this.stagePluginsForCache(fs, new org.apache.hadoop.fs.Path(destination, PATH_PLUGINS), additionalPlugins);
        }
        fs.delete(lockFile, true);
    }

    private void stageBigDataPlugin(org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path dest, FileObject pluginFolder) throws KettleFileException, IOException {
        org.apache.hadoop.fs.Path pluginsDir = new org.apache.hadoop.fs.Path(dest, PATH_PLUGINS);
        org.apache.hadoop.fs.Path libDir = new org.apache.hadoop.fs.Path(dest, PATH_LIB);
        org.apache.hadoop.fs.Path bigDataPluginDir = new org.apache.hadoop.fs.Path(pluginsDir, pluginFolder.getName().getBaseName());
        for (FileObject f : pluginFolder.findFiles((FileSelector)new FileDepthSelector(1, 1))) {
            if ("hadoop-configurations".equals(f.getName().getBaseName()) || "pentaho-mapreduce-libraries.zip".equals(f.getName().getBaseName())) continue;
            this.stageForCache(f, fs, new org.apache.hadoop.fs.Path(bigDataPluginDir, f.getName().getBaseName()), true);
        }
        org.apache.hadoop.fs.Path hadoopConfigDir = new org.apache.hadoop.fs.Path(new org.apache.hadoop.fs.Path(bigDataPluginDir, "hadoop-configurations"), this.configuration.getIdentifier());
        for (FileObject f : this.configuration.getLocation().findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo info) throws Exception {
                return FileType.FILE.equals(info.getFile().getType());
            }

            public boolean traverseDescendents(FileSelectInfo info) throws Exception {
                String name = info.getFile().getName().getBaseName();
                return !DistributedCacheUtilImpl.PATH_PMR.equals(name) && !DistributedCacheUtilImpl.PATH_CLIENT.equals(name) || !DistributedCacheUtilImpl.PATH_LIB.equals(info.getFile().getParent().getName().getBaseName());
            }
        })) {
            String relPath = this.configuration.getLocation().getName().getRelativeName(f.getName());
            this.stageForCache(f, fs, new org.apache.hadoop.fs.Path(hadoopConfigDir, relPath), true);
        }
        for (FileObject f : this.configuration.getLocation().resolveFile(PATH_LIB).resolveFile(PATH_PMR).findFiles((FileSelector)new FileTypeSelector(FileType.FILE))) {
            this.stageForCache(f, fs, new org.apache.hadoop.fs.Path(libDir, f.getName().getBaseName()), true);
        }
    }

    public void stagePluginsForCache(org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path pluginsDir, String pluginFolderNames) throws KettleFileException, IOException {
        if (pluginFolderNames == null) {
            throw new IllegalArgumentException("pluginFolderNames required");
        }
        if (!fs.exists(pluginsDir)) {
            fs.mkdirs(pluginsDir);
        }
        for (String localPluginPath : pluginFolderNames.split(",")) {
            localPluginPath.trim();
            Object[] localFileTuple = this.findPluginFolder(localPluginPath);
            if (localFileTuple == null || !((FileObject)localFileTuple[0]).exists()) {
                throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.PluginDirectoryNotFound", (String[])new String[]{localPluginPath}));
            }
            FileObject localFile = (FileObject)localFileTuple[0];
            String relativePath = (String)localFileTuple[1];
            org.apache.hadoop.fs.Path pluginDir = new org.apache.hadoop.fs.Path(pluginsDir, relativePath);
            this.stageForCache(localFile, fs, pluginDir, true);
        }
    }

    public void configureWithKettleEnvironment(org.apache.hadoop.conf.Configuration conf, org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path kettleInstallDir) throws KettleFileException, IOException {
        org.apache.hadoop.fs.Path libDir = new org.apache.hadoop.fs.Path(kettleInstallDir, PATH_LIB);
        List<org.apache.hadoop.fs.Path> libraryJars = this.findFiles(fs, libDir, null);
        this.addCachedFilesToClasspath(libraryJars, conf);
        List<org.apache.hadoop.fs.Path> nonLibFiles = this.findFiles(fs, kettleInstallDir, NOT_LIB_FILES);
        this.addCachedFiles(nonLibFiles, conf);
    }

    public void addCachedFilesToClasspath(List<org.apache.hadoop.fs.Path> files, org.apache.hadoop.conf.Configuration conf) throws IOException {
        DistributedCache.createSymlink((org.apache.hadoop.conf.Configuration)conf);
        for (org.apache.hadoop.fs.Path file : files) {
            this.addFileToClassPath(this.disqualifyPath(file), conf);
        }
    }

    public void addFileToClassPath(org.apache.hadoop.fs.Path file, org.apache.hadoop.conf.Configuration conf) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VersionInfo.class.getClassLoader());
        try {
            String version = VersionInfo.getVersion();
        }
        catch (Throwable t) {
            String version = "unknown";
        }
        Thread.currentThread().setContextClassLoader(cl);
        String classpath = conf.get("mapred.job.classpath.files");
        conf.set("mapred.job.classpath.files", classpath == null ? file.toString() : classpath + this.getClusterPathSeparator() + file.toString());
        org.apache.hadoop.fs.FileSystem fs = org.apache.hadoop.fs.FileSystem.get((org.apache.hadoop.conf.Configuration)conf);
        URI uri = fs.makeQualified(file).toUri();
        DistributedCache.addCacheFile((URI)uri, (org.apache.hadoop.conf.Configuration)conf);
    }

    public void addCachedFiles(List<org.apache.hadoop.fs.Path> paths, org.apache.hadoop.conf.Configuration conf) throws IOException {
        DistributedCache.createSymlink((org.apache.hadoop.conf.Configuration)conf);
        for (org.apache.hadoop.fs.Path path : paths) {
            DistributedCache.addCacheFile((URI)URI.create(path.toUri() + "#" + path.getName()), (org.apache.hadoop.conf.Configuration)conf);
        }
    }

    public org.apache.hadoop.fs.Path disqualifyPath(org.apache.hadoop.fs.Path path) {
        return new org.apache.hadoop.fs.Path(path.toUri().getPath());
    }

    public void stageForCache(FileObject source, org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path dest, boolean overwrite) throws IOException, KettleFileException {
        if (!source.exists()) {
            throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.SourceDoesNotExist", (Object[])new Object[]{source}));
        }
        if (fs.exists(dest)) {
            if (overwrite) {
                fs.delete(dest, true);
            } else {
                throw new KettleFileException(BaseMessages.getString(DistributedCacheUtilImpl.class, (String)"DistributedCacheUtil.DestinationExists", (String[])new String[]{dest.toUri().getPath()}));
            }
        }
        short replication = (short)fs.getConf().getInt("mapred.submit.replication", 10);
        org.apache.hadoop.fs.Path local = new org.apache.hadoop.fs.Path(source.getURL().getPath());
        fs.copyFromLocalFile(local, dest);
        fs.setPermission(dest, CACHED_FILE_PERMISSION);
        fs.setReplication(dest, replication);
    }

    public List<String> findFiles(FileObject root, final String extension) throws FileSystemException {
        FileObject[] files = root.findFiles(new FileSelector(){

            public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                return extension == null || extension.equals(fileSelectInfo.getFile().getName().getExtension());
            }

            public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                return FileType.FOLDER.equals(fileSelectInfo.getFile().getType());
            }
        });
        if (files == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (FileObject file : files) {
            try {
                paths.add(file.getURL().toURI().getPath());
            }
            catch (URISyntaxException ex) {
                throw new FileSystemException("Error getting URI of file: " + file.getURL().getPath());
            }
        }
        return paths;
    }

    public List<org.apache.hadoop.fs.Path> findFiles(org.apache.hadoop.fs.FileSystem fs, org.apache.hadoop.fs.Path path, Pattern fileNamePattern) throws IOException {
        FileStatus[] files = fs.listStatus(path);
        ArrayList<org.apache.hadoop.fs.Path> found = new ArrayList<org.apache.hadoop.fs.Path>(files.length);
        for (FileStatus file : files) {
            if (fileNamePattern != null && !fileNamePattern.matcher(file.getPath().toString()).matches()) continue;
            found.add(file.getPath());
        }
        return found;
    }

    public boolean deleteDirectory(FileObject dir) throws FileSystemException {
        dir.delete((FileSelector)new AllFileSelector());
        return !dir.exists();
    }

    public FileObject extractToTemp(FileObject archive) throws IOException, KettleFileException {
        if (archive == null) {
            throw new NullPointerException("archive is required");
        }
        FileObject dest = KettleVFS.createTempFile((String)"", (String)"", (String)System.getProperty("java.io.tmpdir"));
        return this.extract(archive, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileObject extract(FileObject archive, FileObject dest) throws IOException, KettleFileException {
        if (!archive.exists()) {
            throw new IllegalArgumentException("archive does not exist: " + archive.getURL().getPath());
        }
        if (dest.exists()) {
            throw new IllegalArgumentException("destination already exists");
        }
        dest.createFolder();
        try {
            byte[] buffer = new byte[8192];
            int len = 0;
            ZipInputStream zis = new ZipInputStream(archive.getContent().getInputStream());
            try {
                ZipEntry ze;
                block8: while ((ze = zis.getNextEntry()) != null) {
                    FileObject entry = KettleVFS.getFileObject((String)(dest + Const.FILE_SEPARATOR + ze.getName()));
                    if (ze.isDirectory()) {
                        entry.createFolder();
                        continue;
                    }
                    OutputStream os = KettleVFS.getOutputStream((FileObject)entry, (boolean)false);
                    try {
                        while (true) {
                            if ((len = zis.read(buffer)) <= 0) continue block8;
                            os.write(buffer, 0, len);
                        }
                    }
                    finally {
                        if (os == null) continue;
                        os.close();
                    }
                }
                return dest;
            }
            finally {
                if (zis != null) {
                    zis.close();
                }
            }
        }
        catch (Exception ex) {
            if (this.deleteDirectory(dest)) throw new KettleFileException("error extracting archive", (Throwable)ex);
            throw new KettleFileException("Could not clean up temp dir after error extracting", (Throwable)ex);
        }
    }

    protected Object[] findPluginFolder(final String pluginFolderName) throws KettleFileException {
        List pluginFolders = PluginFolder.populateFolders(null);
        if (pluginFolders != null) {
            for (PluginFolderInterface pluginFolder : pluginFolders) {
                FileObject folder = KettleVFS.getFileObject((String)pluginFolder.getFolder());
                try {
                    FileObject[] files;
                    if (!folder.exists() || (files = folder.findFiles(new FileSelector(){

                        public boolean includeFile(FileSelectInfo fileSelectInfo) throws Exception {
                            if (fileSelectInfo.getFile().equals(fileSelectInfo.getBaseFolder())) {
                                return false;
                            }
                            int baseNameLength = fileSelectInfo.getBaseFolder().getName().getPath().length() + 1;
                            String relativeName = fileSelectInfo.getFile().getName().getPath().substring(baseNameLength);
                            return pluginFolderName.equals(relativeName);
                        }

                        public boolean traverseDescendents(FileSelectInfo fileSelectInfo) throws Exception {
                            return true;
                        }
                    })) == null || files.length <= 0) continue;
                    return new Object[]{files[0], folder.getName().getRelativeName(files[0].getName())};
                }
                catch (FileSystemException ex) {
                    throw new KettleFileException("Error searching for folder '" + pluginFolderName + "'", (Throwable)ex);
                }
            }
        }
        return null;
    }

    public String getClusterPathSeparator() {
        return System.getProperty("hadoop.cluster.path.separator", ":");
    }

    public boolean isKettleEnvironmentInstalledAt(FileSystem fs, Path kettleEnvInstallDir) throws IOException {
        return this.isKettleEnvironmentInstalledAt(ShimUtils.asFileSystem(fs), ShimUtils.asPath(kettleEnvInstallDir));
    }

    public void configureWithKettleEnvironment(Configuration conf, FileSystem fs, Path kettleEnvInstallDir) throws KettleFileException, IOException {
        this.configureWithKettleEnvironment((org.apache.hadoop.conf.Configuration)ShimUtils.asConfiguration(conf), ShimUtils.asFileSystem(fs), ShimUtils.asPath(kettleEnvInstallDir));
    }

    public void installKettleEnvironment(FileObject pmrLibArchive, FileSystem fs, Path destination, FileObject bigDataPluginFolder, String additionalPlugins) throws KettleFileException, IOException {
        this.installKettleEnvironment(pmrLibArchive, ShimUtils.asFileSystem(fs), ShimUtils.asPath(destination), bigDataPluginFolder, additionalPlugins);
    }
}

