/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONObject;

@Entity
@Table(name="BUNDLE_ACTIONS")
@NamedQueries(value={@NamedQuery(name="DELETE_BUNDLE_ACTION", query="delete from BundleActionBean w where w.bundleActionId = :bundleActionId"), @NamedQuery(name="UPDATE_BUNDLE_ACTION_PENDING_MODTIME", query="update BundleActionBean w set w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending where w.bundleActionId = :bundleActionId"), @NamedQuery(name="UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME", query="update BundleActionBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending where w.bundleActionId = :bundleActionId"), @NamedQuery(name="UPDATE_BUNDLE_ACTION_STATUS_PENDING_MODTIME_COORDID", query="update BundleActionBean w set w.statusStr = :status, w.lastModifiedTimestamp = :lastModifiedTime, w.pending = :pending, w.coordId = :coordId where w.bundleActionId = :bundleActionId"), @NamedQuery(name="GET_BUNDLE_ACTIONS_FOR_BUNDLE", query="select OBJECT(w) from BundleActionBean w where w.bundleId = :bundleId"), @NamedQuery(name="GET_BUNDLE_ACTION_STATUS_PENDING_FOR_BUNDLE", query="select w.coordId, w.statusStr, w.pending from BundleActionBean w where w.bundleId = :bundleId"), @NamedQuery(name="GET_BUNDLE_ACTIONS", query="select OBJECT(w) from BundleActionBean w"), @NamedQuery(name="GET_BUNDLE_ACTIONS_BY_LAST_MODIFIED_TIME", query="select w.bundleId from BundleActionBean w where w.lastModifiedTimestamp >= :lastModifiedTime"), @NamedQuery(name="GET_BUNDLE_WAITING_ACTIONS_OLDER_THAN", query="select w.bundleActionId, w.bundleId, w.statusStr, w.coordId, w.coordName from BundleActionBean w where w.pending > 0 AND w.lastModifiedTimestamp <= :lastModifiedTime"), @NamedQuery(name="GET_BUNDLE_ACTION", query="select OBJECT(w) from BundleActionBean w where w.bundleActionId = :bundleActionId"), @NamedQuery(name="GET_BUNDLE_ACTIONS_COUNT", query="select count(w) from BundleActionBean w"), @NamedQuery(name="GET_BUNDLE_ACTIONS_COUNT_BY_JOB", query="select count(w) from BundleActionBean w where w.bundleId = :bundleId"), @NamedQuery(name="GET_BUNDLE_ACTIONS_PENDING_TRUE_COUNT", query="select count(w) from BundleActionBean w where w.bundleId = :bundleId AND w.pending > 0"), @NamedQuery(name="GET_BUNDLE_ACTIONS_NOT_EQUAL_STATUS_COUNT", query="select count(w) from BundleActionBean w where w.bundleId = :bundleId AND w.statusStr <> :status"), @NamedQuery(name="GET_BUNDLE_ACTIONS_NOT_TERMINATE_STATUS_COUNT", query="select count(w) from BundleActionBean w where w.bundleId = :bundleId AND (w.statusStr = 'PREP' OR w.statusStr = 'RUNNING' OR w.statusStr = 'RUNNINGWITHERROR' OR w.statusStr = 'SUSPENDED' OR w.statusStr = 'SUSPENDEDWITHERROR' OR w.statusStr = 'PREPSUSPENDED' OR w.statusStr = 'PAUSED' OR  w.statusStr = 'PAUSEDWITHERROR' OR w.statusStr = 'PREPPAUSED')"), @NamedQuery(name="GET_BUNDLE_ACTIONS_FAILED_NULL_COORD_COUNT", query="select count(w) from BundleActionBean w where w.bundleId = :bundleId AND w.statusStr = 'FAILED' AND w.coordId IS NULL"), @NamedQuery(name="GET_BUNDLE_ACTIONS_OLDER_THAN", query="select OBJECT(w) from BundleActionBean w order by w.lastModifiedTimestamp"), @NamedQuery(name="DELETE_COMPLETED_ACTIONS_FOR_BUNDLE", query="delete from BundleActionBean a where a.bundleId = :bundleId and (a.statusStr = 'SUCCEEDED' OR a.statusStr = 'FAILED' OR a.statusStr= 'KILLED' OR a.statusStr = 'DONEWITHERROR')"), @NamedQuery(name="DELETE_ACTIONS_FOR_BUNDLE", query="delete from BundleActionBean a where a.bundleId = :bundleId")})
public class BundleActionBean
implements Writable,
JsonBean,
PersistenceCapable {
    @Id
    @Column(name="bundle_action_id")
    private String bundleActionId = null;
    @Index
    @Column(name="bundle_id")
    private String bundleId = null;
    @Column(name="coord_name")
    private String coordName = null;
    @Basic
    @Column(name="coord_id")
    private String coordId = null;
    @Basic
    @Column(name="status")
    private String statusStr = null;
    @Basic
    @Column(name="critical")
    private int critical = 0;
    @Basic
    @Column(name="pending")
    private int pending = 0;
    @Basic
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$Lorg$apache$oozie$BundleActionBean;
    private transient Object pcDetachedState;

    public void setBundleActionId(String bundleActionId) {
        BundleActionBean.pcSetbundleActionId(this, bundleActionId);
    }

    public String getBundleActionId() {
        return BundleActionBean.pcGetbundleActionId(this);
    }

    public String getBundleId() {
        return BundleActionBean.pcGetbundleId(this);
    }

    public void setBundleId(String bundleId) {
        BundleActionBean.pcSetbundleId(this, bundleId);
    }

    public String getCoordName() {
        return BundleActionBean.pcGetcoordName(this);
    }

    public void setCoordName(String coordName) {
        BundleActionBean.pcSetcoordName(this, coordName);
    }

    public String getCoordId() {
        return BundleActionBean.pcGetcoordId(this);
    }

    public void setCoordId(String coordId) {
        BundleActionBean.pcSetcoordId(this, coordId);
    }

    public Job.Status getStatus() {
        return Job.Status.valueOf((String)BundleActionBean.pcGetstatusStr(this));
    }

    public String getStatusStr() {
        return BundleActionBean.pcGetstatusStr(this);
    }

    public void setStatusStr(String statusStr) {
        BundleActionBean.pcSetstatusStr(this, statusStr);
    }

    public void setStatus(Job.Status val) {
        BundleActionBean.pcSetstatusStr(this, val.toString());
    }

    public void setCritical() {
        BundleActionBean.pcSetcritical(this, 1);
    }

    public void resetCritical() {
        BundleActionBean.pcSetcritical(this, 0);
    }

    public boolean isCritical() {
        return BundleActionBean.pcGetcritical(this) == 1;
    }

    public void setPending(int pending) {
        BundleActionBean.pcSetpending(this, pending);
    }

    public int incrementAndGetPending() {
        BundleActionBean bundleActionBean = this;
        BundleActionBean.pcSetpending(bundleActionBean, BundleActionBean.pcGetpending(bundleActionBean) + 1);
        return BundleActionBean.pcGetpending(this);
    }

    public int decrementAndGetPending() {
        BundleActionBean.pcSetpending(this, Math.max(BundleActionBean.pcGetpending(this) - 1, 0));
        return BundleActionBean.pcGetpending(this);
    }

    public int getPending() {
        return BundleActionBean.pcGetpending(this);
    }

    public boolean isPending() {
        return BundleActionBean.pcGetpending(this) > 0;
    }

    public boolean isTerminalStatus() {
        boolean isTerminal = false;
        switch (this.getStatus()) {
            case SUCCEEDED: 
            case FAILED: 
            case KILLED: 
            case DONEWITHERROR: {
                isTerminal = true;
                break;
            }
            default: {
                isTerminal = false;
            }
        }
        return isTerminal;
    }

    public void setLastModifiedTimestamp(Timestamp lastModifiedTimestamp) {
        BundleActionBean.pcSetlastModifiedTimestamp(this, lastModifiedTimestamp);
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        BundleActionBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    public Date getLastModifiedTime() {
        return DateUtils.toDate(BundleActionBean.pcGetlastModifiedTimestamp(this));
    }

    public Timestamp getLastModifiedTimestamp() {
        return BundleActionBean.pcGetlastModifiedTimestamp(this);
    }

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getBundleActionId());
        WritableUtils.writeStr(dataOutput, this.getBundleId());
        WritableUtils.writeStr(dataOutput, this.getCoordName());
        WritableUtils.writeStr(dataOutput, this.getCoordId());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeInt(BundleActionBean.pcGetcritical(this));
        dataOutput.writeInt(BundleActionBean.pcGetpending(this));
        dataOutput.writeLong(this.getLastModifiedTimestamp() != null ? this.getLastModifiedTimestamp().getTime() : -1L);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setBundleActionId(WritableUtils.readStr(dataInput));
        this.setBundleId(WritableUtils.readStr(dataInput));
        this.setCoordName(WritableUtils.readStr(dataInput));
        this.setCoordId(WritableUtils.readStr(dataInput));
        this.setStatus(Job.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        BundleActionBean.pcSetcritical(this, dataInput.readInt());
        BundleActionBean.pcSetpending(this, dataInput.readInt());
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setLastModifiedTime(new Date(d));
        }
    }

    @Override
    public JSONObject toJSONObject() {
        return null;
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        return null;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"bundleActionId", "bundleId", "coordId", "coordName", "critical", "lastModifiedTimestamp", "pending", "statusStr"};
        Class[] classArray = new Class[8];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleActionBean.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleActionBean.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleActionBean.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleActionBean.class$("java.lang.String"));
        classArray[4] = Integer.TYPE;
        Class clazz2 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = BundleActionBean.class$("java.sql.Timestamp"));
        classArray[5] = clazz2;
        classArray[6] = Integer.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = BundleActionBean.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz3 = class$Lorg$apache$oozie$BundleActionBean != null ? class$Lorg$apache$oozie$BundleActionBean : (class$Lorg$apache$oozie$BundleActionBean = BundleActionBean.class$("org.apache.oozie.BundleActionBean"));
        PCRegistry.register((Class)clazz3, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"BundleActionBean", (PersistenceCapable)new BundleActionBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.bundleActionId = null;
        this.bundleId = null;
        this.coordId = null;
        this.coordName = null;
        this.critical = 0;
        this.lastModifiedTimestamp = null;
        this.pending = 0;
        this.statusStr = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        BundleActionBean bundleActionBean = new BundleActionBean();
        if (bl) {
            bundleActionBean.pcClearFields();
        }
        bundleActionBean.pcStateManager = stateManager;
        bundleActionBean.pcCopyKeyFieldsFromObjectId(object);
        return bundleActionBean;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        BundleActionBean bundleActionBean = new BundleActionBean();
        if (bl) {
            bundleActionBean.pcClearFields();
        }
        bundleActionBean.pcStateManager = stateManager;
        return bundleActionBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 8;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bundleActionId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.bundleId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.coordId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.coordName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.critical = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.pending = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.statusStr = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleActionId);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleId);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.coordId);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.coordName);
                return;
            }
            case 4: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.critical);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.pending);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.statusStr);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(BundleActionBean bundleActionBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.bundleActionId = bundleActionBean.bundleActionId;
                return;
            }
            case 1: {
                this.bundleId = bundleActionBean.bundleId;
                return;
            }
            case 2: {
                this.coordId = bundleActionBean.coordId;
                return;
            }
            case 3: {
                this.coordName = bundleActionBean.coordName;
                return;
            }
            case 4: {
                this.critical = bundleActionBean.critical;
                return;
            }
            case 5: {
                this.lastModifiedTimestamp = bundleActionBean.lastModifiedTimestamp;
                return;
            }
            case 6: {
                this.pending = bundleActionBean.pending;
                return;
            }
            case 7: {
                this.statusStr = bundleActionBean.statusStr;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        BundleActionBean bundleActionBean = (BundleActionBean)object;
        if (bundleActionBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(bundleActionBean, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(0 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.bundleActionId = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$BundleActionBean != null ? class$Lorg$apache$oozie$BundleActionBean : (class$Lorg$apache$oozie$BundleActionBean = BundleActionBean.class$("org.apache.oozie.BundleActionBean"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$BundleActionBean != null ? class$Lorg$apache$oozie$BundleActionBean : (class$Lorg$apache$oozie$BundleActionBean = BundleActionBean.class$("org.apache.oozie.BundleActionBean"));
        return new StringId(clazz, this.bundleActionId);
    }

    private static final String pcGetbundleActionId(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.bundleActionId;
        }
        int n = pcInheritedFieldCount + 0;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.bundleActionId;
    }

    private static final void pcSetbundleActionId(BundleActionBean bundleActionBean, String string) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.bundleActionId = string;
            return;
        }
        bundleActionBean.pcStateManager.settingStringField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 0, bundleActionBean.bundleActionId, string, 0);
    }

    private static final String pcGetbundleId(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.bundleId;
        }
        int n = pcInheritedFieldCount + 1;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.bundleId;
    }

    private static final void pcSetbundleId(BundleActionBean bundleActionBean, String string) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.bundleId = string;
            return;
        }
        bundleActionBean.pcStateManager.settingStringField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 1, bundleActionBean.bundleId, string, 0);
    }

    private static final String pcGetcoordId(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.coordId;
        }
        int n = pcInheritedFieldCount + 2;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.coordId;
    }

    private static final void pcSetcoordId(BundleActionBean bundleActionBean, String string) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.coordId = string;
            return;
        }
        bundleActionBean.pcStateManager.settingStringField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 2, bundleActionBean.coordId, string, 0);
    }

    private static final String pcGetcoordName(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.coordName;
        }
        int n = pcInheritedFieldCount + 3;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.coordName;
    }

    private static final void pcSetcoordName(BundleActionBean bundleActionBean, String string) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.coordName = string;
            return;
        }
        bundleActionBean.pcStateManager.settingStringField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 3, bundleActionBean.coordName, string, 0);
    }

    private static final int pcGetcritical(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.critical;
        }
        int n = pcInheritedFieldCount + 4;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.critical;
    }

    private static final void pcSetcritical(BundleActionBean bundleActionBean, int n) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.critical = n;
            return;
        }
        bundleActionBean.pcStateManager.settingIntField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 4, bundleActionBean.critical, n, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 5;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(BundleActionBean bundleActionBean, Timestamp timestamp) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.lastModifiedTimestamp = timestamp;
            return;
        }
        bundleActionBean.pcStateManager.settingObjectField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 5, (Object)bundleActionBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final int pcGetpending(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.pending;
        }
        int n = pcInheritedFieldCount + 6;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.pending;
    }

    private static final void pcSetpending(BundleActionBean bundleActionBean, int n) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.pending = n;
            return;
        }
        bundleActionBean.pcStateManager.settingIntField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 6, bundleActionBean.pending, n, 0);
    }

    private static final String pcGetstatusStr(BundleActionBean bundleActionBean) {
        if (bundleActionBean.pcStateManager == null) {
            return bundleActionBean.statusStr;
        }
        int n = pcInheritedFieldCount + 7;
        bundleActionBean.pcStateManager.accessingField(n);
        return bundleActionBean.statusStr;
    }

    private static final void pcSetstatusStr(BundleActionBean bundleActionBean, String string) {
        if (bundleActionBean.pcStateManager == null) {
            bundleActionBean.statusStr = string;
            return;
        }
        bundleActionBean.pcStateManager.settingStringField((PersistenceCapable)bundleActionBean, pcInheritedFieldCount + 7, bundleActionBean.statusStr, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

