/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.TransitionXCommand;

public abstract class PauseTransitionXCommand
extends TransitionXCommand<Void> {
    public PauseTransitionXCommand(String name, String type, int priority) {
        super(name, type, priority);
    }

    public abstract void pauseChildren() throws CommandException;

    @Override
    public final void transitToNext() throws CommandException {
        if (this.job == null) {
            this.job = this.getJob();
        }
        if (this.job.getStatus() == Job.Status.RUNNING) {
            this.job.setStatus(Job.Status.PAUSED);
        } else if (this.job.getStatus() == Job.Status.RUNNINGWITHERROR) {
            this.job.setStatus(Job.Status.PAUSEDWITHERROR);
        } else if (this.job.getStatus() == Job.Status.PREP) {
            this.job.setStatus(Job.Status.PREPPAUSED);
        } else {
            throw new CommandException(ErrorCode.E1315, this.job.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute() throws CommandException {
        try {
            this.transitToNext();
            this.updateJob();
            this.pauseChildren();
        }
        finally {
            this.notifyParent();
        }
        return null;
    }
}

