/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordActionNotificationXCommand;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordinatorCommand;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.store.CoordinatorStore;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.util.db.SLADbOperations;
import org.jdom.Element;

public class CoordActionMaterializeCommand
extends CoordinatorCommand<Void> {
    private String jobId;
    private Date startTime;
    private Date endTime;
    private int lastActionNumber = 1;
    private final XLog log = XLog.getLog(this.getClass());
    private String user;
    private String group;
    private List<JsonBean> insertList = new ArrayList<JsonBean>();
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    public static final String CONF_DEFAULT_TIMEOUT_CATCHUP = "oozie.service.coord.catchup.default.timeout";

    public CoordActionMaterializeCommand(String jobId, Date startTime, Date endTime) {
        super("coord_action_mater", "coord_action_mater", 1, 1, false);
        this.jobId = jobId;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    protected Void call(CoordinatorStore store) throws CommandException {
        CoordinatorJobBean job;
        CoordJobGetJPAExecutor getCoordJob = new CoordJobGetJPAExecutor(this.jobId);
        try {
            job = Services.get().get(JPAService.class).execute(getCoordJob);
        }
        catch (JPAExecutorException jex) {
            throw new CommandException(jex);
        }
        this.setLogInfo(job);
        if (job.getLastActionTime() != null && job.getLastActionTime().compareTo(this.endTime) >= 0) {
            this.log.info("ENDED Coordinator materialization for jobId = " + this.jobId + " Action is *already* materialized for Materialization start time = " + this.startTime + " : Materialization end time = " + this.endTime + " Job status = " + job.getStatusStr());
            return null;
        }
        if (this.endTime.after(job.getEndTime())) {
            this.log.info("ENDED Coordinator materialization for jobId = " + this.jobId + " Materialization end time = " + this.endTime + " surpasses coordinator job's end time = " + job.getEndTime() + " Job status = " + job.getStatusStr());
            return null;
        }
        if (job.getPauseTime() != null && !this.startTime.before(job.getPauseTime())) {
            this.log.info("ENDED Coordinator materialization for jobId = " + this.jobId + " Materialization start time = " + this.startTime + " is after or equal to coordinator job's pause time = " + job.getPauseTime() + " Job status = " + job.getStatusStr());
            if (job.getStatus() == Job.Status.PREMATER) {
                job.setStatus(Job.Status.RUNNING);
            }
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_STATUS, job));
            return null;
        }
        this.user = job.getUser();
        this.group = job.getGroup();
        if (job.getStatus().equals((Object)Job.Status.PREMATER)) {
            XConfiguration jobConf = null;
            this.log.debug("start job :" + this.jobId + " Materialization ");
            try {
                jobConf = new XConfiguration(new StringReader(job.getConf()));
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Configuration parse error. read from DB :" + job.getConf()), ioe);
                throw new CommandException(ErrorCode.E1005, ioe.getMessage(), ioe);
            }
            try {
                this.materializeJobs(false, job, jobConf, store);
                this.updateJobTable(job, store);
            }
            catch (CommandException ex) {
                this.log.warn("Exception occurs:" + ex + " Making the job failed ");
                job.setStatus(Job.Status.FAILED);
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_MATERIALIZE, job));
            }
            catch (Exception e) {
                this.log.error((Object)"Excepion thrown :", e);
                throw new CommandException(ErrorCode.E1001, e.getMessage(), e);
            }
        } else {
            this.log.info("WARN: action is not in PREMATER state!  It's in state=" + job.getStatus());
        }
        return null;
    }

    protected String materializeJobs(boolean dryrun, CoordinatorJobBean jobBean, Configuration conf, CoordinatorStore store) throws Exception {
        String jobXml = jobBean.getJobXml();
        Element eJob = XmlUtils.parseXml(jobXml);
        TimeZone appTz = DateUtils.getTimeZone(jobBean.getTimeZone());
        int frequency = Integer.valueOf(jobBean.getFrequency());
        TimeUnit freqTU = TimeUnit.valueOf(eJob.getAttributeValue("freq_timeunit"));
        TimeUnit endOfFlag = TimeUnit.valueOf(eJob.getAttributeValue("end_of_duration"));
        Calendar start = Calendar.getInstance(appTz);
        start.setTime(this.startTime);
        DateUtils.moveToEnd(start, endOfFlag);
        Calendar end = Calendar.getInstance(appTz);
        end.setTime(this.endTime);
        this.lastActionNumber = jobBean.getLastActionNumber();
        this.log.info("   *** materialize Actions for tz=" + appTz.getDisplayName() + ",\n start=" + start.getTime() + ", end=" + end.getTime() + "\n TimeUNIT " + freqTU.getCalendarUnit() + " Frequency :" + frequency + ":" + (Object)((Object)freqTU) + " lastActionNumber " + this.lastActionNumber);
        Calendar origStart = Calendar.getInstance(appTz);
        origStart.setTime(jobBean.getStartTimestamp());
        DateUtils.moveToEnd(origStart, endOfFlag);
        Calendar effStart = (Calendar)origStart.clone();
        effStart.add(freqTU.getCalendarUnit(), this.lastActionNumber * frequency);
        String action = null;
        StringBuilder actionStrings = new StringBuilder();
        Date jobPauseTime = jobBean.getPauseTime();
        Calendar pause = null;
        if (jobPauseTime != null) {
            pause = Calendar.getInstance(appTz);
            pause.setTime(DateUtils.convertDateToTimestamp(jobPauseTime));
        }
        while (effStart.compareTo(end) < 0 && (pause == null || effStart.compareTo(pause) < 0)) {
            CoordinatorActionBean actionBean = new CoordinatorActionBean();
            ++this.lastActionNumber;
            int timeout = jobBean.getTimeout();
            this.log.debug(origStart.getTime() + " Materializing action for time=" + effStart.getTime() + ", lastactionnumber=" + this.lastActionNumber);
            Date actualTime = new Date();
            action = CoordCommandUtils.materializeOneInstance(this.jobId, dryrun, (Element)eJob.clone(), effStart.getTime(), actualTime, this.lastActionNumber, conf, actionBean);
            int catchUpTOMultiplier = 1;
            if (actionBean.getNominalTimestamp().before(jobBean.getCreatedTimestamp())) {
                timeout = catchUpTOMultiplier * timeout;
                this.log.info("Catchup timeout is :" + actionBean.getTimeOut());
            }
            actionBean.setTimeOut(timeout);
            if (!dryrun) {
                this.storeToDB(actionBean, action, store, jobBean.getAppName());
            } else {
                actionStrings.append("action for new instance");
                actionStrings.append(action);
            }
            effStart = (Calendar)origStart.clone();
            effStart.add(freqTU.getCalendarUnit(), this.lastActionNumber * frequency);
        }
        this.endTime = new Date(effStart.getTimeInMillis());
        if (!dryrun) {
            return action;
        }
        return actionStrings.toString();
    }

    private void storeToDB(CoordinatorActionBean actionBean, String actionXml, CoordinatorStore store, String appName) throws Exception {
        this.log.debug("In storeToDB() action Id " + actionBean.getId() + " Size of actionXml " + actionXml.length());
        actionBean.setActionXml(actionXml);
        this.insertList.add(actionBean);
        this.createActionRegistration(actionXml, actionBean, store, appName);
        this.queueCallable(new CoordActionNotificationXCommand(actionBean), 100L);
        this.queueCallable(new CoordActionInputCheckXCommand(actionBean.getId(), actionBean.getJobId()), 100L);
    }

    private void createActionRegistration(String actionXml, CoordinatorActionBean actionBean, CoordinatorStore store, String appName) throws Exception {
        Element eAction = XmlUtils.parseXml(actionXml);
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        SLAEventBean slaEvent = SLADbOperations.createSlaRegistrationEvent(eSla, store, actionBean.getId(), SLAEvent.SlaAppType.COORDINATOR_ACTION, this.user, this.group);
        if (slaEvent != null) {
            this.insertList.add(slaEvent);
        }
        SLAOperations.createSlaRegistrationEvent(eSla, actionBean.getId(), actionBean.getJobId(), AppType.COORDINATOR_ACTION, this.user, appName, this.log, false);
    }

    private void updateJobTable(CoordinatorJobBean job, CoordinatorStore store) {
        job.setLastActionTime(this.endTime);
        job.setLastActionNumber(this.lastActionNumber);
        Date jobEndTime = job.getEndTime();
        if (jobEndTime.compareTo(this.endTime) <= 0) {
            job.setStatus(Job.Status.SUCCEEDED);
            this.log.info("[" + job.getId() + "]: Update status from PREMATER to SUCCEEDED");
        } else {
            job.setStatus(Job.Status.RUNNING);
            this.log.info("[" + job.getId() + "]: Update status from PREMATER to RUNNING");
        }
        job.setNextMaterializedTime(this.endTime);
        this.updateList.add(new BatchQueryExecutor.UpdateEntry<CoordJobQueryExecutor.CoordJobQuery>(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_MATERIALIZE, job));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void execute(CoordinatorStore store) throws StoreException, CommandException {
        block9: {
            this.log.info("STARTED CoordActionMaterializeCommand for jobId=" + this.jobId + ", startTime=" + this.startTime + ", endTime=" + this.endTime);
            try {
                if (this.lock(this.jobId)) {
                    this.call(store);
                    JPAService jpaService = Services.get().get(JPAService.class);
                    if (jpaService != null) {
                        try {
                            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(this.insertList, this.updateList, null);
                            break block9;
                        }
                        catch (JPAExecutorException je) {
                            throw new CommandException(je);
                        }
                    }
                    throw new CommandException(ErrorCode.E0610, new Object[0]);
                }
                this.queueCallable(new CoordActionMaterializeCommand(this.jobId, this.startTime, this.endTime), 30000L);
                this.log.warn("CoordActionMaterializeCommand lock was not acquired - failed jobId=" + this.jobId + ". Requeing the same.");
            }
            catch (InterruptedException e) {
                this.queueCallable(new CoordActionMaterializeCommand(this.jobId, this.startTime, this.endTime), 30000L);
                this.log.warn("CoordActionMaterializeCommand lock acquiring failed with exception " + e.getMessage() + " for jobId=" + this.jobId + " Requeing the same.");
            }
            finally {
                this.log.info(" ENDED CoordActionMaterializeCommand for jobId=" + this.jobId + ", startTime=" + this.startTime + ", endTime=" + this.endTime);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        new Services().init();
        try {
            Date startTime = DateUtils.parseDateUTC("2009-02-01T01:00Z");
            Date endTime = DateUtils.parseDateUTC("2009-02-02T01:00Z");
            String jobId = "0000000-091207151850551-oozie-dani-C";
            CoordActionMaterializeCommand matCmd = new CoordActionMaterializeCommand(jobId, startTime, endTime);
            matCmd.call();
        }
        finally {
            try {
                Thread.sleep(60000L);
            }
            catch (Exception exception) {}
            new Services().destroy();
        }
    }
}

