/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.BundleJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.store.StoreStatusFilter;
import org.apache.oozie.util.ParamChecker;
import org.apache.openjpa.persistence.OpenJPAPersistence;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.jdbc.FetchDirection;
import org.apache.openjpa.persistence.jdbc.JDBCFetchPlan;
import org.apache.openjpa.persistence.jdbc.LRSSizeAlgorithm;
import org.apache.openjpa.persistence.jdbc.ResultSetType;

public class BundleJobInfoGetJPAExecutor
implements JPAExecutor<BundleJobInfo> {
    private Map<String, List<String>> filter;
    private int start = 1;
    private int len = 50;

    public BundleJobInfoGetJPAExecutor(Map<String, List<String>> filter, int start, int len) {
        ParamChecker.notNull(filter, "filter");
        this.filter = filter;
        this.start = start;
        this.len = len;
    }

    @Override
    public String getName() {
        return "BundleJobInfoGetJPAExecutor";
    }

    @Override
    public BundleJobInfo execute(EntityManager em) throws JPAExecutorException {
        List resultList;
        ArrayList<String> orArray = new ArrayList<String>();
        ArrayList<String> colArray = new ArrayList<String>();
        ArrayList<String> valArray = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("");
        StoreStatusFilter.filter(this.filter, orArray, colArray, valArray, sb, "Select w.id, w.appName, w.appPath, w.conf, w.statusStr, w.kickoffTimestamp, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.createdTimestamp, w.user, w.group, w.timeUnitStr, w.timeOut from BundleJobBean w", "Select count(w) from BundleJobBean w");
        int realLen = 0;
        Query q = null;
        Query qTotal = null;
        if (orArray.size() == 0) {
            q = em.createNamedQuery("GET_BUNDLE_JOBS_COLUMNS");
            q.setFirstResult(this.start - 1);
            q.setMaxResults(this.len);
            qTotal = em.createNamedQuery("GET_BUNDLE_JOBS_COUNT");
        } else {
            StringBuilder sbTotal = new StringBuilder(sb);
            sb.append(" order by w.createdTimestamp desc ");
            q = em.createQuery(sb.toString());
            q.setFirstResult(this.start - 1);
            q.setMaxResults(this.len);
            qTotal = em.createQuery(sbTotal.toString().replace("Select w.id, w.appName, w.appPath, w.conf, w.statusStr, w.kickoffTimestamp, w.startTimestamp, w.endTimestamp, w.pauseTimestamp, w.createdTimestamp, w.user, w.group, w.timeUnitStr, w.timeOut from BundleJobBean w", "Select count(w) from BundleJobBean w"));
        }
        for (int i = 0; i < orArray.size(); ++i) {
            q.setParameter((String)colArray.get(i), valArray.get(i));
            qTotal.setParameter((String)colArray.get(i), valArray.get(i));
        }
        OpenJPAQuery kq = OpenJPAPersistence.cast((Query)q);
        JDBCFetchPlan fetch = (JDBCFetchPlan)kq.getFetchPlan();
        fetch.setFetchBatchSize(20);
        fetch.setResultSetType(ResultSetType.SCROLL_INSENSITIVE);
        fetch.setFetchDirection(FetchDirection.FORWARD);
        fetch.setLRSSizeAlgorithm(LRSSizeAlgorithm.LAST);
        List objectArrList = resultList = q.getResultList();
        ArrayList<BundleJobBean> bundleBeansList = new ArrayList<BundleJobBean>();
        for (Object[] arr : objectArrList) {
            BundleJobBean bean = this.getBeanForBundleJobFromArray(arr);
            bundleBeansList.add(bean);
        }
        realLen = ((Long)qTotal.getSingleResult()).intValue();
        return new BundleJobInfo(bundleBeansList, this.start, this.len, realLen);
    }

    private BundleJobBean getBeanForBundleJobFromArray(Object[] arr) {
        BundleJobBean bean = new BundleJobBean();
        bean.setId((String)arr[0]);
        if (arr[1] != null) {
            bean.setAppName((String)arr[1]);
        }
        if (arr[2] != null) {
            bean.setAppPath((String)arr[2]);
        }
        if (arr[3] != null) {
            bean.setConfBlob((StringBlob)arr[3]);
        }
        if (arr[4] != null) {
            bean.setStatus(Job.Status.valueOf((String)((String)arr[4])));
        }
        if (arr[5] != null) {
            bean.setKickoffTime((Timestamp)arr[5]);
        }
        if (arr[6] != null) {
            bean.setStartTime((Timestamp)arr[6]);
        }
        if (arr[7] != null) {
            bean.setEndTime((Timestamp)arr[7]);
        }
        if (arr[8] != null) {
            bean.setPauseTime((Timestamp)arr[8]);
        }
        if (arr[9] != null) {
            bean.setCreatedTime((Timestamp)arr[9]);
        }
        if (arr[10] != null) {
            bean.setUser((String)arr[10]);
        }
        if (arr[11] != null) {
            bean.setGroup((String)arr[11]);
        }
        if (arr[12] != null) {
            bean.setTimeUnit(BundleJob.Timeunit.valueOf((String)((String)arr[12])));
        }
        if (arr[13] != null) {
            bean.setTimeOut((Integer)arr[13]);
        }
        return bean;
    }
}

