/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.StringBlob;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionsSubsetJPAExecutor
implements JPAExecutor<List<CoordinatorActionBean>> {
    private String coordJobId = null;
    private int offset = 1;
    private int len = 50;
    private boolean desc = false;
    private Map<String, List<String>> filterMap;

    public CoordJobGetActionsSubsetJPAExecutor(String coordJobId) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
    }

    public CoordJobGetActionsSubsetJPAExecutor(String coordJobId, Map<String, List<String>> filterMap, int offset, int len, boolean desc) {
        this(coordJobId);
        this.filterMap = filterMap;
        this.offset = offset;
        this.len = len;
        this.desc = desc;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionsSubsetJPAExecutor";
    }

    @Override
    public List<CoordinatorActionBean> execute(EntityManager em) throws JPAExecutorException {
        ArrayList<CoordinatorActionBean> actionList = new ArrayList();
        try {
            if (!Services.get().getConf().getBoolean("oozie.coord.action.get.all.attributes", false)) {
                Query q = em.createNamedQuery("GET_ACTIONS_FOR_COORD_JOB_ORDER_BY_NOMINAL_TIME");
                q = this.setQueryParameters(q, em);
                List actions = q.getResultList();
                for (Object[] a : actions) {
                    CoordinatorActionBean aa = this.getBeanForRunningCoordAction(a);
                    actionList.add(aa);
                }
            } else {
                Query q = em.createNamedQuery("GET_ALL_COLS_FOR_ACTIONS_FOR_COORD_JOB_ORDER_BY_NOMINAL_TIME");
                q = this.setQueryParameters(q, em);
                actionList = q.getResultList();
            }
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return actionList;
    }

    private Query setQueryParameters(Query q, EntityManager em) {
        if (this.filterMap != null) {
            String query = q.toString();
            StringBuilder sbTotal = new StringBuilder(query);
            int offset = query.lastIndexOf("order");
            StringBuilder statusClause = new StringBuilder();
            this.getStatusClause(statusClause, this.filterMap.get("positive"), true);
            this.getStatusClause(statusClause, this.filterMap.get("negative"), false);
            sbTotal.insert(offset, statusClause);
            q = em.createQuery(sbTotal.toString());
        }
        if (this.desc) {
            q = em.createQuery(q.toString().concat(" desc"));
        }
        q.setParameter("jobId", (Object)this.coordJobId);
        q.setFirstResult(this.offset - 1);
        q.setMaxResults(this.len);
        return q;
    }

    private StringBuilder getStatusClause(StringBuilder sb, List<String> filterList, boolean positive) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        boolean isStatus = false;
        if (filterList != null && filterList.size() > 0) {
            for (String statusVal : filterList) {
                if (!isStatus) {
                    if (positive) {
                        sb.append(" and a.statusStr IN ('").append(statusVal).append("'");
                    } else {
                        sb.append(" and a.statusStr NOT IN ('").append(statusVal).append("'");
                    }
                    isStatus = true;
                    continue;
                }
                sb.append(",'").append(statusVal).append("'");
            }
            sb.append(") ");
        }
        return sb;
    }

    private CoordinatorActionBean getBeanForRunningCoordAction(Object[] arr) {
        CoordinatorActionBean bean = new CoordinatorActionBean();
        if (arr[0] != null) {
            bean.setId((String)arr[0]);
        }
        if (arr[1] != null) {
            bean.setActionNumber((Integer)arr[1]);
        }
        if (arr[2] != null) {
            bean.setConsoleUrl((String)arr[2]);
        }
        if (arr[3] != null) {
            bean.setErrorCode((String)arr[3]);
        }
        if (arr[4] != null) {
            bean.setErrorMessage((String)arr[4]);
        }
        if (arr[5] != null) {
            bean.setExternalId((String)arr[5]);
        }
        if (arr[6] != null) {
            bean.setExternalStatus((String)arr[6]);
        }
        if (arr[7] != null) {
            bean.setJobId((String)arr[7]);
        }
        if (arr[8] != null) {
            bean.setTrackerUri((String)arr[8]);
        }
        if (arr[9] != null) {
            bean.setCreatedTime(DateUtils.toDate((Timestamp)arr[9]));
        }
        if (arr[10] != null) {
            bean.setNominalTime(DateUtils.toDate((Timestamp)arr[10]));
        }
        if (arr[11] != null) {
            bean.setStatus(CoordinatorAction.Status.valueOf((String)((String)arr[11])));
        }
        if (arr[12] != null) {
            bean.setLastModifiedTime(DateUtils.toDate((Timestamp)arr[12]));
        }
        if (arr[13] != null) {
            bean.setMissingDependenciesBlob((StringBlob)arr[13]);
        }
        if (arr[14] != null) {
            bean.setPushMissingDependenciesBlob((StringBlob)arr[14]);
        }
        if (arr[15] != null) {
            bean.setTimeOut((Integer)arr[15]);
        }
        return bean;
    }
}

