/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.AuthorizationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.ServletUtilities;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public abstract class BaseJobServlet
extends JsonRestServlet {
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[1];

    public BaseJobServlet(String instrumentationName) {
        super(instrumentationName, RESOURCES_INFO);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobId = this.getResourceName(request);
        request.setAttribute("audit.param", (Object)jobId);
        request.setAttribute("audit.operation", (Object)request.getParameter("action"));
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            auth.authorizeForJob(this.getUser(request), jobId, true);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        String action = request.getParameter("action");
        if (action.equals("start")) {
            this.stopCron();
            this.startJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("resume")) {
            this.stopCron();
            this.resumeJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("suspend")) {
            this.stopCron();
            this.suspendJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("kill")) {
            this.stopCron();
            JSONObject json = this.killJob(request, response);
            this.startCron();
            if (json != null) {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                response.setStatus(200);
            }
        } else if (action.equals("change")) {
            this.stopCron();
            this.changeJob(request, response);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("rerun")) {
            this.validateContentType(request, "application/xml");
            XConfiguration conf = new XConfiguration((InputStream)request.getInputStream());
            this.stopCron();
            String requestUser = this.getUser(request);
            if (!requestUser.equals("?")) {
                conf.set("user.name", requestUser);
            }
            if (conf.get("oozie.wf.application.path") != null) {
                BaseJobServlet.checkAuthorizationForApp(conf);
                JobUtils.normalizeAppPath(conf.get("user.name"), conf.get("group.name"), conf);
            }
            this.reRunJob(request, response, conf);
            this.startCron();
            response.setStatus(200);
        } else if (action.equals("coord-rerun")) {
            this.validateContentType(request, "application/xml");
            this.stopCron();
            JSONObject json = this.reRunJob(request, response, null);
            this.startCron();
            if (json != null) {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                response.setStatus(200);
            }
        } else if (action.equals("bundle-rerun")) {
            this.validateContentType(request, "application/xml");
            this.stopCron();
            JSONObject json = this.reRunJob(request, response, null);
            this.startCron();
            if (json != null) {
                this.sendJsonResponse(response, 200, (JSONStreamAware)json);
            } else {
                response.setStatus(200);
            }
        } else {
            throw new XServletException(400, ErrorCode.E0303, "action", action);
        }
    }

    static void checkAuthorizationForApp(Configuration conf) throws XServletException {
        String user = conf.get("user.name");
        String acl = ConfigUtils.getWithDeprecatedCheck(conf, "group.name", "oozie.job.acl", null);
        try {
            if (user == null) {
                throw new XServletException(400, ErrorCode.E0401, "user.name");
            }
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            if (acl != null) {
                conf.set("group.name", acl);
            } else if (acl == null && auth.useDefaultGroupAsAcl()) {
                acl = auth.getDefaultGroup(user);
                conf.set("group.name", acl);
            }
            XLog.Info.get().setParameter("GROUP", acl);
            String wfPath = conf.get("oozie.wf.application.path");
            String coordPath = conf.get("oozie.coord.application.path");
            String bundlePath = conf.get("oozie.bundle.application.path");
            if (wfPath == null && coordPath == null && bundlePath == null) {
                String[] libPaths = conf.getStrings("oozie.libpath");
                if (libPaths != null && libPaths.length > 0 && libPaths[0].trim().length() > 0) {
                    conf.set("oozie.wf.application.path", libPaths[0].trim());
                    wfPath = libPaths[0].trim();
                } else {
                    throw new XServletException(400, ErrorCode.E0405, new Object[0]);
                }
            }
            ServletUtilities.ValidateAppPath(wfPath, coordPath, bundlePath);
            if (wfPath != null) {
                auth.authorizeForApp(user, acl, wfPath, "workflow.xml", conf);
            } else if (coordPath != null) {
                auth.authorizeForApp(user, acl, coordPath, "coordinator.xml", conf);
            } else if (bundlePath != null) {
                auth.authorizeForApp(user, acl, bundlePath, "bundle.xml", conf);
            }
        }
        catch (AuthorizationException ex) {
            XLog.getLog(BaseJobServlet.class).info((Object)"AuthorizationException ", ex);
            throw new XServletException(401, ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String jobId = this.getResourceName(request);
        String show = request.getParameter("show");
        String timeZoneId = request.getParameter("timezone") == null ? "GMT" : request.getParameter("timezone");
        try {
            AuthorizationService auth = Services.get().get(AuthorizationService.class);
            auth.authorizeForJob(this.getUser(request), jobId, false);
        }
        catch (AuthorizationException ex) {
            throw new XServletException(401, ex);
        }
        if (show == null || show.equals("info")) {
            this.stopCron();
            JsonBean job = null;
            try {
                job = this.getJob(request, response);
            }
            catch (BaseEngineException e) {
                throw new XServletException(400, e);
            }
            this.startCron();
            this.sendJsonResponse(response, 200, job, timeZoneId);
        } else if (show.equals("allruns")) {
            this.stopCron();
            JSONObject json = this.getJobsByParentId(request, response);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (show.equals("jmstopic")) {
            this.stopCron();
            String jmsTopicName = this.getJMSTopicName(request, response);
            JSONObject json = new JSONObject();
            json.put((Object)"jmsTopicName", (Object)jmsTopicName);
            this.startCron();
            this.sendJsonResponse(response, 200, (JSONStreamAware)json);
        } else if (show.equals("log")) {
            response.setContentType("text/plain; charset=\"UTF-8\"");
            this.streamJobLog(request, response);
        } else if (show.equals("definition")) {
            this.stopCron();
            response.setContentType("application/xml; charset=\"UTF-8\"");
            String wfDefinition = this.getJobDefinition(request, response);
            this.startCron();
            response.setStatus(200);
            response.getWriter().write(wfDefinition);
        } else if (show.equals("graph")) {
            this.stopCron();
            this.streamJobGraph(request, response);
            this.startCron();
        } else {
            throw new XServletException(400, ErrorCode.E0303, "show", show);
        }
    }

    abstract void startJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void resumeJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void suspendJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject killJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void changeJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject reRunJob(HttpServletRequest var1, HttpServletResponse var2, Configuration var3) throws XServletException, IOException;

    abstract JsonBean getJob(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException, BaseEngineException;

    abstract String getJobDefinition(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void streamJobLog(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract void streamJobGraph(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract String getJMSTopicName(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    abstract JSONObject getJobsByParentId(HttpServletRequest var1, HttpServletResponse var2) throws XServletException, IOException;

    static {
        BaseJobServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("*", Arrays.asList("PUT", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("action", String.class, true, Arrays.asList("PUT")), new JsonRestServlet.ParameterInfo("show", String.class, false, Arrays.asList("GET")), new JsonRestServlet.ParameterInfo("order", String.class, false, Arrays.asList("GET"))));
    }
}

