/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreFS;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class Warehouse {
    private Path whRoot;
    private final Configuration conf;
    private final String whRootString;
    public static final Log LOG = LogFactory.getLog((String)"hive.metastore.warehouse");
    private MetaStoreFS fsHandler = null;
    private boolean storageAuthCheck = false;
    static final Pattern pat = Pattern.compile("([^/]+)=([^/]+)");
    private static final Pattern slash = Pattern.compile("/");

    public Warehouse(Configuration conf) throws MetaException {
        this.conf = conf;
        this.whRootString = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREWAREHOUSE);
        if (StringUtils.isBlank((String)this.whRootString)) {
            throw new MetaException(HiveConf.ConfVars.METASTOREWAREHOUSE.varname + " is not set in the config or blank");
        }
        this.fsHandler = this.getMetaStoreFsHandler(conf);
        this.storageAuthCheck = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_AUTHORIZATION_STORAGE_AUTH_CHECKS);
    }

    private MetaStoreFS getMetaStoreFsHandler(Configuration conf) throws MetaException {
        String handlerClassStr = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_METASTORE_FS_HANDLER_CLS);
        try {
            Class<?> handlerClass = Class.forName(handlerClassStr, true, JavaUtils.getClassLoader());
            MetaStoreFS handler = (MetaStoreFS)ReflectionUtils.newInstance(handlerClass, (Configuration)conf);
            return handler;
        }
        catch (ClassNotFoundException e) {
            throw new MetaException("Error in loading MetaStoreFS handler." + e.getMessage());
        }
    }

    public FileSystem getFs(Path f) throws MetaException {
        try {
            return f.getFileSystem(this.conf);
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    public static void closeFs(FileSystem fs) throws MetaException {
        try {
            if (fs != null) {
                fs.close();
            }
        }
        catch (IOException e) {
            MetaStoreUtils.logAndThrowMetaException(e);
        }
    }

    public Path getDnsPath(Path path) throws MetaException {
        FileSystem fs = this.getFs(path);
        return new Path(fs.getUri().getScheme(), fs.getUri().getAuthority(), path.toUri().getPath());
    }

    public Path getWhRoot() throws MetaException {
        if (this.whRoot != null) {
            return this.whRoot;
        }
        this.whRoot = this.getDnsPath(new Path(this.whRootString));
        return this.whRoot;
    }

    public Path getTablePath(String whRootString, String tableName) throws MetaException {
        Path whRoot = this.getDnsPath(new Path(whRootString));
        return new Path(whRoot, tableName.toLowerCase());
    }

    public Path getDatabasePath(Database db) throws MetaException {
        if (db.getName().equalsIgnoreCase("default")) {
            return this.getWhRoot();
        }
        return new Path(db.getLocationUri());
    }

    public Path getDefaultDatabasePath(String dbName) throws MetaException {
        if (dbName.equalsIgnoreCase("default")) {
            return this.getWhRoot();
        }
        return new Path(this.getWhRoot(), dbName.toLowerCase() + ".db");
    }

    public Path getTablePath(Database db, String tableName) throws MetaException {
        return this.getDnsPath(new Path(this.getDatabasePath(db), tableName.toLowerCase()));
    }

    public boolean mkdirs(Path f, boolean inheritPermCandidate) throws MetaException {
        boolean inheritPerms = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_WAREHOUSE_SUBDIR_INHERIT_PERMS) && inheritPermCandidate;
        FileSystem fs = null;
        try {
            fs = this.getFs(f);
            return FileUtils.mkdir((FileSystem)fs, (Path)f, (boolean)inheritPerms, (Configuration)this.conf);
        }
        catch (IOException e) {
            Warehouse.closeFs(fs);
            MetaStoreUtils.logAndThrowMetaException(e);
            return false;
        }
    }

    public boolean renameDir(Path sourcePath, Path destPath) throws MetaException {
        return this.renameDir(sourcePath, destPath, false);
    }

    public boolean renameDir(Path sourcePath, Path destPath, boolean inheritPerms) throws MetaException {
        try {
            FileSystem fs = this.getFs(sourcePath);
            return FileUtils.renameWithPerms((FileSystem)fs, (Path)sourcePath, (Path)destPath, (boolean)inheritPerms, (Configuration)this.conf);
        }
        catch (Exception ex) {
            MetaStoreUtils.logAndThrowMetaException(ex);
            return false;
        }
    }

    public boolean deleteDir(Path f, boolean recursive) throws MetaException {
        FileSystem fs = this.getFs(f);
        return this.fsHandler.deleteDir(fs, f, recursive, this.conf);
    }

    public boolean isEmpty(Path path) throws IOException, MetaException {
        ContentSummary contents = this.getFs(path).getContentSummary(path);
        return contents != null && contents.getFileCount() == 0L && contents.getDirectoryCount() == 1L;
    }

    public boolean isWritable(Path path) throws IOException {
        Object[] groups;
        UserGroupInformation ugi;
        FileStatus stat;
        if (!this.storageAuthCheck) {
            return true;
        }
        if (path == null) {
            return false;
        }
        try {
            stat = this.getFs(path).getFileStatus(path);
        }
        catch (FileNotFoundException fnfe) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        try {
            ugi = ShimLoader.getHadoopShims().getUGIForConf(this.conf);
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
        String user = ShimLoader.getHadoopShims().getShortUserName(ugi);
        if (stat.getOwner().equals(user) && stat.getPermission().getUserAction().implies(FsAction.WRITE)) {
            return true;
        }
        if (stat.getPermission().getGroupAction().implies(FsAction.WRITE) && ArrayUtils.contains((Object[])(groups = ugi.getGroupNames()), (Object)stat.getGroup())) {
            return true;
        }
        return stat.getPermission().getOtherAction().implies(FsAction.WRITE);
    }

    static String escapePathName(String path) {
        return FileUtils.escapePathName((String)path);
    }

    static String unescapePathName(String path) {
        return FileUtils.unescapePathName((String)path);
    }

    public static String makePartPath(Map<String, String> spec) throws MetaException {
        return Warehouse.makePartName(spec, true);
    }

    public static String makePartName(Map<String, String> spec, boolean addTrailingSeperator) throws MetaException {
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() == 0) {
                throw new MetaException("Partition spec is incorrect. " + spec);
            }
            if (i > 0) {
                suffixBuf.append("/");
            }
            suffixBuf.append(Warehouse.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(Warehouse.escapePathName(e.getValue()));
            ++i;
        }
        if (addTrailingSeperator) {
            suffixBuf.append("/");
        }
        return suffixBuf.toString();
    }

    public static String makeDynamicPartName(Map<String, String> spec) {
        StringBuilder suffixBuf = new StringBuilder();
        for (Map.Entry<String, String> e : spec.entrySet()) {
            if (e.getValue() == null || e.getValue().length() <= 0) break;
            suffixBuf.append(Warehouse.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(Warehouse.escapePathName(e.getValue()));
            suffixBuf.append("/");
        }
        return suffixBuf.toString();
    }

    public static void makeValsFromName(String name, AbstractList<String> result) throws MetaException {
        assert (name != null);
        String[] parts = slash.split(name, 0);
        if (parts.length != result.size()) {
            throw new MetaException("Expected " + result.size() + " components, got " + parts.length + " (" + name + ")");
        }
        for (int i = 0; i < parts.length; ++i) {
            int eq = parts[i].indexOf(61);
            if (eq <= 0) {
                throw new MetaException("Unexpected component " + parts[i]);
            }
            result.set(i, Warehouse.unescapePathName(parts[i].substring(eq + 1)));
        }
    }

    public static LinkedHashMap<String, String> makeSpecFromName(String name) throws MetaException {
        if (name == null || name.isEmpty()) {
            throw new MetaException("Partition name is invalid. " + name);
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        Warehouse.makeSpecFromName(partSpec, new Path(name));
        return partSpec;
    }

    public static void makeSpecFromName(Map<String, String> partSpec, Path currPath) {
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        do {
            String component;
            Matcher m;
            if (!(m = pat.matcher(component = currPath.getName())).matches()) continue;
            String k = Warehouse.unescapePathName(m.group(1));
            String v = Warehouse.unescapePathName(m.group(2));
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            partSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
    }

    public static Map<String, String> makeEscSpecFromName(String name) throws MetaException {
        if (name == null || name.isEmpty()) {
            throw new MetaException("Partition name is invalid. " + name);
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        Path currPath = new Path(name);
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        do {
            String component;
            Matcher m;
            if (!(m = pat.matcher(component = currPath.getName())).matches()) continue;
            String k = m.group(1);
            String v = m.group(2);
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            partSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
        return partSpec;
    }

    public Path getPartitionPath(Database db, String tableName, LinkedHashMap<String, String> pm) throws MetaException {
        return new Path(this.getTablePath(db, tableName), Warehouse.makePartPath(pm));
    }

    public Path getPartitionPath(Path tblPath, LinkedHashMap<String, String> pm) throws MetaException {
        return new Path(tblPath, Warehouse.makePartPath(pm));
    }

    public boolean isDir(Path f) throws MetaException {
        FileSystem fs = null;
        try {
            fs = this.getFs(f);
            FileStatus fstatus = fs.getFileStatus(f);
            if (!fstatus.isDir()) {
                return false;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            Warehouse.closeFs(fs);
            MetaStoreUtils.logAndThrowMetaException(e);
        }
        return true;
    }

    public static String makePartName(List<FieldSchema> partCols, List<String> vals) throws MetaException {
        return Warehouse.makePartName(partCols, vals, null);
    }

    public FileStatus[] getFileStatusesForSD(StorageDescriptor desc) throws MetaException {
        try {
            Path path = new Path(desc.getLocation());
            FileSystem fileSys = path.getFileSystem(this.conf);
            return HiveStatsUtils.getFileStatusRecurse((Path)path, (int)-1, (FileSystem)fileSys);
        }
        catch (IOException ioe) {
            MetaStoreUtils.logAndThrowMetaException(ioe);
            return null;
        }
    }

    public FileStatus[] getFileStatusesForUnpartitionedTable(Database db, Table table) throws MetaException {
        Path tablePath = this.getTablePath(db, table.getTableName());
        try {
            FileSystem fileSys = tablePath.getFileSystem(this.conf);
            return HiveStatsUtils.getFileStatusRecurse((Path)tablePath, (int)-1, (FileSystem)fileSys);
        }
        catch (IOException ioe) {
            MetaStoreUtils.logAndThrowMetaException(ioe);
            return null;
        }
    }

    public static String makePartName(List<FieldSchema> partCols, List<String> vals, String defaultStr) throws MetaException {
        if (partCols.size() != vals.size() || partCols.size() == 0) {
            String errorStr = "Invalid partition key & values; keys [";
            for (FieldSchema fs : partCols) {
                errorStr = errorStr + fs.getName() + ", ";
            }
            errorStr = errorStr + "], values [";
            for (String val : vals) {
                errorStr = errorStr + val + ", ";
            }
            throw new MetaException(errorStr + "]");
        }
        ArrayList<String> colNames = new ArrayList<String>();
        for (FieldSchema col : partCols) {
            colNames.add(col.getName());
        }
        return FileUtils.makePartName(colNames, vals, (String)defaultStr);
    }

    public static List<String> getPartValuesFromPartName(String partName) throws MetaException {
        LinkedHashMap<String, String> partSpec = Warehouse.makeSpecFromName(partName);
        ArrayList<String> values = new ArrayList<String>();
        values.addAll(partSpec.values());
        return values;
    }
}

