/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.wizard.ui.xul;

import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.DefaultWizardDesignTimeContext;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.LinearWizardController;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardContentPanel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.DataSourceAndQueryStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.FormatStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LayoutStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LookAndFeelStep;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.swing.SwingXulLoader;
import org.pentaho.ui.xul.swing.SwingXulRunner;

public class StandaloneWizard {
    private static final String MAIN_WIZARD_PANEL = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/main_wizard_panel.xul";
    private LinearWizardController wizardController = new LinearWizardController(new WizardEditorModel(), (BindingFactory)new DefaultBindingFactory());

    public StandaloneWizard() {
        this.wizardController.addPropertyChangeListener(new CloseListener());
        DataSourceAndQueryStep dataSourceAndQueryStep = new DataSourceAndQueryStep();
        this.wizardController.addStep(new LookAndFeelStep());
        this.wizardController.addStep(dataSourceAndQueryStep);
        this.wizardController.addStep(new LayoutStep());
        this.wizardController.addStep(new FormatStep());
        try {
            XulDomContainer mainWizardContainer = new SwingXulLoader().loadXul(MAIN_WIZARD_PANEL);
            new WizardContentPanel(this.wizardController).addContent(mainWizardContainer);
            this.wizardController.registerMainXULContainer(mainWizardContainer);
            Document documentRoot = mainWizardContainer.getDocumentRoot();
            XulDialog root = (XulDialog)documentRoot.getRootElement();
            Window window = (Window)root.getRootObject();
            DefaultWizardDesignTimeContext designTimeContext = new DefaultWizardDesignTimeContext(this.wizardController.getEditorModel(), window);
            dataSourceAndQueryStep.setDesignTimeContext(designTimeContext);
            this.wizardController.setDesignTimeContext(designTimeContext);
            SwingXulRunner runner = new SwingXulRunner();
            runner.addContainer(mainWizardContainer);
            runner.initialize();
            runner.start();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(null, (String)"Error", (String)e.getMessage(), (Exception)e);
        }
    }

    public static void main(String[] args) {
        ClassicEngineBoot.getInstance().start();
        new StandaloneWizard();
    }

    private class CloseListener
    implements PropertyChangeListener {
        private CloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (StandaloneWizard.this.wizardController.isCancelled() || StandaloneWizard.this.wizardController.isFinished()) {
                System.exit(0);
            }
        }
    }
}

