/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metastore.stores.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.pentaho.metastore.api.IMetaStoreElementType;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMetaStoreElementType
implements IMetaStoreElementType {
    public static final String XML_TAG = "data-type";
    private String namespace;
    private String id;
    private String name;
    private String description;
    private String metaStoreName;
    private String filename;

    public XmlMetaStoreElementType(String namespace, String id, String name, String description) {
        this.namespace = namespace;
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public XmlMetaStoreElementType(String namespace, String filename) throws MetaStoreException {
        this.namespace = namespace;
        File file = new File(filename);
        this.id = file.getParentFile().getName();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            Element elementTypeElement = document.getDocumentElement();
            this.loadElementType(elementTypeElement);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to load XML metastore element type from file '" + filename + "'", e);
        }
    }

    protected void loadElementType(Node elementTypeNode) {
        NodeList childNodes = elementTypeNode.getChildNodes();
        for (int e = 0; e < childNodes.getLength(); ++e) {
            Node childNode = childNodes.item(e);
            if ("name".equals(childNode.getNodeName())) {
                this.name = XmlUtil.getNodeValue(childNode);
            }
            if (!"description".equals(childNode.getNodeName())) continue;
            this.description = XmlUtil.getNodeValue(childNode);
        }
    }

    @Override
    public void save() throws MetaStoreException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.filename);
            StreamResult result = new StreamResult(fos);
            this.saveToStreamResult(result);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to save XML meta store data type with file '" + this.filename + "'", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    throw new MetaStoreException("Unable to save XML meta store data type with file '" + this.filename + "' (close failed)", e);
                }
            }
        }
    }

    public String getXml() throws MetaStoreException {
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult(stringWriter);
            this.saveToStreamResult(result);
            return result.toString();
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to get XML form of meta store.", e);
        }
    }

    public void saveToStreamResult(StreamResult streamResult) throws MetaStoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element elementTypeElement = doc.createElement(XML_TAG);
            doc.appendChild(elementTypeElement);
            this.appendElementType(doc, elementTypeElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            throw new MetaStoreException("Unable to serialize XML meta store to stream result", e);
        }
    }

    protected void appendElementType(Document doc, Element elementTypeElement) {
        Element nameElement = doc.createElement("name");
        nameElement.appendChild(doc.createTextNode(this.name));
        elementTypeElement.appendChild(nameElement);
        Element descriptionElement = doc.createElement("description");
        descriptionElement.appendChild(doc.createTextNode(this.description));
        elementTypeElement.appendChild(descriptionElement);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getMetaStoreName() {
        return this.metaStoreName;
    }

    @Override
    public void setMetaStoreName(String metaStoreName) {
        this.metaStoreName = metaStoreName;
    }
}

