/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.JaninoRuntimeException;
import org.codehaus.janino.Java;

public class ClassFile {
    private static final int CLASS_FILE_MAGIC = -889275714;
    public static final short MAJOR_VERSION_JDK_1_1 = 45;
    public static final short MINOR_VERSION_JDK_1_1 = 3;
    public static final short MAJOR_VERSION_JDK_1_2 = 46;
    public static final short MINOR_VERSION_JDK_1_2 = 0;
    public static final short MAJOR_VERSION_JDK_1_3 = 47;
    public static final short MINOR_VERSION_JDK_1_3 = 0;
    public static final short MAJOR_VERSION_JDK_1_4 = 48;
    public static final short MINOR_VERSION_JDK_1_4 = 0;
    public static final short MAJOR_VERSION_JDK_1_5 = 49;
    public static final short MINOR_VERSION_JDK_1_5 = 0;
    private short majorVersion;
    private short minorVersion;
    private final List<ConstantPoolInfo> constantPool;
    public final short accessFlags;
    public final short thisClass;
    public final short superclass;
    public final short[] interfaces;
    public final List<FieldInfo> fieldInfos;
    public final List<MethodInfo> methodInfos;
    private final List<AttributeInfo> attributes;
    private final Map<ConstantPoolInfo, Short> constantPoolMap;

    public ClassFile(short accessFlags, String thisClassFd, String superclassFd, String[] interfaceFds) {
        this.majorVersion = (short)45;
        this.minorVersion = (short)3;
        this.constantPool = new ArrayList<ConstantPoolInfo>();
        this.constantPool.add(null);
        this.constantPoolMap = new HashMap<ConstantPoolInfo, Short>();
        this.accessFlags = accessFlags;
        this.thisClass = this.addConstantClassInfo(thisClassFd);
        this.superclass = this.addConstantClassInfo(superclassFd);
        this.interfaces = new short[interfaceFds.length];
        for (int i = 0; i < interfaceFds.length; ++i) {
            this.interfaces[i] = this.addConstantClassInfo(interfaceFds[i]);
        }
        this.fieldInfos = new ArrayList<FieldInfo>();
        this.methodInfos = new ArrayList<MethodInfo>();
        this.attributes = new ArrayList<AttributeInfo>();
    }

    public void addSourceFileAttribute(String sourceFileName) {
        this.attributes.add(new SourceFileAttribute(this.addConstantUtf8Info("SourceFile"), this.addConstantUtf8Info(sourceFileName)));
    }

    public void addDeprecatedAttribute() {
        this.attributes.add(new DeprecatedAttribute(this.addConstantUtf8Info("Deprecated")));
    }

    public InnerClassesAttribute getInnerClassesAttribute() {
        Short ni = this.constantPoolMap.get(new ConstantUtf8Info("InnerClasses"));
        if (ni == null) {
            return null;
        }
        for (AttributeInfo ai : this.attributes) {
            if (ai.nameIndex != ni || !(ai instanceof InnerClassesAttribute)) continue;
            return (InnerClassesAttribute)ai;
        }
        return null;
    }

    public void addInnerClassesAttributeEntry(InnerClassesAttribute.Entry e) {
        InnerClassesAttribute ica = this.getInnerClassesAttribute();
        if (ica == null) {
            ica = new InnerClassesAttribute(this.addConstantUtf8Info("InnerClasses"));
            this.attributes.add(ica);
        }
        ica.getEntries().add(e);
    }

    public ClassFile(InputStream inputStream) throws IOException {
        DataInputStream dis = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        int magic = dis.readInt();
        if (magic != -889275714) {
            throw new ClassFormatError("Invalid magic number");
        }
        this.minorVersion = dis.readShort();
        this.majorVersion = dis.readShort();
        this.constantPool = new ArrayList<ConstantPoolInfo>();
        this.constantPoolMap = new HashMap<ConstantPoolInfo, Short>();
        this.loadConstantPool(dis);
        this.accessFlags = dis.readShort();
        this.thisClass = dis.readShort();
        this.superclass = dis.readShort();
        this.interfaces = ClassFile.readShortArray(dis);
        this.fieldInfos = Collections.unmodifiableList(this.loadFields(dis));
        this.methodInfos = Collections.unmodifiableList(this.loadMethods(dis));
        this.attributes = Collections.unmodifiableList(this.loadAttributes(dis));
    }

    public String getThisClassName() {
        ConstantClassInfo cci = (ConstantClassInfo)this.getConstantPoolInfo(this.thisClass);
        return cci.getName(this).replace('/', '.');
    }

    public void setVersion(short majorVersion, short minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short addConstantClassInfo(String typeFd) {
        String s;
        if (Descriptor.isClassOrInterfaceReference(typeFd)) {
            s = Descriptor.toInternalForm(typeFd);
        } else if (Descriptor.isArrayReference(typeFd)) {
            s = typeFd;
        } else {
            throw new JaninoRuntimeException("\"" + Descriptor.toString(typeFd) + "\" is neither a class nor an array");
        }
        return this.addToConstantPool(new ConstantClassInfo(this.addConstantUtf8Info(s)));
    }

    public short addConstantFieldrefInfo(String classFd, String fieldName, String fieldFd) {
        return this.addToConstantPool(new ConstantFieldrefInfo(this.addConstantClassInfo(classFd), this.addConstantNameAndTypeInfo(fieldName, fieldFd)));
    }

    public short addConstantMethodrefInfo(String classFd, String methodName, String methodMd) {
        return this.addToConstantPool(new ConstantMethodrefInfo(this.addConstantClassInfo(classFd), this.addConstantNameAndTypeInfo(methodName, methodMd)));
    }

    public short addConstantInterfaceMethodrefInfo(String classFd, String methodName, String methodMd) {
        return this.addToConstantPool(new ConstantInterfaceMethodrefInfo(this.addConstantClassInfo(classFd), this.addConstantNameAndTypeInfo(methodName, methodMd)));
    }

    public short addConstantStringInfo(String string) {
        return this.addToConstantPool(new ConstantStringInfo(this.addConstantUtf8Info(string)));
    }

    public short addConstantIntegerInfo(int value) {
        return this.addToConstantPool(new ConstantIntegerInfo(value));
    }

    public short addConstantFloatInfo(float value) {
        return this.addToConstantPool(new ConstantFloatInfo(value));
    }

    public short addConstantLongInfo(long value) {
        return this.addToConstantPool(new ConstantLongInfo(value));
    }

    public short addConstantDoubleInfo(double value) {
        return this.addToConstantPool(new ConstantDoubleInfo(value));
    }

    private short addConstantNameAndTypeInfo(String name, String descriptor) {
        return this.addToConstantPool(new ConstantNameAndTypeInfo(this.addConstantUtf8Info(name), this.addConstantUtf8Info(descriptor)));
    }

    public short addConstantUtf8Info(String s) {
        return this.addToConstantPool(new ConstantUtf8Info(s));
    }

    private short addConstantSIFLDInfo(Object cv) {
        if (cv instanceof String) {
            return this.addConstantStringInfo((String)cv);
        }
        if (cv instanceof Byte || cv instanceof Short || cv instanceof Integer) {
            return this.addConstantIntegerInfo(((Number)cv).intValue());
        }
        if (cv instanceof Boolean) {
            return this.addConstantIntegerInfo((Boolean)cv != false ? 1 : 0);
        }
        if (cv instanceof Character) {
            return this.addConstantIntegerInfo(((Character)cv).charValue());
        }
        if (cv instanceof Float) {
            return this.addConstantFloatInfo(((Float)cv).floatValue());
        }
        if (cv instanceof Long) {
            return this.addConstantLongInfo((Long)cv);
        }
        if (cv instanceof Double) {
            return this.addConstantDoubleInfo((Double)cv);
        }
        throw new JaninoRuntimeException("Unexpected constant value type \"" + cv.getClass().getName() + "\"");
    }

    private short addToConstantPool(ConstantPoolInfo cpi) {
        Short index = this.constantPoolMap.get(cpi);
        if (index != null) {
            return index;
        }
        int res = this.constantPool.size();
        if (res > 65535) {
            throw new JaninoRuntimeException("Constant pool has grown past JVM limit of 0xFFFF");
        }
        this.constantPool.add(cpi);
        if (cpi.isWide()) {
            this.constantPool.add(null);
        }
        this.constantPoolMap.put(cpi, new Short((short)res));
        return (short)res;
    }

    public FieldInfo addFieldInfo(Java.Modifiers modifiers, String fieldName, String fieldTypeFd, Object optionalConstantValue) {
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>();
        if (optionalConstantValue != null) {
            attributes.add(new ConstantValueAttribute(this.addConstantUtf8Info("ConstantValue"), this.addConstantSIFLDInfo(optionalConstantValue)));
        }
        FieldInfo fi = new FieldInfo(modifiers, this.addConstantUtf8Info(fieldName), this.addConstantUtf8Info(fieldTypeFd), attributes);
        this.fieldInfos.add(fi);
        return fi;
    }

    public MethodInfo addMethodInfo(Java.Modifiers modifiers, String methodName, String methodMd) {
        MethodInfo mi = new MethodInfo(modifiers, this.addConstantUtf8Info(methodName), this.addConstantUtf8Info(methodMd), new ArrayList<AttributeInfo>());
        this.methodInfos.add(mi);
        return mi;
    }

    public ConstantPoolInfo getConstantPoolInfo(short index) {
        return this.constantPool.get(0xFFFF & index);
    }

    public int getConstantPoolSize() {
        return this.constantPool.size();
    }

    public String getConstantUtf8(short index) {
        ConstantUtf8Info cui = (ConstantUtf8Info)this.getConstantPoolInfo(index);
        return cui.s;
    }

    private static byte[] readLengthAndBytes(DataInputStream dis) throws IOException {
        byte[] ba = new byte[dis.readInt()];
        dis.readFully(ba);
        return ba;
    }

    private static short[] readShortArray(DataInputStream dis) throws IOException {
        int count = dis.readShort();
        short[] result = new short[count];
        for (int i = 0; i < count; ++i) {
            result[i] = dis.readShort();
        }
        return result;
    }

    private void loadConstantPool(DataInputStream dis) throws IOException {
        this.constantPool.clear();
        this.constantPoolMap.clear();
        short constantPoolCount = dis.readShort();
        this.constantPool.add(null);
        for (short i = 1; i < constantPoolCount; i = (short)(i + 1)) {
            ConstantPoolInfo cpi = ConstantPoolInfo.loadConstantPoolInfo(dis);
            this.constantPool.add(cpi);
            this.constantPoolMap.put(cpi, new Short(i));
            if (!cpi.isWide()) continue;
            this.constantPool.add(null);
            i = (short)(i + 1);
        }
    }

    private List<FieldInfo> loadFields(DataInputStream dis) throws IOException {
        int fieldsCount = dis.readShort();
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>(fieldsCount);
        for (int i = 0; i < fieldsCount; ++i) {
            short mods = dis.readShort();
            short nameIndex = dis.readShort();
            short descIndex = dis.readShort();
            List<AttributeInfo> atts = this.loadAttributes(dis);
            fields.add(new FieldInfo(ClassFile.buildModsAndAnns(mods, atts), nameIndex, descIndex, atts));
        }
        return fields;
    }

    private static Java.Modifiers buildModsAndAnns(short mods, List attributes) {
        return new Java.Modifiers(mods);
    }

    private List<MethodInfo> loadMethods(DataInputStream dis) throws IOException {
        int methodsCount = dis.readShort();
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>(methodsCount);
        for (int i = 0; i < methodsCount; ++i) {
            methods.add(this.loadMethodInfo(dis));
        }
        return methods;
    }

    private List<AttributeInfo> loadAttributes(DataInputStream dis) throws IOException {
        int attributesCount = dis.readShort();
        ArrayList<AttributeInfo> attributes = new ArrayList<AttributeInfo>(attributesCount);
        for (int i = 0; i < attributesCount; ++i) {
            attributes.add(this.loadAttribute(dis));
        }
        return attributes;
    }

    public void store(OutputStream os) throws IOException {
        DataOutputStream dos = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        dos.writeInt(-889275714);
        dos.writeShort(this.minorVersion);
        dos.writeShort(this.majorVersion);
        ClassFile.storeConstantPool(dos, this.constantPool);
        dos.writeShort(this.accessFlags);
        dos.writeShort(this.thisClass);
        dos.writeShort(this.superclass);
        ClassFile.storeShortArray(dos, this.interfaces);
        ClassFile.storeFields(dos, this.fieldInfos);
        ClassFile.storeMethods(dos, this.methodInfos);
        ClassFile.storeAttributes(dos, this.attributes, null);
    }

    private static void storeConstantPool(DataOutputStream dos, List<ConstantPoolInfo> constantPool) throws IOException {
        dos.writeShort(constantPool.size());
        for (int i = 1; i < constantPool.size(); ++i) {
            ConstantPoolInfo cpi = constantPool.get(i);
            if (cpi == null) continue;
            cpi.store(dos);
        }
    }

    private static void storeShortArray(DataOutputStream dos, short[] sa) throws IOException {
        dos.writeShort(sa.length);
        for (short s : sa) {
            dos.writeShort(s);
        }
    }

    private static void storeFields(DataOutputStream dos, List<FieldInfo> fieldInfos) throws IOException {
        dos.writeShort(fieldInfos.size());
        for (int i = 0; i < fieldInfos.size(); ++i) {
            fieldInfos.get(i).store(dos);
        }
    }

    private static void storeMethods(DataOutputStream dos, List<MethodInfo> methodInfos) throws IOException {
        dos.writeShort(methodInfos.size());
        for (int i = 0; i < methodInfos.size(); ++i) {
            methodInfos.get(i).store(dos);
        }
    }

    private static void storeAttributes(DataOutputStream dos, List<AttributeInfo> attributeInfos, Java.Annotation[] annotations) throws IOException {
        dos.writeShort(attributeInfos.size());
        for (int i = 0; i < attributeInfos.size(); ++i) {
            attributeInfos.get(i).store(dos);
        }
    }

    public static String getSourceResourceName(String className) {
        int idx = className.lastIndexOf(46) + 1;
        if ((idx = className.indexOf(36, idx)) != -1) {
            className = className.substring(0, idx);
        }
        return className.replace('.', '/') + ".java";
    }

    public static String getClassFileResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.store(baos);
        }
        catch (IOException ex) {
            throw new JaninoRuntimeException(ex.toString(), ex);
        }
        return baos.toByteArray();
    }

    private MethodInfo loadMethodInfo(DataInputStream dis) throws IOException {
        short mods = dis.readShort();
        short nameIndex = dis.readShort();
        short descIndex = dis.readShort();
        List<AttributeInfo> attributes = this.loadAttributes(dis);
        return new MethodInfo(ClassFile.buildModsAndAnns(mods, attributes), nameIndex, descIndex, attributes);
    }

    private AttributeInfo loadAttribute(DataInputStream dis) throws IOException {
        AttributeInfo result;
        short attributeNameIndex = dis.readShort();
        int attributeLength = dis.readInt();
        final byte[] ba = new byte[attributeLength];
        dis.readFully(ba);
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        DataInputStream bdis = new DataInputStream(bais);
        String attributeName = this.getConstantUtf8(attributeNameIndex);
        if ("ConstantValue".equals(attributeName)) {
            result = ConstantValueAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("Code".equals(attributeName)) {
            result = CodeAttribute.loadBody(attributeNameIndex, this, bdis);
        } else if ("Exceptions".equals(attributeName)) {
            result = ExceptionsAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("InnerClasses".equals(attributeName)) {
            result = InnerClassesAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("Synthetic".equals(attributeName)) {
            result = SyntheticAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("SourceFile".equals(attributeName)) {
            result = SourceFileAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("LineNumberTable".equals(attributeName)) {
            result = LineNumberTableAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("LocalVariableTable".equals(attributeName)) {
            result = LocalVariableTableAttribute.loadBody(attributeNameIndex, bdis);
        } else if ("Deprecated".equals(attributeName)) {
            result = DeprecatedAttribute.loadBody(attributeNameIndex, bdis);
        } else {
            return new AttributeInfo(attributeNameIndex){

                @Override
                protected void storeBody(DataOutputStream dos) throws IOException {
                    dos.write(ba);
                }
            };
        }
        if (bais.available() > 0) {
            throw new ClassFormatError(ba.length - bais.available() + " bytes of trailing garbage in body of attribute \"" + attributeName + "\"");
        }
        return result;
    }

    private static class CodeAttribute
    extends AttributeInfo {
        private final short maxStack;
        private final short maxLocals;
        private final byte[] code;
        private final ExceptionTableEntry[] exceptionTableEntries;
        private final AttributeInfo[] attributes;

        CodeAttribute(short attributeNameIndex, short maxStack, short maxLocals, byte[] code, ExceptionTableEntry[] exceptionTableEntries, AttributeInfo[] attributes) {
            super(attributeNameIndex);
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
            this.code = code;
            this.exceptionTableEntries = exceptionTableEntries;
            this.attributes = attributes;
        }

        public static AttributeInfo loadBody(short attributeNameIndex, ClassFile classFile, DataInputStream dis) throws IOException {
            short maxStack = dis.readShort();
            short maxLocals = dis.readShort();
            byte[] code = ClassFile.readLengthAndBytes(dis);
            ExceptionTableEntry[] etes = new ExceptionTableEntry[dis.readShort()];
            for (int i = 0; i < etes.length; ++i) {
                etes[i] = new ExceptionTableEntry(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
            }
            AttributeInfo[] attributes = new AttributeInfo[dis.readShort()];
            for (int i = 0; i < attributes.length; ++i) {
                attributes[i] = classFile.loadAttribute(dis);
            }
            return new CodeAttribute(attributeNameIndex, maxStack, maxLocals, code, etes, attributes);
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.maxStack);
            dos.writeShort(this.maxLocals);
            dos.writeInt(this.code.length);
            dos.write(this.code);
            dos.writeShort(this.exceptionTableEntries.length);
            for (ExceptionTableEntry ete : this.exceptionTableEntries) {
                dos.writeShort(ete.startPc);
                dos.writeShort(ete.endPc);
                dos.writeShort(ete.handlerPc);
                dos.writeShort(ete.catchType);
            }
            dos.writeShort(this.attributes.length);
            for (AttributeInfo ai : this.attributes) {
                ai.store(dos);
            }
        }

        private static class ExceptionTableEntry {
            final short startPc;
            final short endPc;
            final short handlerPc;
            final short catchType;

            public ExceptionTableEntry(short startPc, short endPc, short handlerPc, short catchType) {
                this.startPc = startPc;
                this.endPc = endPc;
                this.handlerPc = handlerPc;
                this.catchType = catchType;
            }
        }
    }

    public static class DeprecatedAttribute
    extends AttributeInfo {
        public DeprecatedAttribute(short attributeNameIndex) {
            super(attributeNameIndex);
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) {
            return new DeprecatedAttribute(attributeNameIndex);
        }

        @Override
        protected void storeBody(DataOutputStream dos) {
        }
    }

    public static class LocalVariableTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        public LocalVariableTableAttribute(short attributeNameIndex, Entry[] entries) {
            super(attributeNameIndex);
            this.entries = entries;
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            short localVariableTableLength = dis.readShort();
            Entry[] lvtes = new Entry[localVariableTableLength];
            for (short i = 0; i < localVariableTableLength; i = (short)(i + 1)) {
                lvtes[i] = new Entry(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
            }
            return new LocalVariableTableAttribute(attributeNameIndex, lvtes);
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.length);
            for (Entry lnte : this.entries) {
                dos.writeShort(lnte.startPC);
                dos.writeShort(lnte.length);
                dos.writeShort(lnte.nameIndex);
                dos.writeShort(lnte.descriptorIndex);
                dos.writeShort(lnte.index);
            }
        }

        public static class Entry {
            public final short startPC;
            public final short length;
            public final short nameIndex;
            public final short descriptorIndex;
            public final short index;

            public Entry(short startPc, short length, short nameIndex, short descriptorIndex, short index) {
                this.startPC = startPc;
                this.length = length;
                this.nameIndex = nameIndex;
                this.descriptorIndex = descriptorIndex;
                this.index = index;
            }
        }
    }

    public static class LineNumberTableAttribute
    extends AttributeInfo {
        private final Entry[] entries;

        public LineNumberTableAttribute(short attributeNameIndex, Entry[] entries) {
            super(attributeNameIndex);
            this.entries = entries;
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            Entry[] lntes = new Entry[dis.readShort()];
            for (int i = 0; i < lntes.length; i = (int)((short)(i + 1))) {
                lntes[i] = new Entry(dis.readShort(), dis.readShort());
            }
            return new LineNumberTableAttribute(attributeNameIndex, lntes);
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.length);
            for (Entry entry : this.entries) {
                dos.writeShort(entry.startPC);
                dos.writeShort(entry.lineNumber);
            }
        }

        public static class Entry {
            public final int startPC;
            public final int lineNumber;

            public Entry(int startPc, int lineNumber) {
                this.startPC = startPc;
                this.lineNumber = lineNumber;
            }
        }
    }

    public static class SourceFileAttribute
    extends AttributeInfo {
        private final short sourceFileIndex;

        public SourceFileAttribute(short attributeNameIndex, short sourceFileIndex) {
            super(attributeNameIndex);
            this.sourceFileIndex = sourceFileIndex;
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            return new SourceFileAttribute(attributeNameIndex, dis.readShort());
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.sourceFileIndex);
        }
    }

    public static class SyntheticAttribute
    extends AttributeInfo {
        SyntheticAttribute(short attributeNameIndex) {
            super(attributeNameIndex);
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) {
            return new SyntheticAttribute(attributeNameIndex);
        }

        @Override
        protected void storeBody(DataOutputStream dos) {
        }
    }

    public static class InnerClassesAttribute
    extends AttributeInfo {
        private final List<Entry> entries;

        InnerClassesAttribute(short attributeNameIndex) {
            super(attributeNameIndex);
            this.entries = new ArrayList<Entry>();
        }

        InnerClassesAttribute(short attributeNameIndex, Entry[] entries) {
            super(attributeNameIndex);
            this.entries = new ArrayList<Entry>(Arrays.asList(entries));
        }

        public List<Entry> getEntries() {
            return this.entries;
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            Entry[] ics = new Entry[dis.readShort()];
            for (int i = 0; i < ics.length; i = (int)((short)(i + 1))) {
                ics[i] = new Entry(dis.readShort(), dis.readShort(), dis.readShort(), dis.readShort());
            }
            return new InnerClassesAttribute(attributeNameIndex, ics);
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.entries.size());
            for (Entry e : this.entries) {
                dos.writeShort(e.innerClassInfoIndex);
                dos.writeShort(e.outerClassInfoIndex);
                dos.writeShort(e.innerNameIndex);
                dos.writeShort(e.innerClassAccessFlags);
            }
        }

        public static class Entry {
            public final short innerClassInfoIndex;
            public final short outerClassInfoIndex;
            public final short innerNameIndex;
            public final short innerClassAccessFlags;

            public Entry(short innerClassInfoIndex, short outerClassInfoIndex, short innerNameIndex, short innerClassAccessFlags) {
                this.innerClassInfoIndex = innerClassInfoIndex;
                this.outerClassInfoIndex = outerClassInfoIndex;
                this.innerNameIndex = innerNameIndex;
                this.innerClassAccessFlags = innerClassAccessFlags;
            }
        }
    }

    public static class ExceptionsAttribute
    extends AttributeInfo {
        private final short[] exceptionIndexes;

        public ExceptionsAttribute(short attributeNameIndex, short[] exceptionIndexes) {
            super(attributeNameIndex);
            this.exceptionIndexes = exceptionIndexes;
        }

        public ConstantClassInfo[] getExceptions(ClassFile classFile) {
            ConstantClassInfo[] es = new ConstantClassInfo[this.exceptionIndexes.length];
            for (int i = 0; i < es.length; ++i) {
                es[i] = (ConstantClassInfo)classFile.getConstantPoolInfo(this.exceptionIndexes[i]);
            }
            return es;
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            return new ExceptionsAttribute(attributeNameIndex, ClassFile.readShortArray(dis));
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            ClassFile.storeShortArray(dos, this.exceptionIndexes);
        }
    }

    public static class ConstantValueAttribute
    extends AttributeInfo {
        private final short constantValueIndex;

        ConstantValueAttribute(short attributeNameIndex, short constantValueIndex) {
            super(attributeNameIndex);
            this.constantValueIndex = constantValueIndex;
        }

        public ConstantValuePoolInfo getConstantValue(ClassFile classFile) {
            return (ConstantValuePoolInfo)classFile.getConstantPoolInfo(this.constantValueIndex);
        }

        private static AttributeInfo loadBody(short attributeNameIndex, DataInputStream dis) throws IOException {
            return new ConstantValueAttribute(attributeNameIndex, dis.readShort());
        }

        @Override
        protected void storeBody(DataOutputStream dos) throws IOException {
            dos.writeShort(this.constantValueIndex);
        }
    }

    public static abstract class AttributeInfo {
        private final short nameIndex;

        public AttributeInfo(short nameIndex) {
            this.nameIndex = nameIndex;
        }

        public void store(DataOutputStream dos) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.storeBody(new DataOutputStream(baos));
            dos.writeShort(this.nameIndex);
            dos.writeInt(baos.size());
            baos.writeTo(dos);
        }

        protected abstract void storeBody(DataOutputStream var1) throws IOException;
    }

    public static class FieldInfo {
        private final Java.Modifiers modifiers;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List<AttributeInfo> attributes;

        public FieldInfo(Java.Modifiers modifiers, short nameIndex, short descriptorIndex, List<AttributeInfo> attributes) {
            this.modifiers = modifiers;
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.attributes = attributes;
        }

        public short getModifierFlags() {
            return this.modifiers.flags;
        }

        public Java.Annotation[] getAnnotations() {
            return this.modifiers.annotations;
        }

        public String getName(ClassFile classFile) {
            return classFile.getConstantUtf8(this.nameIndex);
        }

        public String getDescriptor(ClassFile classFile) {
            return classFile.getConstantUtf8(this.descriptorIndex);
        }

        public AttributeInfo[] getAttributes() {
            return this.attributes.toArray(new AttributeInfo[this.attributes.size()]);
        }

        public void addAttribute(AttributeInfo attribute) {
            this.attributes.add(attribute);
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeShort(this.modifiers.flags);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dos, this.attributes, this.modifiers.annotations);
        }
    }

    public class MethodInfo {
        private final Java.Modifiers modifiers;
        private final short nameIndex;
        private final short descriptorIndex;
        private final List<AttributeInfo> attributes;

        public MethodInfo(Java.Modifiers modifiers, short nameIndex, short descriptorIndex, List<AttributeInfo> attributes) {
            this.modifiers = modifiers;
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
            this.attributes = attributes;
        }

        public ClassFile getClassFile() {
            return ClassFile.this;
        }

        public short getModifierFlags() {
            return this.modifiers.flags;
        }

        public Java.Annotation[] getAnnotations() {
            return this.modifiers.annotations;
        }

        public String getName() {
            return ClassFile.this.getConstantUtf8(this.nameIndex);
        }

        public String getDescriptor() {
            return ClassFile.this.getConstantUtf8(this.descriptorIndex);
        }

        public AttributeInfo[] getAttributes() {
            return this.attributes.toArray(new AttributeInfo[this.attributes.size()]);
        }

        public void addAttribute(AttributeInfo attribute) {
            this.attributes.add(attribute);
        }

        public void store(DataOutputStream dos) throws IOException {
            dos.writeShort(this.modifiers.flags);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
            ClassFile.storeAttributes(dos, this.attributes, this.modifiers.annotations);
        }
    }

    public static class ConstantUtf8Info
    extends ConstantPoolInfo {
        private final String s;

        public ConstantUtf8Info(String s) {
            if (s == null) {
                throw new JaninoRuntimeException();
            }
            this.s = s;
        }

        public String getString() {
            return this.s;
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(1);
            try {
                dos.writeUTF(this.s);
            }
            catch (UTFDataFormatException e) {
                throw new ClassFormatError("String constant too long to store in class file");
            }
        }

        public boolean equals(Object o) {
            return o instanceof ConstantUtf8Info && ((ConstantUtf8Info)o).s.equals(this.s);
        }

        public int hashCode() {
            return this.s.hashCode();
        }
    }

    public static class ConstantNameAndTypeInfo
    extends ConstantPoolInfo {
        private final short nameIndex;
        private final short descriptorIndex;

        public ConstantNameAndTypeInfo(short nameIndex, short descriptorIndex) {
            this.nameIndex = nameIndex;
            this.descriptorIndex = descriptorIndex;
        }

        public String getDescriptor(ClassFile classFile) {
            return classFile.getConstantUtf8(this.descriptorIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(12);
            dos.writeShort(this.nameIndex);
            dos.writeShort(this.descriptorIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantNameAndTypeInfo && ((ConstantNameAndTypeInfo)o).nameIndex == this.nameIndex && ((ConstantNameAndTypeInfo)o).descriptorIndex == this.descriptorIndex;
        }

        public int hashCode() {
            return this.nameIndex + (this.descriptorIndex << 16);
        }
    }

    private static class ConstantDoubleInfo
    extends ConstantValuePoolInfo {
        private final double value;

        public ConstantDoubleInfo(double value) {
            this.value = value;
        }

        @Override
        public Object getValue(ClassFile classFile) {
            return new Double(this.value);
        }

        @Override
        public boolean isWide() {
            return true;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(6);
            dos.writeDouble(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantDoubleInfo && ((ConstantDoubleInfo)o).value == this.value;
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.value);
            return (int)bits ^ (int)(bits >> 32);
        }
    }

    private static class ConstantLongInfo
    extends ConstantValuePoolInfo {
        private final long value;

        public ConstantLongInfo(long value) {
            this.value = value;
        }

        @Override
        public Object getValue(ClassFile classFile) {
            return this.value;
        }

        @Override
        public boolean isWide() {
            return true;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(5);
            dos.writeLong(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantLongInfo && ((ConstantLongInfo)o).value == this.value;
        }

        public int hashCode() {
            return (int)this.value ^ (int)(this.value >> 32);
        }
    }

    private static class ConstantFloatInfo
    extends ConstantValuePoolInfo {
        private final float value;

        public ConstantFloatInfo(float value) {
            this.value = value;
        }

        @Override
        public Object getValue(ClassFile classFile) {
            return new Float(this.value);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(4);
            dos.writeFloat(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantFloatInfo && ((ConstantFloatInfo)o).value == this.value;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.value);
        }
    }

    private static class ConstantIntegerInfo
    extends ConstantValuePoolInfo {
        private final int value;

        public ConstantIntegerInfo(int value) {
            this.value = value;
        }

        @Override
        public Object getValue(ClassFile classFile) {
            return new Integer(this.value);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(3);
            dos.writeInt(this.value);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantIntegerInfo && ((ConstantIntegerInfo)o).value == this.value;
        }

        public int hashCode() {
            return this.value;
        }
    }

    static class ConstantStringInfo
    extends ConstantValuePoolInfo {
        private final short stringIndex;

        public ConstantStringInfo(short stringIndex) {
            this.stringIndex = stringIndex;
        }

        @Override
        public Object getValue(ClassFile classFile) {
            return classFile.getConstantUtf8(this.stringIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(8);
            dos.writeShort(this.stringIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantStringInfo && ((ConstantStringInfo)o).stringIndex == this.stringIndex;
        }

        public int hashCode() {
            return this.stringIndex;
        }
    }

    public static class ConstantInterfaceMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantInterfaceMethodrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public ConstantNameAndTypeInfo getNameAndType(ClassFile classFile) {
            return (ConstantNameAndTypeInfo)classFile.getConstantPoolInfo(this.nameAndTypeIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(11);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantInterfaceMethodrefInfo && ((ConstantInterfaceMethodrefInfo)o).classIndex == this.classIndex && ((ConstantInterfaceMethodrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantMethodrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantMethodrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public ConstantNameAndTypeInfo getNameAndType(ClassFile classFile) {
            return (ConstantNameAndTypeInfo)classFile.getConstantPoolInfo(this.nameAndTypeIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(10);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantMethodrefInfo && ((ConstantMethodrefInfo)o).classIndex == this.classIndex && ((ConstantMethodrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantFieldrefInfo
    extends ConstantPoolInfo {
        private final short classIndex;
        private final short nameAndTypeIndex;

        public ConstantFieldrefInfo(short classIndex, short nameAndTypeIndex) {
            this.classIndex = classIndex;
            this.nameAndTypeIndex = nameAndTypeIndex;
        }

        public ConstantNameAndTypeInfo getNameAndType(ClassFile classFile) {
            return (ConstantNameAndTypeInfo)classFile.getConstantPoolInfo(this.nameAndTypeIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(9);
            dos.writeShort(this.classIndex);
            dos.writeShort(this.nameAndTypeIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantFieldrefInfo && ((ConstantFieldrefInfo)o).classIndex == this.classIndex && ((ConstantFieldrefInfo)o).nameAndTypeIndex == this.nameAndTypeIndex;
        }

        public int hashCode() {
            return this.classIndex + (this.nameAndTypeIndex << 16);
        }
    }

    public static class ConstantClassInfo
    extends ConstantPoolInfo {
        private final short nameIndex;

        public ConstantClassInfo(short nameIndex) {
            this.nameIndex = nameIndex;
        }

        public String getName(ClassFile classFile) {
            return classFile.getConstantUtf8(this.nameIndex);
        }

        @Override
        public boolean isWide() {
            return false;
        }

        @Override
        public void store(DataOutputStream dos) throws IOException {
            dos.writeByte(7);
            dos.writeShort(this.nameIndex);
        }

        public boolean equals(Object o) {
            return o instanceof ConstantClassInfo && ((ConstantClassInfo)o).nameIndex == this.nameIndex;
        }

        public int hashCode() {
            return this.nameIndex;
        }
    }

    public static abstract class ConstantValuePoolInfo
    extends ConstantPoolInfo {
        public abstract Object getValue(ClassFile var1);
    }

    public static abstract class ConstantPoolInfo {
        protected abstract void store(DataOutputStream var1) throws IOException;

        protected abstract boolean isWide();

        private static ConstantPoolInfo loadConstantPoolInfo(DataInputStream dis) throws IOException {
            byte tag = dis.readByte();
            switch (tag) {
                case 7: {
                    return new ConstantClassInfo(dis.readShort());
                }
                case 9: {
                    return new ConstantFieldrefInfo(dis.readShort(), dis.readShort());
                }
                case 10: {
                    return new ConstantMethodrefInfo(dis.readShort(), dis.readShort());
                }
                case 11: {
                    return new ConstantInterfaceMethodrefInfo(dis.readShort(), dis.readShort());
                }
                case 8: {
                    return new ConstantStringInfo(dis.readShort());
                }
                case 3: {
                    return new ConstantIntegerInfo(dis.readInt());
                }
                case 4: {
                    return new ConstantFloatInfo(dis.readFloat());
                }
                case 5: {
                    return new ConstantLongInfo(dis.readLong());
                }
                case 6: {
                    return new ConstantDoubleInfo(dis.readDouble());
                }
                case 12: {
                    return new ConstantNameAndTypeInfo(dis.readShort(), dis.readShort());
                }
                case 1: {
                    return new ConstantUtf8Info(dis.readUTF());
                }
            }
            throw new ClassFormatError("Invalid constant pool tag " + tag);
        }
    }
}

