/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.legacycharts;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.editor.expressions.ExpressionPropertiesTableModel;
import org.pentaho.reporting.designer.core.util.ActionToggleButton;
import org.pentaho.reporting.designer.core.util.ExpressionListCellRenderer;
import org.pentaho.reporting.designer.core.util.table.ElementMetaDataTable;
import org.pentaho.reporting.designer.core.util.table.GroupedMetaTableModel;
import org.pentaho.reporting.designer.core.util.table.GroupingModel;
import org.pentaho.reporting.designer.core.util.table.SortHeaderPanel;
import org.pentaho.reporting.designer.core.util.table.SortableTableModel;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartEditingResult;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartType;
import org.pentaho.reporting.designer.extensions.legacycharts.LegacyChartEditModel;
import org.pentaho.reporting.designer.extensions.legacycharts.LegacyChartsUtil;
import org.pentaho.reporting.designer.extensions.legacycharts.Messages;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;

public class LegacyChartEditorDialog
extends CommonDialog {
    private ExpressionPropertiesTableModel chartPropertiesTableModel;
    private ExpressionPropertiesTableModel primaryDataSourcePropertiesTableModel;
    private ExpressionPropertiesTableModel secondaryDataSourcePropertiesTableModel;
    private JTabbedPane dataSourceTabbedPane;
    private ElementMetaDataTable chartTable;
    private ElementMetaDataTable primaryDataSourceTable;
    private ElementMetaDataTable secondaryDataSourceTable;
    private LegacyChartEditModel editModel;
    private static final Expression[] EMPTY_EXPRESSION = new Expression[0];

    public LegacyChartEditorDialog() throws HeadlessException {
        this.init();
    }

    public LegacyChartEditorDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public LegacyChartEditorDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    protected void init() {
        this.setTitle(Messages.getInstance().getString("ChartEditorTitle"));
        this.editModel = new LegacyChartEditModel();
        this.editModel.addPropertyChangeListener("chartExpression", new ChartExpressionChangeHandler());
        this.editModel.addPropertyChangeListener("primaryDataSource", new PrimaryDataSourceChangeHandler());
        this.editModel.addPropertyChangeListener("secondaryDataSource", new SecondaryDataSourceChangeHandler());
        this.chartTable = new ElementMetaDataTable();
        this.chartPropertiesTableModel = new ChartExpressionPropertiesTableModel();
        this.primaryDataSourceTable = new ElementMetaDataTable();
        this.primaryDataSourcePropertiesTableModel = new ExpressionPropertiesTableModel();
        this.primaryDataSourcePropertiesTableModel.setFilterInlineExpressionProperty(true);
        this.secondaryDataSourceTable = new ElementMetaDataTable();
        this.secondaryDataSourcePropertiesTableModel = new ExpressionPropertiesTableModel();
        this.secondaryDataSourcePropertiesTableModel.setFilterInlineExpressionProperty(true);
        this.dataSourceTabbedPane = new JTabbedPane();
        this.dataSourceTabbedPane.add(Messages.getInstance().getString("PrimaryDataSource"), this.createPrimaryDataSourcePanel());
        this.dataSourceTabbedPane.add(Messages.getInstance().getString("SecondaryDataSource"), this.createSecondaryDataSourcePanel());
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Chart.LegacyChartEditor";
    }

    protected Component createContentPane() {
        JSplitPane expressionsPane = new JSplitPane(1);
        expressionsPane.setLeftComponent(this.createChartPanel());
        expressionsPane.setRightComponent(this.dataSourceTabbedPane);
        JSplitPane previewPane = new JSplitPane(0);
        previewPane.setBottomComponent(expressionsPane);
        JPanel contentPane = new JPanel();
        Border border = contentPane.getBorder();
        EmptyBorder margin = new EmptyBorder(5, 20, 0, 0);
        contentPane.setBorder(new CompoundBorder(border, margin));
        contentPane.setLayout(new BorderLayout());
        contentPane.add(this.createChartSelectorButtonPane(), "North");
        contentPane.add((Component)previewPane, "Center");
        previewPane.setDividerLocation(300);
        expressionsPane.setDividerLocation(350);
        return contentPane;
    }

    private JPanel createSecondaryDataSourcePanel() {
        JPanel innerSecondaryDataSourcePanel = new JPanel(new BorderLayout());
        innerSecondaryDataSourcePanel.add((Component)new SortHeaderPanel((SortableTableModel)this.secondaryDataSourcePropertiesTableModel), "North");
        SmartComboBox comboBox = new SmartComboBox(this.editModel.getSecondaryDataSourcesModel());
        comboBox.setRenderer(new ExpressionListCellRenderer());
        innerSecondaryDataSourcePanel.add((Component)comboBox, "Center");
        JPanel secondaryDataSourcePanel = new JPanel(new BorderLayout());
        secondaryDataSourcePanel.add((Component)innerSecondaryDataSourcePanel, "North");
        secondaryDataSourcePanel.add((Component)this.configureExpressionTable(this.secondaryDataSourceTable, (GroupingModel)this.secondaryDataSourcePropertiesTableModel), "Center");
        return secondaryDataSourcePanel;
    }

    private JPanel createPrimaryDataSourcePanel() {
        JPanel innerPrimaryDataSourcePanel = new JPanel(new BorderLayout());
        innerPrimaryDataSourcePanel.add((Component)new SortHeaderPanel((SortableTableModel)this.primaryDataSourcePropertiesTableModel), "North");
        SmartComboBox comboBox = new SmartComboBox(this.editModel.getPrimaryDataSourcesModel());
        comboBox.setRenderer(new ExpressionListCellRenderer());
        innerPrimaryDataSourcePanel.add((Component)comboBox, "Center");
        JPanel primaryDataSourcePanel = new JPanel(new BorderLayout());
        primaryDataSourcePanel.add((Component)innerPrimaryDataSourcePanel, "North");
        primaryDataSourcePanel.add((Component)this.configureExpressionTable(this.primaryDataSourceTable, (GroupingModel)this.primaryDataSourcePropertiesTableModel), "Center");
        return primaryDataSourcePanel;
    }

    private JPanel createChartPanel() {
        JPanel innerChartExpressionPanel = new JPanel(new BorderLayout());
        innerChartExpressionPanel.add((Component)new SortHeaderPanel((SortableTableModel)this.chartPropertiesTableModel), "North");
        SmartComboBox comboBox = new SmartComboBox(this.editModel.getChartExpressionsModel());
        comboBox.setRenderer(new ExpressionListCellRenderer());
        innerChartExpressionPanel.add((Component)comboBox, "Center");
        JPanel chartExpressionPanel = new JPanel(new BorderLayout());
        chartExpressionPanel.add((Component)innerChartExpressionPanel, "North");
        chartExpressionPanel.add((Component)this.configureExpressionTable(this.chartTable, (GroupingModel)this.chartPropertiesTableModel), "Center");
        return chartExpressionPanel;
    }

    private JComponent configureExpressionTable(ElementMetaDataTable table, GroupingModel dataModel) {
        table.setModel((TableModel)new GroupedMetaTableModel(dataModel));
        return new JScrollPane((Component)table);
    }

    private Component createChartSelectorButtonPane() {
        ChartType[] types = ChartType.values();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel buttonCarrier = new JPanel();
        buttonCarrier.setLayout(new FlowLayout(0, 5, 5));
        for (int i = 0; i < types.length; ++i) {
            ChartType type = types[i];
            SelectChartExpressionAction action = new SelectChartExpressionAction(type.getExpressionType());
            this.editModel.getChartExpressionsModel().addListDataListener(action);
            ActionToggleButton button = new ActionToggleButton();
            button.putClientProperty((Object)"hideActionText", (Object)Boolean.TRUE);
            button.setAction((Action)action);
            button.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
            buttonGroup.add((AbstractButton)button);
            buttonCarrier.add((Component)button);
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)buttonCarrier, "North");
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChartEditingResult performEdit(Element element, ReportDesignerContext reportDesignerContext) throws CloneNotSupportedException {
        if (element == null) {
            throw new NullPointerException();
        }
        if (reportDesignerContext == null) {
            throw new NullPointerException();
        }
        if (!LegacyChartsUtil.isLegacyChartElement(element)) {
            return null;
        }
        try {
            ChartEditingResult chartEditingResult;
            Expression originalSecondaryDataSourceExpression;
            Expression originalPrimaryDataSourceExpression;
            this.chartTable.setReportDesignerContext(reportDesignerContext);
            this.primaryDataSourceTable.setReportDesignerContext(reportDesignerContext);
            this.secondaryDataSourceTable.setReportDesignerContext(reportDesignerContext);
            this.chartPropertiesTableModel.setActiveContext(reportDesignerContext.getActiveContext());
            this.primaryDataSourcePropertiesTableModel.setActiveContext(reportDesignerContext.getActiveContext());
            this.secondaryDataSourcePropertiesTableModel.setActiveContext(reportDesignerContext.getActiveContext());
            Element editableElement = element.derive();
            Expression chartExpression = editableElement.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value");
            if (chartExpression != null) {
                originalPrimaryDataSourceExpression = this.extractPrimaryDatasource(element);
                originalSecondaryDataSourceExpression = this.extractSecondaryDatasource(element);
                this.editModel.setChartExpression(chartExpression.getInstance());
                if (originalPrimaryDataSourceExpression != null) {
                    this.editModel.setPrimaryDataSource(originalPrimaryDataSourceExpression.getInstance());
                } else {
                    this.editModel.setPrimaryDataSource(null);
                }
                if (originalSecondaryDataSourceExpression != null) {
                    this.editModel.setSecondaryDataSource(originalSecondaryDataSourceExpression.getInstance());
                } else {
                    this.editModel.setSecondaryDataSource(null);
                }
            } else {
                this.editModel.setChartExpression(null);
                this.editModel.setPrimaryDataSource(null);
                this.editModel.setSecondaryDataSource(null);
                originalPrimaryDataSourceExpression = null;
                originalSecondaryDataSourceExpression = null;
            }
            if (this.editModel.getCurrentChartType() != null) {
                ExpressionMetaData data;
                Class dataSourceImplementation;
                ChartType chartType = this.editModel.getCurrentChartType();
                if (this.editModel.getPrimaryDataSource() == null) {
                    dataSourceImplementation = chartType.getPreferredPrimaryDataSourceImplementation();
                    data = ExpressionRegistry.getInstance().getExpressionMetaData(dataSourceImplementation.getName());
                    this.editModel.getPrimaryDataSourcesModel().setSelectedItem(data);
                }
                if (this.editModel.getSecondaryDataSource() == null && (dataSourceImplementation = chartType.getPreferredSecondaryDataSourceImplementation()) != null) {
                    data = ExpressionRegistry.getInstance().getExpressionMetaData(dataSourceImplementation.getName());
                    this.editModel.getSecondaryDataSourcesModel().setSelectedItem(data);
                }
            }
            if (!this.performEdit()) {
                chartEditingResult = null;
                return chartEditingResult;
            }
            this.secondaryDataSourceTable.stopEditing();
            this.primaryDataSourceTable.stopEditing();
            this.chartTable.stopEditing();
            chartEditingResult = new ChartEditingResult(chartExpression, originalPrimaryDataSourceExpression, originalSecondaryDataSourceExpression, this.editModel.getChartExpression(), this.editModel.getPrimaryDataSource(), this.editModel.getSecondaryDataSource());
            return chartEditingResult;
        }
        finally {
            this.chartTable.setReportDesignerContext(null);
            this.primaryDataSourceTable.setReportDesignerContext(null);
            this.secondaryDataSourceTable.setReportDesignerContext(null);
            this.chartPropertiesTableModel.setActiveContext(null);
            this.primaryDataSourcePropertiesTableModel.setActiveContext(null);
            this.secondaryDataSourcePropertiesTableModel.setActiveContext(null);
        }
    }

    private Expression extractSecondaryDatasource(Element element) {
        Object secondaryDataSource = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "secondary-dataset-expression");
        Expression originalSecondaryDataSourceExpression = secondaryDataSource instanceof Expression ? (Expression)secondaryDataSource : null;
        return originalSecondaryDataSourceExpression;
    }

    private Expression extractPrimaryDatasource(Element element) {
        Object primaryDataSourceRaw = element.getAttribute("http://reporting.pentaho.org/namespaces/engine/classic/legacy/charting/1.0", "primary-dataset-expression");
        Expression originalPrimaryDataSourceExpression = primaryDataSourceRaw instanceof Expression ? (Expression)primaryDataSourceRaw : null;
        return originalPrimaryDataSourceExpression;
    }

    protected static class ChartExpressionPropertiesTableModel
    extends ExpressionPropertiesTableModel {
        public ChartExpressionPropertiesTableModel() {
            this.setFilterInlineExpressionProperty(true);
        }

        protected boolean isFiltered(ExpressionPropertyMetaData metaData) {
            if ("linesDataSource".equals(metaData.getName())) {
                return true;
            }
            if ("secondaryDataSet".equals(metaData.getName())) {
                return true;
            }
            if ("dataSource".equals(metaData.getName())) {
                return true;
            }
            return super.isFiltered(metaData);
        }
    }

    private class SecondaryDataSourceChangeHandler
    implements PropertyChangeListener {
        private SecondaryDataSourceChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"secondaryDataSource".equals(evt.getPropertyName())) {
                return;
            }
            Expression o = (Expression)evt.getNewValue();
            if (o == null) {
                LegacyChartEditorDialog.this.secondaryDataSourcePropertiesTableModel.setData(EMPTY_EXPRESSION);
                return;
            }
            LegacyChartEditorDialog.this.secondaryDataSourcePropertiesTableModel.setData(new Expression[]{o});
        }
    }

    private class PrimaryDataSourceChangeHandler
    implements PropertyChangeListener {
        private PrimaryDataSourceChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"primaryDataSource".equals(evt.getPropertyName())) {
                return;
            }
            Expression o = (Expression)evt.getNewValue();
            if (o == null) {
                LegacyChartEditorDialog.this.primaryDataSourcePropertiesTableModel.setData(EMPTY_EXPRESSION);
                return;
            }
            LegacyChartEditorDialog.this.primaryDataSourcePropertiesTableModel.setData(new Expression[]{o});
        }
    }

    private class ChartExpressionChangeHandler
    implements PropertyChangeListener {
        private ChartExpressionChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"chartExpression".equals(evt.getPropertyName())) {
                return;
            }
            Expression o = (Expression)evt.getNewValue();
            if (o == null) {
                LegacyChartEditorDialog.this.chartPropertiesTableModel.setData(EMPTY_EXPRESSION);
                LegacyChartEditorDialog.this.dataSourceTabbedPane.setEnabledAt(1, false);
                LegacyChartEditorDialog.this.dataSourceTabbedPane.setSelectedIndex(0);
                return;
            }
            LegacyChartEditorDialog.this.chartPropertiesTableModel.setData(new Expression[]{o});
            ChartType type = ChartType.getTypeByChartExpression(o.getClass());
            if (type == null) {
                LegacyChartEditorDialog.this.dataSourceTabbedPane.setEnabledAt(1, false);
                LegacyChartEditorDialog.this.dataSourceTabbedPane.setSelectedIndex(0);
                return;
            }
            LegacyChartEditorDialog.this.dataSourceTabbedPane.setEnabledAt(1, type.getSecondaryDataSourceProperty() != null);
        }
    }

    private class SelectChartExpressionAction
    extends AbstractAction
    implements ListDataListener {
        private Class expressionType;
        private Icon standardIcon;
        private Icon selectedIcon;

        private SelectChartExpressionAction(Class expressionType) {
            URL selectedIconUrl;
            String selectedIconProperty;
            URL defaultIconUrl;
            this.expressionType = expressionType;
            ExpressionRegistry expressionRegistry = ExpressionRegistry.getInstance();
            ExpressionMetaData metaData = expressionRegistry.getExpressionMetaData(expressionType.getName());
            this.putValue("Name", metaData.getMetaAttribute("short-name", Locale.getDefault()));
            String defaultIcon = metaData.getMetaAttribute("icon", Locale.getDefault());
            if (defaultIcon != null && (defaultIconUrl = LegacyChartEditorDialog.class.getResource(defaultIcon)) != null) {
                this.standardIcon = new ImageIcon(defaultIconUrl);
                this.putValue("SmallIcon", this.standardIcon);
            }
            if ((selectedIconProperty = metaData.getMetaAttribute("selected-icon", Locale.getDefault())) != null && (selectedIconUrl = LegacyChartEditorDialog.class.getResource(selectedIconProperty)) != null) {
                this.selectedIcon = new ImageIcon(selectedIconUrl);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(this.expressionType.getName());
            LegacyChartEditorDialog.this.editModel.getChartExpressionsModel().setSelectedItem(data);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ExpressionMetaData o = (ExpressionMetaData)LegacyChartEditorDialog.this.editModel.getChartExpressionsModel().getSelectedItem();
            if (o != null && this.expressionType.equals(o.getExpressionType())) {
                this.putValue("selected", Boolean.TRUE);
                this.putValue("SmallIcon", this.selectedIcon);
            } else {
                this.putValue("selected", Boolean.FALSE);
                this.putValue("SmallIcon", this.standardIcon);
            }
        }
    }
}

