/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.MemoryLocks;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;

public abstract class XCommand<T>
implements XCallable<T> {
    public static final String DEFAULT_LOCK_TIMEOUT = "oozie.command.default.lock.timeout";
    public static final String INSTRUMENTATION_GROUP = "commands";
    public static final Long DEFAULT_REQUEUE_DELAY = 10L;
    public XLog LOG = XLog.getLog(this.getClass());
    private String key;
    private String name;
    private int priority;
    private String type;
    private long createdTime;
    private MemoryLocks.LockToken lock;
    private boolean used = false;
    private Map<Long, List<XCommand<?>>> commandQueue;
    protected boolean dryrun = false;
    protected Instrumentation instrumentation;
    protected XLog.Info logInfo;

    public XCommand(String name, String type, int priority) {
        this.name = name;
        this.type = type;
        this.priority = priority;
        this.key = name + "_" + UUID.randomUUID();
        this.createdTime = System.currentTimeMillis();
        this.logInfo = new XLog.Info();
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
    }

    public XCommand(String name, String type, int priority, boolean dryrun) {
        this(name, type, priority);
        this.dryrun = dryrun;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    protected void queue(XCommand<?> command) {
        this.queue(command, 0L);
    }

    protected void queue(XCommand<?> command, long msDelay) {
        List<XCommand<?>> list;
        if (this.commandQueue == null) {
            this.commandQueue = new HashMap();
        }
        if ((list = this.commandQueue.get(msDelay)) == null) {
            list = new ArrayList();
            this.commandQueue.put(msDelay, list);
        }
        list.add(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void acquireLock() throws InterruptedException, CommandException {
        this.lock = Services.get().get(MemoryLocksService.class).getWriteLock(this.getEntityKey(), this.getLockTimeOut());
        if (this.lock == null) {
            Instrumentation instrumentation = Services.get().get(InstrumentationService.class).get();
            instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".lockTimeOut", 1L);
            if (!this.isReQueueRequired()) throw new CommandException(ErrorCode.E0606, this.toString(), this.getLockTimeOut());
            this.resetUsed();
            this.queue(this, this.getRequeueDelay());
            this.LOG.debug("Could not get lock [{0}], timed out [{1}]ms, and requeue itself [{2}]", this.toString(), this.getLockTimeOut(), this.getName());
            return;
        } else {
            this.LOG.debug("Acquired lock for [{0}] in [{1}]", this.getEntityKey(), this.getName());
        }
    }

    private void releaseLock() {
        if (this.lock != null) {
            this.lock.release();
            this.LOG.debug("Released lock for [{0}] in [{1}]", this.getEntityKey(), this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T call() throws CommandException {
        if (this.used) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already used.");
        }
        this.used = true;
        this.commandQueue = null;
        Instrumentation instrumentation = Services.get().get(InstrumentationService.class).get();
        instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".executions", 1L);
        Instrumentation.Cron callCron = new Instrumentation.Cron();
        try {
            T t;
            block18: {
                callCron.start();
                this.eagerLoadState();
                this.LOG = XLog.resetPrefix(this.LOG);
                this.eagerVerifyPrecondition();
                try {
                    T ret = null;
                    if (this.isLockRequired()) {
                        Instrumentation.Cron acquireLockCron = new Instrumentation.Cron();
                        acquireLockCron.start();
                        this.acquireLock();
                        acquireLockCron.stop();
                        instrumentation.addCron(INSTRUMENTATION_GROUP, this.getName() + ".acquireLock", acquireLockCron);
                    }
                    if (!this.isLockRequired() || this.isLockRequired() && this.lock != null) {
                        this.LOG.debug("Load state for [{0}]", this.getEntityKey());
                        this.loadState();
                        this.LOG = XLog.resetPrefix(this.LOG);
                        this.LOG.debug("Precondition check for command [{0}] key [{1}]", this.getName(), this.getEntityKey());
                        this.verifyPrecondition();
                        this.LOG.debug("Execute command [{0}] key [{1}]", this.getName(), this.getEntityKey());
                        Instrumentation.Cron executeCron = new Instrumentation.Cron();
                        executeCron.start();
                        ret = this.execute();
                        executeCron.stop();
                        instrumentation.addCron(INSTRUMENTATION_GROUP, this.getName() + ".execute", executeCron);
                    }
                    if (this.commandQueue != null) {
                        CallableQueueService callableQueueService = Services.get().get(CallableQueueService.class);
                        for (Map.Entry<Long, List<XCommand<?>>> entry : this.commandQueue.entrySet()) {
                            this.LOG.debug("Queuing [{0}] commands with delay [{1}]ms", entry.getValue().size(), entry.getKey());
                            if (callableQueueService.queueSerial(entry.getValue(), entry.getKey())) continue;
                            this.LOG.warn("Could not queue [{0}] commands with delay [{1}]ms, queue full", entry.getValue().size(), entry.getKey());
                        }
                    }
                    t = ret;
                    if (!this.isLockRequired()) break block18;
                    this.releaseLock();
                }
                catch (Throwable throwable) {
                    try {
                        if (this.isLockRequired()) {
                            this.releaseLock();
                        }
                        throw throwable;
                    }
                    catch (PreconditionException pex) {
                        this.LOG.warn(pex.getMessage().toString() + ", Error Code: " + pex.getErrorCode().toString());
                        instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".preconditionfailed", 1L);
                        T t2 = null;
                        return t2;
                    }
                    catch (XException ex) {
                        this.LOG.error((Object)"XException, ", ex);
                        instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".xexceptions", 1L);
                        if (ex instanceof CommandException) {
                            throw (CommandException)ex;
                        }
                        throw new CommandException(ex);
                    }
                    catch (Exception ex) {
                        this.LOG.error((Object)"Exception, ", ex);
                        instrumentation.incr(INSTRUMENTATION_GROUP, this.getName() + ".exceptions", 1L);
                        throw new CommandException(ErrorCode.E0607, ex);
                    }
                }
            }
            return t;
        }
        finally {
            FaultInjection.deactivate("org.apache.oozie.command.SkipCommitFaultInjection");
            callCron.stop();
            instrumentation.addCron(INSTRUMENTATION_GROUP, this.getName() + ".call", callCron);
        }
    }

    protected long getLockTimeOut() {
        return Services.get().getConf().getLong(DEFAULT_LOCK_TIMEOUT, 5000L);
    }

    protected abstract boolean isLockRequired();

    protected abstract String getEntityKey();

    protected boolean isReQueueRequired() {
        return true;
    }

    protected void eagerLoadState() throws CommandException {
    }

    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
    }

    protected abstract void loadState() throws CommandException;

    protected abstract void verifyPrecondition() throws CommandException, PreconditionException;

    protected abstract T execute() throws CommandException;

    protected Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public void resetUsed() {
        this.used = false;
    }

    protected Long getRequeueDelay() {
        return DEFAULT_REQUEUE_DELAY;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public XLog getLog() {
        return this.LOG;
    }
}

