/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AccessControlException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.AuthorizationException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class AuthorizationService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.AuthorizationService.";
    public static final String CONF_SECURITY_ENABLED = "oozie.service.AuthorizationService.security.enabled";
    public static final String ADMIN_USERS_FILE = "adminusers.txt";
    public static final String DEFAULT_GROUP = "users";
    protected static final String INSTRUMENTATION_GROUP = "authorization";
    protected static final String INSTR_FAILED_AUTH_COUNTER = "authorization.failed";
    private Set<String> adminUsers;
    private boolean securityEnabled;
    private final XLog log = XLog.getLog(this.getClass());
    private Instrumentation instrumentation;

    @Override
    public void init(Services services) throws ServiceException {
        this.adminUsers = new HashSet<String>();
        this.securityEnabled = services.getConf().getBoolean(CONF_SECURITY_ENABLED, false);
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
        if (this.securityEnabled) {
            this.log.info("Oozie running with security enabled");
            this.loadAdminUsers();
        } else {
            this.log.warn("Oozie running with security disabled");
        }
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    private void loadAdminUsers() throws ServiceException {
        block9: {
            String configDir = Services.get().get(ConfigurationService.class).getConfigDir();
            if (configDir != null) {
                File file = new File(configDir, ADMIN_USERS_FILE);
                if (file.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                        try {
                            String line = br.readLine();
                            while (line != null) {
                                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                                    this.adminUsers.add(line);
                                }
                                line = br.readLine();
                            }
                            break block9;
                        }
                        catch (IOException ex) {
                            throw new ServiceException(ErrorCode.E0160, file.getAbsolutePath(), ex);
                        }
                    }
                    catch (FileNotFoundException ex) {
                        throw new ServiceException(ErrorCode.E0160, ex);
                    }
                }
                this.log.warn("Admin users file not available in config dir [{0}], running without admin users", configDir);
            } else {
                this.log.warn("Reading configuration from classpath, running without admin users");
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return AuthorizationService.class;
    }

    protected boolean isUserInGroup(String user, String group) throws AuthorizationException {
        return true;
    }

    public void authorizeForGroup(String user, String group) throws AuthorizationException {
        if (this.securityEnabled && !this.isUserInGroup(user, group)) {
            throw new AuthorizationException(ErrorCode.E0502, user, group);
        }
    }

    public String getDefaultGroup(String user) throws AuthorizationException {
        return DEFAULT_GROUP;
    }

    protected boolean isAdmin(String user) {
        return this.adminUsers.contains(user);
    }

    public void authorizeForAdmin(String user, boolean write) throws AuthorizationException {
        if (this.securityEnabled && write && !this.isAdmin(user)) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0503, user);
        }
    }

    public void authorizeForApp(String user, String group, String appPath, Configuration jobConf) throws AuthorizationException {
        try {
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, new Path(appPath).toUri(), jobConf);
            Path path = new Path(appPath);
            try {
                if (!fs.exists(path)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0504, appPath);
                }
                Path wfXml = new Path(path, "workflow.xml");
                if (!fs.exists(wfXml)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0505, appPath);
                }
                if (!fs.isFile(wfXml)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0506, appPath);
                }
                fs.open(wfXml).close();
            }
            catch (AccessControlException ex) {
                this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                throw new AuthorizationException(ErrorCode.E0507, new Object[]{appPath, ex.getMessage(), ex});
            }
        }
        catch (IOException ex) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException e) {
            throw new AuthorizationException(e);
        }
    }

    public void authorizeForApp(String user, String group, String appPath, String fileName, Configuration conf) throws AuthorizationException {
        try {
            FileSystem fs = Services.get().get(HadoopAccessorService.class).createFileSystem(user, group, new Path(appPath).toUri(), conf);
            Path path = new Path(appPath);
            try {
                if (!fs.exists(path)) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0504, appPath);
                }
                if (conf.get("oozie.proxysubmission") == null && !fs.isFile(path)) {
                    Path appXml = new Path(path, fileName);
                    if (!fs.exists(appXml)) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0505, appPath);
                    }
                    if (!fs.isFile(appXml)) {
                        this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                        throw new AuthorizationException(ErrorCode.E0506, appPath);
                    }
                    fs.open(appXml).close();
                }
            }
            catch (AccessControlException ex) {
                this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                throw new AuthorizationException(ErrorCode.E0507, new Object[]{appPath, ex.getMessage(), ex});
            }
        }
        catch (IOException ex) {
            this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
            throw new AuthorizationException(ErrorCode.E0501, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException e) {
            throw new AuthorizationException(e);
        }
    }

    public void authorizeForJob(String user, String jobId, boolean write) throws AuthorizationException {
        if (this.securityEnabled && write && !this.isAdmin(user)) {
            if (jobId.endsWith("-W")) {
                WorkflowJobBean jobBean = null;
                JPAService jpaService = Services.get().get(JPAService.class);
                if (jpaService != null) {
                    try {
                        jobBean = jpaService.execute(new WorkflowJobGetJPAExecutor(jobId));
                    }
                    catch (JPAExecutorException je) {
                        throw new AuthorizationException(je);
                    }
                } else {
                    throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                }
                if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInGroup(user, jobBean.getGroup())) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0508, user, jobId);
                }
            } else if (jobId.endsWith("-B")) {
                BundleJobBean jobBean = null;
                JPAService jpaService = Services.get().get(JPAService.class);
                if (jpaService != null) {
                    try {
                        jobBean = jpaService.execute(new BundleJobGetJPAExecutor(jobId));
                    }
                    catch (JPAExecutorException je) {
                        throw new AuthorizationException(je);
                    }
                } else {
                    throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                }
                if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInGroup(user, jobBean.getGroup())) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0509, user, jobId);
                }
            } else {
                CoordinatorJobBean jobBean = null;
                JPAService jpaService = Services.get().get(JPAService.class);
                if (jpaService != null) {
                    try {
                        jobBean = jpaService.execute(new CoordJobGetJPAExecutor(jobId));
                    }
                    catch (JPAExecutorException je) {
                        throw new AuthorizationException(je);
                    }
                } else {
                    throw new AuthorizationException(ErrorCode.E0610, new Object[0]);
                }
                if (jobBean != null && !jobBean.getUser().equals(user) && !this.isUserInGroup(user, jobBean.getGroup())) {
                    this.incrCounter(INSTR_FAILED_AUTH_COUNTER, 1);
                    throw new AuthorizationException(ErrorCode.E0509, user, jobId);
                }
            }
        }
    }

    private void incrCounter(String name, int count) {
        if (this.instrumentation != null) {
            this.instrumentation.incr(INSTRUMENTATION_GROUP, name, count);
        }
    }
}

