/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TextRecord
extends BrighthouseRecord {
    static final String TXT_DELIMITER = ",";
    static final Character TXT_ENCLOSURE = Character.valueOf('\"');
    static final Character TXT_ESC_CHAR = Character.valueOf('\\');
    static final String NULL_STR = "\\N";
    private final byte[] lineTerminator = System.getProperty("line.separator").getBytes();
    private final String[] data;

    TextRecord(List<AbstractColumnType> columns, Charset charset) {
        super(columns, charset);
        this.data = new String[columns.size()];
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) {
                byte[] bytes = this.data[i].getBytes(this.getCharset().name());
                outputStream.write(bytes);
            }
            if (i >= this.data.length - 1) continue;
            outputStream.write(TXT_DELIMITER.getBytes());
        }
        outputStream.write(this.lineTerminator);
    }

    @Override
    public void setData(int colidx, Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.data[colidx] = NULL_STR;
            return;
        }
        AbstractColumnType type = (AbstractColumnType)this.columns.get(colidx);
        type.setData(value, meta);
        String sData = type.getDataAsString();
        if (sData == null) {
            this.data[colidx] = NULL_STR;
            return;
        }
        if (type.isNeedsEnclosures()) {
            sData = this.escapeString(sData);
        }
        this.data[colidx] = sData;
    }

    private String escapeString(String str) {
        StringBuffer buf = new StringBuffer(TXT_ENCLOSURE.toString());
        if (str.indexOf(TXT_ENCLOSURE.charValue()) >= 0 || str.indexOf(TXT_ESC_CHAR.charValue()) >= 0) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (TXT_ENCLOSURE.equals(Character.valueOf(c)) || TXT_ESC_CHAR.equals(Character.valueOf(c))) {
                    buf.append(TXT_ESC_CHAR);
                }
                buf.append(c);
            }
        } else {
            buf.append(str);
        }
        buf.append(TXT_ENCLOSURE);
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != null) {
                buf.append(this.data[i]);
            }
            if (i >= this.data.length - 1) continue;
            buf.append(TXT_DELIMITER);
        }
        return buf.toString();
    }
}

