/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;
import org.jdom.Element;

public class DistcpActionExecutor
extends JavaActionExecutor {
    public static final String CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS = "org.apache.hadoop.tools.DistCp";
    public static final String CLASS_NAMES = "oozie.actions.main.classnames";
    private static final XLog LOG = XLog.getLog(DistcpActionExecutor.class);
    public static final String DISTCP_TYPE = "distcp";

    public DistcpActionExecutor() {
        super(DISTCP_TYPE);
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        String classNameDistcp = CONF_OOZIE_DISTCP_ACTION_MAIN_CLASS;
        String name = DistcpActionExecutor.getClassNamebyType(DISTCP_TYPE);
        if (name != null) {
            classNameDistcp = name;
        }
        return launcherConf.get("oozie.launcher.action.main.class", classNameDistcp);
    }

    public static String getClassNamebyType(String type) {
        Configuration conf = Services.get().getConf();
        String classname = null;
        if (conf.get(CLASS_NAMES, "").trim().length() > 0) {
            for (String function : conf.getStrings(CLASS_NAMES)) {
                function = DistcpActionExecutor.Trim(function);
                LOG.debug("class for Distcp Action: " + function);
                String[] str = function.split("=");
                if (str.length <= 0 || !type.equalsIgnoreCase(str[0])) continue;
                classname = new String(str[1]);
            }
        }
        return classname;
    }

    public static String Trim(String str) {
        if (str != null) {
            str = str.replaceAll("\\n", "");
            str = str.replaceAll("\\t", "");
            str = str.trim();
        }
        return str;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return DISTCP_TYPE;
    }
}

