/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonUtils;
import org.apache.oozie.client.rest.JsonWorkflowAction;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.StringId;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Entity
@Table(name="WF_JOBS")
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="bean_type", discriminatorType=DiscriminatorType.STRING)
public class JsonWorkflowJob
implements WorkflowJob,
JsonBean,
PersistenceCapable {
    @Id
    private String id;
    @Basic
    @Column(name="app_name")
    private String appName = null;
    @Basic
    @Column(name="app_path")
    private String appPath = null;
    @Transient
    private String externalId = null;
    @Column(name="conf")
    @Lob
    private String conf = null;
    @Transient
    private WorkflowJob.Status status = WorkflowJob.Status.PREP;
    @Transient
    private Date createdTime;
    @Transient
    private Date startTime;
    @Transient
    private Date endTime;
    @Transient
    private Date lastModifiedTime;
    @Basic
    @Column(name="user_name")
    private String user = null;
    @Basic
    @Column(name="group_name")
    private String group;
    @Basic
    @Column(name="run")
    private int run = 1;
    @Basic
    @Column(name="parent_id")
    private String parentId;
    @Transient
    private String consoleUrl;
    @Transient
    private List<? extends JsonWorkflowAction> actions = new ArrayList<JsonWorkflowAction>();
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonWorkflowJob;
    private transient Object pcDetachedState;

    @Override
    public JSONObject toJSONObject() {
        return this.toJSONObject("GMT");
    }

    @Override
    public JSONObject toJSONObject(String timeZoneId) {
        JSONObject json = new JSONObject();
        json.put((Object)"appPath", (Object)this.getAppPath());
        json.put((Object)"appName", (Object)this.getAppName());
        json.put((Object)"id", (Object)this.getId());
        json.put((Object)"externalId", (Object)this.getExternalId());
        json.put((Object)"parentId", (Object)this.getParentId());
        json.put((Object)"conf", (Object)this.getConf());
        json.put((Object)"status", (Object)this.getStatus().toString());
        json.put((Object)"lastModTime", (Object)JsonUtils.formatDateRfc822((Date)this.getLastModifiedTime(), (String)timeZoneId));
        json.put((Object)"createdTime", (Object)JsonUtils.formatDateRfc822((Date)this.getCreatedTime(), (String)timeZoneId));
        json.put((Object)"startTime", (Object)JsonUtils.formatDateRfc822((Date)this.getStartTime(), (String)timeZoneId));
        json.put((Object)"endTime", (Object)JsonUtils.formatDateRfc822((Date)this.getEndTime(), (String)timeZoneId));
        json.put((Object)"user", (Object)this.getUser());
        json.put((Object)"group", (Object)this.getGroup());
        json.put((Object)"acl", (Object)this.getAcl());
        json.put((Object)"run", (Object)this.getRun());
        json.put((Object)"consoleUrl", (Object)this.getConsoleUrl());
        json.put((Object)"actions", (Object)JsonWorkflowAction.toJSONArray(this.actions, timeZoneId));
        json.put((Object)"toString", (Object)this.toString());
        return json;
    }

    public String getAppPath() {
        return JsonWorkflowJob.pcGetappPath(this);
    }

    public void setAppPath(String appPath) {
        JsonWorkflowJob.pcSetappPath(this, appPath);
    }

    public String getAppName() {
        return JsonWorkflowJob.pcGetappName(this);
    }

    public void setAppName(String appName) {
        JsonWorkflowJob.pcSetappName(this, appName);
    }

    public String getId() {
        return JsonWorkflowJob.pcGetid(this);
    }

    public void setId(String id) {
        JsonWorkflowJob.pcSetid(this, id);
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getConf() {
        return JsonWorkflowJob.pcGetconf(this);
    }

    public void setConf(String conf) {
        JsonWorkflowJob.pcSetconf(this, conf);
    }

    public WorkflowJob.Status getStatus() {
        return this.status;
    }

    public void setStatus(WorkflowJob.Status status) {
        this.status = status;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(Date lastModTime) {
        this.lastModifiedTime = lastModTime;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getUser() {
        return JsonWorkflowJob.pcGetuser(this);
    }

    public void setUser(String user) {
        JsonWorkflowJob.pcSetuser(this, user);
    }

    public String getGroup() {
        return JsonWorkflowJob.pcGetgroup(this);
    }

    public String getAcl() {
        return this.getGroup();
    }

    public void setGroup(String group) {
        JsonWorkflowJob.pcSetgroup(this, group);
    }

    public int getRun() {
        return JsonWorkflowJob.pcGetrun(this);
    }

    public void setRun(int run) {
        JsonWorkflowJob.pcSetrun(this, run);
    }

    public String getConsoleUrl() {
        return this.consoleUrl;
    }

    public String getParentId() {
        return JsonWorkflowJob.pcGetparentId(this);
    }

    public void setParentId(String parentId) {
        JsonWorkflowJob.pcSetparentId(this, parentId);
    }

    public void setConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
    }

    public List<WorkflowAction> getActions() {
        return this.actions;
    }

    public void setActions(List<? extends JsonWorkflowAction> nodes) {
        this.actions = nodes != null ? nodes : new ArrayList();
    }

    public String toString() {
        return MessageFormat.format("Workflow id[{0}] status[{1}]", this.getId(), this.getStatus());
    }

    public static JSONArray toJSONArray(List<? extends JsonWorkflowJob> workflows, String timeZoneId) {
        JSONArray array = new JSONArray();
        if (workflows != null) {
            for (JsonWorkflowJob jsonWorkflowJob : workflows) {
                array.add((Object)jsonWorkflowJob.toJSONObject(timeZoneId));
            }
        }
        return array;
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"appName", "appPath", "conf", "group", "id", "parentId", "run", "user"};
        Class[] classArray = new Class[8];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        classArray[6] = Integer.TYPE;
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JsonWorkflowJob.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz2 = class$Lorg$apache$oozie$client$rest$JsonWorkflowJob != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowJob : (class$Lorg$apache$oozie$client$rest$JsonWorkflowJob = JsonWorkflowJob.class$("org.apache.oozie.client.rest.JsonWorkflowJob"));
        PCRegistry.register((Class)clazz2, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JsonWorkflowJob", (PersistenceCapable)new JsonWorkflowJob());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.appName = null;
        this.appPath = null;
        this.conf = null;
        this.group = null;
        this.id = null;
        this.parentId = null;
        this.run = 0;
        this.user = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JsonWorkflowJob jsonWorkflowJob = new JsonWorkflowJob();
        if (bl) {
            jsonWorkflowJob.pcClearFields();
        }
        jsonWorkflowJob.pcStateManager = stateManager;
        jsonWorkflowJob.pcCopyKeyFieldsFromObjectId(object);
        return jsonWorkflowJob;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JsonWorkflowJob jsonWorkflowJob = new JsonWorkflowJob();
        if (bl) {
            jsonWorkflowJob.pcClearFields();
        }
        jsonWorkflowJob.pcStateManager = stateManager;
        return jsonWorkflowJob;
    }

    protected static int pcGetManagedFieldCount() {
        return 8;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.appPath = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.conf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.group = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.id = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.parentId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.run = this.pcStateManager.replaceIntField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.user = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appName);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.appPath);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.conf);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.group);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.id);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.parentId);
                return;
            }
            case 6: {
                this.pcStateManager.providedIntField((PersistenceCapable)this, n, this.run);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.user);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JsonWorkflowJob jsonWorkflowJob, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.appName = jsonWorkflowJob.appName;
                return;
            }
            case 1: {
                this.appPath = jsonWorkflowJob.appPath;
                return;
            }
            case 2: {
                this.conf = jsonWorkflowJob.conf;
                return;
            }
            case 3: {
                this.group = jsonWorkflowJob.group;
                return;
            }
            case 4: {
                this.id = jsonWorkflowJob.id;
                return;
            }
            case 5: {
                this.parentId = jsonWorkflowJob.parentId;
                return;
            }
            case 6: {
                this.run = jsonWorkflowJob.run;
                return;
            }
            case 7: {
                this.user = jsonWorkflowJob.user;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JsonWorkflowJob jsonWorkflowJob = (JsonWorkflowJob)object;
        if (jsonWorkflowJob.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jsonWorkflowJob, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        StringId stringId = (StringId)object;
        fieldConsumer.storeStringField(4 + pcInheritedFieldCount, stringId.getId());
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        StringId stringId = (StringId)object;
        this.id = stringId.getId();
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowJob != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowJob : (class$Lorg$apache$oozie$client$rest$JsonWorkflowJob = JsonWorkflowJob.class$("org.apache.oozie.client.rest.JsonWorkflowJob"));
        return new StringId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowJob != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowJob : (class$Lorg$apache$oozie$client$rest$JsonWorkflowJob = JsonWorkflowJob.class$("org.apache.oozie.client.rest.JsonWorkflowJob"));
        return new StringId(clazz, this.id);
    }

    private static final String pcGetappName(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.appName;
        }
        int n = pcInheritedFieldCount + 0;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.appName;
    }

    private static final void pcSetappName(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.appName = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 0, jsonWorkflowJob.appName, string, 0);
    }

    private static final String pcGetappPath(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.appPath;
        }
        int n = pcInheritedFieldCount + 1;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.appPath;
    }

    private static final void pcSetappPath(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.appPath = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 1, jsonWorkflowJob.appPath, string, 0);
    }

    private static final String pcGetconf(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.conf;
        }
        int n = pcInheritedFieldCount + 2;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.conf;
    }

    private static final void pcSetconf(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.conf = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 2, jsonWorkflowJob.conf, string, 0);
    }

    private static final String pcGetgroup(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.group;
        }
        int n = pcInheritedFieldCount + 3;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.group;
    }

    private static final void pcSetgroup(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.group = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 3, jsonWorkflowJob.group, string, 0);
    }

    private static final String pcGetid(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.id;
        }
        int n = pcInheritedFieldCount + 4;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.id;
    }

    private static final void pcSetid(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.id = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 4, jsonWorkflowJob.id, string, 0);
    }

    private static final String pcGetparentId(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.parentId;
        }
        int n = pcInheritedFieldCount + 5;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.parentId;
    }

    private static final void pcSetparentId(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.parentId = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 5, jsonWorkflowJob.parentId, string, 0);
    }

    private static final int pcGetrun(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.run;
        }
        int n = pcInheritedFieldCount + 6;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.run;
    }

    private static final void pcSetrun(JsonWorkflowJob jsonWorkflowJob, int n) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.run = n;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingIntField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 6, jsonWorkflowJob.run, n, 0);
    }

    private static final String pcGetuser(JsonWorkflowJob jsonWorkflowJob) {
        if (jsonWorkflowJob.pcStateManager == null) {
            return jsonWorkflowJob.user;
        }
        int n = pcInheritedFieldCount + 7;
        jsonWorkflowJob.pcStateManager.accessingField(n);
        return jsonWorkflowJob.user;
    }

    private static final void pcSetuser(JsonWorkflowJob jsonWorkflowJob, String string) {
        if (jsonWorkflowJob.pcStateManager == null) {
            jsonWorkflowJob.user = string;
            return;
        }
        jsonWorkflowJob.pcStateManager.settingStringField((PersistenceCapable)jsonWorkflowJob, pcInheritedFieldCount + 7, jsonWorkflowJob.user, string, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        return Boolean.FALSE;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }
}

