/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;

public class CoordActionUpdatePushMissingDependency
extends CoordPushDependencyCheckXCommand {
    public CoordActionUpdatePushMissingDependency(String actionId) {
        super("coord_action_push_md", actionId);
    }

    @Override
    protected Void execute() throws CommandException {
        this.LOG.info("STARTED for Action id [{0}]", this.actionId);
        String pushMissingDeps = this.coordAction.getPushMissingDependencies();
        if (pushMissingDeps == null || pushMissingDeps.length() == 0) {
            this.LOG.info("Nothing to check. Empty push missing dependency");
        } else {
            PartitionDependencyManagerService pdms = Services.get().get(PartitionDependencyManagerService.class);
            Collection<String> availDepList = pdms.getAvailableDependencyURIs(this.actionId);
            if (availDepList == null || availDepList.size() == 0) {
                this.LOG.info("There are no available dependencies");
                if (this.isTimeout()) {
                    this.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId()), 100L);
                }
            } else {
                this.LOG.debug("Updating with available uris=[{0}] where missing uris=[{1}]", availDepList.toString(), pushMissingDeps);
                String[] missingDepsArray = DependencyChecker.dependenciesAsArray(pushMissingDeps);
                ArrayList<String> stillMissingDepsList = new ArrayList<String>(Arrays.asList(missingDepsArray));
                stillMissingDepsList.removeAll(availDepList);
                boolean isChangeInDependency = true;
                if (stillMissingDepsList.size() == 0) {
                    this.onAllPushDependenciesAvailable();
                } else {
                    if (stillMissingDepsList.size() == missingDepsArray.length) {
                        isChangeInDependency = false;
                    } else {
                        String stillMissingDeps = DependencyChecker.dependenciesAsString(stillMissingDepsList);
                        this.coordAction.setPushMissingDependencies(stillMissingDeps);
                    }
                    if (this.isTimeout()) {
                        this.queue(new CoordPushDependencyCheckXCommand(this.coordAction.getId()), 100L);
                    }
                }
                this.updateCoordAction(this.coordAction, isChangeInDependency);
                this.removeAvailableDependencies(pdms, availDepList);
                this.LOG.info("ENDED for Action id [{0}]", this.actionId);
            }
        }
        return null;
    }

    private void removeAvailableDependencies(PartitionDependencyManagerService pdms, Collection<String> availDepList) {
        if (pdms.removeAvailableDependencyURIs(this.actionId, availDepList)) {
            this.LOG.debug("Successfully removed uris [{0}] from available list", availDepList.toString());
        } else {
            this.LOG.warn("Failed to remove uris [{0}] from available list", availDepList.toString(), this.actionId);
        }
    }

    @Override
    public String getEntityKey() {
        return this.actionId;
    }
}

